/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.remoteconfig.RemoteConfigUtil;
import com.google.firebase.remoteconfig.User;
import com.google.firebase.remoteconfig.internal.TemplateResponse;
import java.text.ParseException;
import java.util.Objects;

public final class Version {
    private final String versionNumber;
    private final long updateTime;
    private final String updateOrigin;
    private final String updateType;
    private final User updateUser;
    private final String rollbackSource;
    private final boolean legacy;
    private String description;

    private Version() {
        this.versionNumber = null;
        this.updateTime = 0L;
        this.updateOrigin = null;
        this.updateType = null;
        this.updateUser = null;
        this.rollbackSource = null;
        this.legacy = false;
    }

    Version(@NonNull TemplateResponse.VersionResponse versionResponse) {
        Preconditions.checkNotNull((Object)versionResponse);
        this.versionNumber = versionResponse.getVersionNumber();
        if (!Strings.isNullOrEmpty((String)versionResponse.getUpdateTime())) {
            try {
                this.updateTime = RemoteConfigUtil.convertToMilliseconds(versionResponse.getUpdateTime());
            }
            catch (ParseException e) {
                throw new IllegalStateException("Unable to parse update time.", e);
            }
        } else {
            this.updateTime = 0L;
        }
        this.updateOrigin = versionResponse.getUpdateOrigin();
        this.updateType = versionResponse.getUpdateType();
        TemplateResponse.UserResponse userResponse = versionResponse.getUpdateUser();
        this.updateUser = userResponse != null ? new User(userResponse) : null;
        this.description = versionResponse.getDescription();
        this.rollbackSource = versionResponse.getRollbackSource();
        this.legacy = versionResponse.isLegacy();
    }

    public static Version withDescription(String description) {
        return new Version().setDescription(description);
    }

    @Nullable
    public String getVersionNumber() {
        return this.versionNumber;
    }

    @Nullable
    public long getUpdateTime() {
        return this.updateTime;
    }

    @Nullable
    public String getUpdateOrigin() {
        return this.updateOrigin;
    }

    @Nullable
    public String getUpdateType() {
        return this.updateType;
    }

    @Nullable
    public User getUpdateUser() {
        return this.updateUser;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getRollbackSource() {
        return this.rollbackSource;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public Version setDescription(String description) {
        this.description = description;
        return this;
    }

    TemplateResponse.VersionResponse toVersionResponse(boolean includeAll) {
        TemplateResponse.VersionResponse versionResponse = new TemplateResponse.VersionResponse().setDescription(this.description);
        if (includeAll) {
            versionResponse.setUpdateTime(this.updateTime > 0L ? RemoteConfigUtil.convertToUtcDateFormat(this.updateTime) : null).setLegacy(this.legacy).setRollbackSource(this.rollbackSource).setUpdateOrigin(this.updateOrigin).setUpdateType(this.updateType).setUpdateUser(this.updateUser == null ? null : this.updateUser.toUserResponse()).setVersionNumber(this.versionNumber);
        }
        return versionResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.updateTime == version.updateTime && this.legacy == version.legacy && Objects.equals(this.versionNumber, version.versionNumber) && Objects.equals(this.updateOrigin, version.updateOrigin) && Objects.equals(this.updateType, version.updateType) && Objects.equals(this.updateUser, version.updateUser) && Objects.equals(this.description, version.description) && Objects.equals(this.rollbackSource, version.rollbackSource);
    }

    public int hashCode() {
        return Objects.hash(this.versionNumber, this.updateTime, this.updateOrigin, this.updateType, this.updateUser, this.description, this.rollbackSource, this.legacy);
    }
}

