/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import javax.swing.tree.TreePath;
import org.netbeans.modules.search.Bundle;
import org.netbeans.modules.search.Item;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.TextDisplayer;
import org.netbeans.modules.search.TextFetcher;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ContextView
extends JPanel {
    private static final String FILE_VIEW = "file view";
    private static final String MESSAGE_VIEW = "message view";
    private static final int FILE_SIZE_LIMIT = 0x800000;
    private final CardLayout cardLayout;
    private final JEditorPane editorPane = new JEditorPane();
    private final JScrollPane editorScroll;
    private final JLabel lblPath = new JLabel();
    private final JLabel lblMessage = new JLabel();
    private final Displayer displayer = new Displayer();
    private final RequestProcessor requestProcessor = new RequestProcessor("TextView", 5, true);
    private ResultModel resultModel;
    private RequestProcessor.Task task = null;
    private TextFetcher textFetcher = null;
    private String displayedCard = null;
    private String msgNoFileSelected = null;
    private String msgMultipleFilesSelected = null;
    private String editorMimeType = null;
    ExplorerManager explorerManager;
    private Boolean allApproved = null;
    private static boolean approveApplyToAllSelected = false;
    private static boolean lastApproveOption = false;
    private final Map<FileObject, Boolean> APPROVED_FILES = new WeakHashMap<FileObject, Boolean>();

    public ContextView(ResultModel resultModel, ExplorerManager explorerManager) {
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("controlShadow")), BorderFactory.createEmptyBorder(5, 5, 1, 5));
        this.lblPath.setBorder(compoundBorder);
        this.editorPane.setEditable(false);
        this.editorPane.getCaret().setBlinkRate(0);
        this.editorScroll = new JScrollPane(this.editorPane);
        this.editorScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        this.editorScroll.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.lblPath, "North");
        jPanel.add((Component)this.editorScroll, "Center");
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalGlue());
        box.add(this.lblMessage);
        box.add(Box.createVerticalGlue());
        this.lblMessage.setAlignmentX(0.5f);
        this.lblMessage.setHorizontalAlignment(0);
        this.lblMessage.setEnabled(false);
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.add((Component)jPanel, FILE_VIEW);
        this.add((Component)box, MESSAGE_VIEW);
        this.setResultModel(resultModel);
        this.explorerManager = explorerManager;
        explorerManager.addPropertyChangeListener(propertyChangeEvent -> {
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                this.updateForSelection();
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        dimension.width = 0;
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResultModel(ResultModel resultModel) {
        if (resultModel == this.resultModel) {
            return;
        }
        ContextView contextView = this;
        synchronized (contextView) {
            if (this.textFetcher != null) {
                this.textFetcher.cancel();
                this.textFetcher = null;
            }
        }
        this.resultModel = resultModel;
    }

    private void displaySelectedFiles(JTree jTree) {
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0) {
            this.displayNoFileSelected();
        } else if (treePathArray.length > 1) {
            this.displayMultipleItemsSelected();
        } else {
            assert (treePathArray.length == 1);
            TreePath treePath = treePathArray[0];
            int n = treePath.getPathCount();
            if (n == 1) {
                this.displayNoFileSelected();
            } else {
                int n2;
                MatchingObject matchingObject;
                assert (n == 2 || n == 3);
                if (n == 2) {
                    matchingObject = (MatchingObject)treePath.getLastPathComponent();
                    n2 = -1;
                } else {
                    TreePath treePath2 = treePath.getParentPath();
                    matchingObject = (MatchingObject)treePath2.getLastPathComponent();
                    int n3 = jTree.getRowForPath(treePath2);
                    int n4 = jTree.getRowForPath(treePath);
                    n2 = n4 - n3 - 1;
                }
                this.displayFile(matchingObject, n2);
            }
        }
    }

    private void displayNoFileSelected() {
        if (this.msgNoFileSelected == null) {
            this.msgNoFileSelected = NbBundle.getMessage(this.getClass(), (String)"MsgNoFileSelected");
        }
        this.displayMessage(this.msgNoFileSelected);
    }

    private void displayMultipleItemsSelected() {
        if (this.msgMultipleFilesSelected == null) {
            this.msgMultipleFilesSelected = NbBundle.getMessage(this.getClass(), (String)"MsgMultipleFilesSelected");
        }
        this.displayMessage(this.msgMultipleFilesSelected);
    }

    private void displayMessage(String string) {
        this.lblMessage.setText(string);
        if (this.displayedCard != MESSAGE_VIEW) {
            this.displayedCard = MESSAGE_VIEW;
            this.cardLayout.show(this, MESSAGE_VIEW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayFile(MatchingObject matchingObject, int n) {
        assert (EventQueue.isDispatchThread());
        Displayer displayer = this.displayer;
        synchronized (displayer) {
            Object object;
            FileObject fileObject;
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
            if ((fileObject = matchingObject.getFileObject()).getSize() > 0x800000L) {
                object = this.APPROVED_FILES.get(fileObject);
                if (this.allApproved == null && object == null) {
                    this.approveFetchingOfBigFile(matchingObject, n);
                    return;
                }
                if (Boolean.FALSE.equals(object) || Boolean.FALSE.equals(this.allApproved)) {
                    this.displayMessage(Bundle.MSG_ContextView_fileTooBig());
                    return;
                }
            }
            object = new Item(this.resultModel, matchingObject, n);
            MatchingObject.InvalidityStatus invalidityStatus = matchingObject.checkValidity();
            if (invalidityStatus != null) {
                this.displayMessage(invalidityStatus.getDescription(matchingObject.getFileObject().getPath()));
                return;
            }
            this.requestText((Item)object, this.displayer);
            String string = matchingObject.getDescription();
            this.lblPath.setText(string);
            this.lblPath.setToolTipText(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestText(Item item, TextDisplayer textDisplayer) {
        assert (EventQueue.isDispatchThread());
        ContextView contextView = this;
        synchronized (contextView) {
            if (this.textFetcher != null) {
                if (this.textFetcher.replaceLocation(item, textDisplayer)) {
                    return;
                }
                this.textFetcher.cancel();
                this.textFetcher = null;
            }
            if (this.textFetcher == null) {
                this.textFetcher = new TextFetcher(item, textDisplayer, this.requestProcessor);
            }
        }
    }

    private void updateForSelection() {
        Node[] nodeArray = this.explorerManager.getSelectedNodes();
        if (nodeArray.length == 0) {
            this.displayNoFileSelected();
        } else if (nodeArray.length == 1) {
            Node node = nodeArray[0];
            MatchingObject matchingObject = (MatchingObject)node.getLookup().lookup(MatchingObject.class);
            if (matchingObject != null) {
                this.displayFile(matchingObject, -1);
            } else {
                Node node2 = node.getParentNode();
                TextDetail textDetail = (TextDetail)node.getLookup().lookup(TextDetail.class);
                if (textDetail != null && node2 != null) {
                    matchingObject = (MatchingObject)node2.getLookup().lookup(MatchingObject.class);
                    if (matchingObject != null) {
                        int n = -1;
                        for (int i = 0; i < matchingObject.getTextDetails().size(); ++i) {
                            if (matchingObject.getTextDetails().get(i) != textDetail) continue;
                            n = i;
                            break;
                        }
                        this.displayFile(matchingObject, n);
                    }
                } else {
                    this.displayNoFileSelected();
                }
            }
        } else {
            this.displayMultipleItemsSelected();
        }
    }

    private void approveFetchingOfBigFile(MatchingObject matchingObject, int n) {
        FileObject fileObject = matchingObject.getFileObject();
        long l = fileObject.getSize() / 1024L;
        JButton jButton = new JButton(Bundle.LBL_ContextView_Show());
        JButton jButton2 = new JButton(Bundle.LBL_ContextView_Skip());
        JCheckBox jCheckBox = new JCheckBox(Bundle.LBL_ContextView_ApplyAll());
        jCheckBox.setSelected(approveApplyToAllSelected);
        JPanel jPanel = new JPanel();
        jPanel.add(jCheckBox);
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)Bundle.MSG_ContextView_showBigFile(fileObject.getNameExt(), l), Bundle.TTL_ContextView_showBigFile(), 0, 2, new Object[]{jButton2, jButton}, (Object)(lastApproveOption ? jButton : jButton2));
        notifyDescriptor.setAdditionalOptions(new Object[]{jPanel});
        DialogDisplayer.getDefault().notify(notifyDescriptor);
        boolean bl = notifyDescriptor.getValue() == jButton;
        this.APPROVED_FILES.put(fileObject, bl);
        if (jCheckBox.isSelected()) {
            this.allApproved = bl;
        }
        approveApplyToAllSelected = jCheckBox.isSelected();
        lastApproveOption = bl;
        this.displayFile(matchingObject, n);
    }

    private class Displayer
    implements TextDisplayer,
    Runnable {
        private TextDetail location;

        private Displayer() {
        }

        @Override
        public void setText(String string, String string2, TextDetail textDetail) {
            assert (EventQueue.isDispatchThread());
            if ("content/unknown".equals(string2)) {
                string2 = "text/plain";
            }
            if (ContextView.this.editorMimeType == null || !ContextView.this.editorMimeType.equals(string2)) {
                ContextView.this.editorPane.setContentType(string2);
                ContextView.this.editorMimeType = string2;
            }
            ContextView.this.editorPane.setText(string);
            if (ContextView.this.displayedCard != ContextView.FILE_VIEW) {
                ContextView.this.cardLayout.show(ContextView.this, ContextView.this.displayedCard = ContextView.FILE_VIEW);
            }
            if (textDetail != null) {
                this.location = textDetail;
                EventQueue.invokeLater(this);
            } else {
                this.scrollToTop();
            }
        }

        @Override
        public void run() {
            assert (EventQueue.isDispatchThread());
            boolean bl = false;
            try {
                if (!ContextView.this.editorPane.isShowing()) {
                    return;
                }
                if (this.location != null) {
                    Document document = ContextView.this.editorPane.getDocument();
                    if (document instanceof StyledDocument) {
                        StyledDocument styledDocument = (StyledDocument)document;
                        int n = this.getCursorOffset((StyledDocument)document, this.location.getLine() - 1);
                        int n2 = n + this.location.getColumn() - 1;
                        int n3 = n2 + this.location.getMarkLength();
                        ContextView.this.editorPane.setSelectionStart(n2);
                        ContextView.this.editorPane.setSelectionEnd(n3);
                        Rectangle rectangle = ContextView.this.editorPane.modelToView(n2);
                        if (rectangle != null) {
                            ContextView.this.editorPane.scrollRectToVisible(rectangle);
                            bl = true;
                        }
                    }
                    ContextView.this.editorPane.getCaret().setBlinkRate(0);
                    ContextView.this.editorPane.repaint();
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
            }
            if (!bl) {
                this.scrollToTop();
            }
        }

        private int getCursorOffset(StyledDocument styledDocument, int n) {
            assert (EventQueue.isDispatchThread());
            assert (n >= 0);
            try {
                return NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument);
                int n2 = element.getElementCount();
                if (n >= n2) {
                    return NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n2 - 1));
                }
                throw indexOutOfBoundsException;
            }
        }

        private void scrollToTop() {
            JScrollBar jScrollBar = ContextView.this.editorScroll.getHorizontalScrollBar();
            jScrollBar.setValue(jScrollBar.getMinimum());
            jScrollBar = ContextView.this.editorScroll.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMinimum());
        }
    }
}

