/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.viewer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.visualvm.core.datasource.Storage;

class ExternalViewerLauncher
implements Runnable {
    private static final String COMMAND_STRINGS_REGEX = "'[^']*'|\"[^\"]*\"|\\S+";
    private final List<String> command;

    ExternalViewerLauncher(List<String> command) {
        this.command = command;
    }

    @Override
    public final void run() {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(this.command);
        builder.directory(Storage.getTemporaryStorageDirectory());
        try {
            builder.start();
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    protected void failed(IOException e) {
    }

    public static List<String> getCommandStrings(String commandString) {
        ArrayList<String> command = new ArrayList<String>();
        Pattern pattern = Pattern.compile(COMMAND_STRINGS_REGEX);
        Matcher matcher = pattern.matcher(commandString);
        while (matcher.find()) {
            command.add(matcher.group());
        }
        return command;
    }
}

