/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.util.Collection;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.params.ExtensionParams;
import org.zaproxy.zap.extension.params.HtmlParameterStats;
import org.zaproxy.zap.extension.params.SiteParameters;
import org.zaproxy.zap.utils.ApiUtils;

public class ParamsAPI
extends ApiImplementor {
    private static final String PREFIX = "params";
    private static final String VIEW_PARAMS = "params";
    private static final String VIEW_PARAMS_PARAM_SITE = "site";
    private ExtensionParams extension;

    public ParamsAPI(ExtensionParams extension) {
        this.extension = extension;
        this.addApiView(new ApiView("params", new String[0], new String[]{VIEW_PARAMS_PARAM_SITE}));
    }

    @Override
    public String getPrefix() {
        return "params";
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        if ("params".equals(name)) {
            String paramSite;
            ApiResponseList result = new ApiResponseList("Parameters");
            if (params.containsKey(VIEW_PARAMS_PARAM_SITE) && !(paramSite = params.getString(VIEW_PARAMS_PARAM_SITE)).isEmpty()) {
                String site = ApiUtils.getAuthority(paramSite);
                if (!this.extension.hasSite(site)) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, paramSite);
                }
                if (this.extension.hasParameters(site)) {
                    result.addItem(ParamsAPI.createSiteParamStatsResponse(this.extension.getSiteParameters(site)));
                }
                return result;
            }
            Collection<SiteParameters> siteParams = this.extension.getAllSiteParameters();
            for (SiteParameters siteParam : siteParams) {
                result.addItem(ParamsAPI.createSiteParamStatsResponse(siteParam));
            }
            return result;
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    private static ApiResponseList createSiteParamStatsResponse(SiteParameters siteParam) {
        ApiResponseList stats = new ApiResponseList("Parameter");
        for (HtmlParameterStats param : siteParam.getParams()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(VIEW_PARAMS_PARAM_SITE, param.getSite());
            map.put("name", param.getName());
            map.put("type", param.getType().name());
            map.put("timesUsed", String.valueOf(param.getTimesUsed()));
            stats.addItem(new ApiResponseSet("Stats", map));
            ApiResponseList flags = new ApiResponseList("Flags");
            for (String flag : param.getFlags()) {
                flags.addItem(new ApiResponseElement("Flag", flag));
            }
            if (param.getFlags().size() > 0) {
                stats.addItem(flags);
            }
            ApiResponseList vals = new ApiResponseList("Values");
            for (String value : param.getValues()) {
                vals.addItem(new ApiResponseElement("Value", value));
            }
            if (param.getValues().size() <= 0) continue;
            stats.addItem(vals);
        }
        return stats;
    }
}

