/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.JXColorSelectionButton;
import org.jdesktop.swingx.util.PaintUtils;

public class EyeDropperColorChooserPanel
extends AbstractColorChooserPanel {
    private JButton activeColor;
    private JButton eyeDropper;
    private JTextField hexColor;
    private JLabel jLabel1;
    private JPanel magPanel;
    private JTextField rgbColor;

    public static void main(String ... args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JColorChooser chooser = new JColorChooser();
                chooser.addChooserPanel(new EyeDropperColorChooserPanel());
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                frame.add(chooser);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public EyeDropperColorChooserPanel() {
        this.initComponents();
        MouseInputAdapter mia = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                Point pt = evt.getPoint();
                SwingUtilities.convertPointToScreen(pt, evt.getComponent());
                ((MagnifyingPanel)EyeDropperColorChooserPanel.this.magPanel).setMagPoint(pt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                Color newColor = new Color(((MagnifyingPanel)EyeDropperColorChooserPanel.this.magPanel).activeColor);
                EyeDropperColorChooserPanel.this.getColorSelectionModel().setSelectedColor(newColor);
            }
        };
        this.eyeDropper.addMouseListener(mia);
        this.eyeDropper.addMouseMotionListener(mia);
        try {
            this.eyeDropper.setIcon(new ImageIcon(EyeDropperColorChooserPanel.class.getResource("mag.png")));
            this.eyeDropper.setText("");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.magPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Color color = new Color(((MagnifyingPanel)EyeDropperColorChooserPanel.this.magPanel).activeColor);
                EyeDropperColorChooserPanel.this.activeColor.setBackground(color);
                EyeDropperColorChooserPanel.this.hexColor.setText(PaintUtils.toHexString(color).substring(1));
                EyeDropperColorChooserPanel.this.rgbColor.setText(color.getRed() + "," + color.getGreen() + "," + color.getBlue());
            }
        });
    }

    private void initComponents() {
        this.eyeDropper = new JButton();
        this.magPanel = new MagnifyingPanel();
        this.activeColor = new JXColorSelectionButton();
        this.hexColor = new JTextField();
        JTextArea jTextArea1 = new JTextArea();
        this.jLabel1 = new JLabel();
        this.rgbColor = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.eyeDropper.setText("eye");
        this.add((Component)this.eyeDropper, new GridBagConstraints());
        this.magPanel.setLayout(new BorderLayout());
        this.magPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.magPanel.setMinimumSize(new Dimension(100, 100));
        this.magPanel.setPreferredSize(new Dimension(100, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.magPanel, gridBagConstraints);
        this.activeColor.setEnabled(false);
        this.activeColor.setPreferredSize(new Dimension(40, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.activeColor, gridBagConstraints);
        this.hexColor.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.hexColor, gridBagConstraints);
        jTextArea1.setColumns(20);
        jTextArea1.setEditable(false);
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(5);
        jTextArea1.setText("Drag the magnifying glass to select a color from the screen.");
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        this.add((Component)jTextArea1, gridBagConstraints);
        this.jLabel1.setText("#");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.rgbColor.setEditable(false);
        this.rgbColor.setText("255,255,255");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.rgbColor, gridBagConstraints);
        jLabel2.setText("RGB");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)jLabel2, gridBagConstraints);
    }

    @Override
    public void updateChooser() {
    }

    @Override
    protected void buildChooser() {
    }

    @Override
    public String getDisplayName() {
        return "Grab from Screen";
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return new ImageIcon();
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return new ImageIcon();
    }

    private class MagnifyingPanel
    extends JPanel {
        private Point2D point;
        private int activeColor;

        private MagnifyingPanel() {
        }

        public void setMagPoint(Point2D point) {
            this.point = point;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.point != null) {
                Rectangle rect = new Rectangle((int)this.point.getX() - 10, (int)this.point.getY() - 10, 20, 20);
                try {
                    BufferedImage img = new Robot().createScreenCapture(rect);
                    g.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), null);
                    int oldColor = this.activeColor;
                    this.activeColor = img.getRGB(img.getWidth() / 2, img.getHeight() / 2);
                    this.firePropertyChange("activeColor", oldColor, this.activeColor);
                }
                catch (AWTException ex) {
                    ex.printStackTrace();
                }
            }
            g.setColor(Color.black);
            g.drawRect(this.getWidth() / 2 - 5, this.getHeight() / 2 - 5, 10, 10);
        }
    }
}

