/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRecentProjectCachedBranch;
import git4idea.repo.GitRecentProjectsBranchesService;
import git4idea.repo.GitRefUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lgit4idea/repo/GitRecentProjectsBranchesService;", "Lcom/intellij/openapi/Disposable;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "appMessageBusConnection", "Lcom/intellij/util/messages/SimpleMessageBusConnection;", "cache", "Lcom/github/benmanes/caffeine/cache/AsyncLoadingCache;", "", "Lgit4idea/repo/GitRecentProjectCachedBranch;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "recentProjectsTopic", "Lcom/intellij/ide/RecentProjectsManager$RecentProjectsChange;", "updateRecentProjectsSignal", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "dispose", "getCurrentBranch", "projectPath", "BranchesLoader", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRecentProjectsBranchesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRecentProjectsBranchesProvider.kt\ngit4idea/repo/GitRecentProjectsBranchesService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,151:1\n23#2:152\n*S KotlinDebug\n*F\n+ 1 GitRecentProjectsBranchesProvider.kt\ngit4idea/repo/GitRecentProjectsBranchesService\n*L\n103#1:152\n*E\n"})
public final class GitRecentProjectsBranchesService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final RecentProjectsManager.RecentProjectsChange recentProjectsTopic;
    @NotNull
    private final SimpleMessageBusConnection appMessageBusConnection;
    @NotNull
    private final MutableSharedFlow<Unit> updateRecentProjectsSignal;
    @NotNull
    private final AsyncLoadingCache<String, GitRecentProjectCachedBranch> cache;
    private static final Duration REFRESH_IN = Duration.ofSeconds(30L);
    private static final Duration EXPIRE_IN = Duration.ofSeconds(60L);
    @NotNull
    private static final Logger LOG;

    public GitRecentProjectsBranchesService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.recentProjectsTopic = (RecentProjectsManager.RecentProjectsChange)ApplicationKt.getApplication().getMessageBus().syncPublisher(RecentProjectsManager.Companion.getRECENT_PROJECTS_CHANGE_TOPIC());
        this.appMessageBusConnection = ApplicationKt.getApplication().getMessageBus().simpleConnect();
        this.updateRecentProjectsSignal = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        AsyncLoadingCache asyncLoadingCache = Caffeine.newBuilder().refreshAfterWrite(REFRESH_IN).expireAfterAccess(EXPIRE_IN).executor((Executor)AppExecutorUtil.getAppExecutorService()).buildAsync((AsyncCacheLoader)new BranchesLoader());
        Intrinsics.checkNotNullExpressionValue((Object)asyncLoadingCache, (String)"buildAsync(...)");
        this.cache = asyncLoadingCache;
        Topic topic = ApplicationActivationListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        this.appMessageBusConnection.subscribe(topic, (Object)new ApplicationActivationListener(){

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                Intrinsics.checkNotNullParameter((Object)ideFrame, (String)"ideFrame");
                Project project = ideFrame.getProject();
                boolean bl = project != null ? project.isDefault() : false;
                if (bl) {
                    cache.synchronous().refreshAll((Iterable)cache.asMap().keySet());
                }
            }
        });
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GitRecentProjectsBranchesService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)FlowKt.debounce((Flow)((Flow)this.this$0.updateRecentProjectsSignal), (long)50L), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ GitRecentProjectsBranchesService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ GitRecentProjectsBranchesService this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.this$0.recentProjectsTopic.change();
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull Unit p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @Nullable
    public final String getCurrentBranch(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        CompletableFuture branchFuture = this.cache.get((Object)projectPath);
        GitRecentProjectCachedBranch.Unknown unknown = branchFuture.getNow(GitRecentProjectCachedBranch.Unknown.INSTANCE);
        GitRecentProjectCachedBranch.KnownBranch knownBranch = unknown instanceof GitRecentProjectCachedBranch.KnownBranch ? (GitRecentProjectCachedBranch.KnownBranch)((Object)unknown) : null;
        return knownBranch != null ? knownBranch.getBranchName() : null;
    }

    public void dispose() {
        this.appMessageBusConnection.disconnect();
        this.cache.synchronous().invalidateAll();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Companion $this$thisLogger$iv = Companion;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J*\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lgit4idea/repo/GitRecentProjectsBranchesService$BranchesLoader;", "Lcom/github/benmanes/caffeine/cache/AsyncCacheLoader;", "", "Lgit4idea/repo/GitRecentProjectCachedBranch;", "(Lgit4idea/repo/GitRecentProjectsBranchesService;)V", "asyncLoad", "Ljava/util/concurrent/CompletableFuture;", "key", "executor", "Ljava/util/concurrent/Executor;", "asyncReload", "oldValue", "loadBranch", "projectPath", "previousValue", "intellij.vcs.git"})
    private final class BranchesLoader
    implements AsyncCacheLoader<String, GitRecentProjectCachedBranch> {
        @Nullable
        public CompletableFuture<GitRecentProjectCachedBranch> asyncLoad(@NotNull String key, @NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            return this.loadBranch(key, null, executor);
        }

        @Nullable
        public CompletableFuture<GitRecentProjectCachedBranch> asyncReload(@NotNull String key, @NotNull GitRecentProjectCachedBranch oldValue, @NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            return this.loadBranch(key, oldValue, executor);
        }

        private final CompletableFuture<GitRecentProjectCachedBranch> loadBranch(String projectPath, GitRecentProjectCachedBranch previousValue, Executor executor) {
            return FutureKt.future$default((CoroutineScope)GitRecentProjectsBranchesService.this.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GitRecentProjectCachedBranch>, Object>(previousValue, projectPath, null){
                int label;
                final /* synthetic */ GitRecentProjectCachedBranch $previousValue;
                final /* synthetic */ String $projectPath;
                {
                    this.$previousValue = $previousValue;
                    this.$projectPath = $projectPath;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = GitRecentProjectsBranchesService.Companion.loadBranch$intellij_vcs_git(this.$previousValue, this.$projectPath, (Continuation<? super GitRecentProjectCachedBranch>)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GitRecentProjectCachedBranch> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null).whenCompleteAsync((arg_0, arg_1) -> BranchesLoader.loadBranch$lambda$0((Function2)new Function2<GitRecentProjectCachedBranch, Throwable, Unit>(previousValue, GitRecentProjectsBranchesService.this){
                final /* synthetic */ GitRecentProjectCachedBranch $previousValue;
                final /* synthetic */ GitRecentProjectsBranchesService this$0;
                {
                    this.$previousValue = $previousValue;
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(GitRecentProjectCachedBranch branch, Throwable throwable) {
                    if (branch != null && !Intrinsics.areEqual((Object)branch, (Object)this.$previousValue)) {
                        GitRecentProjectsBranchesService.access$getUpdateRecentProjectsSignal$p(this.this$0).tryEmit((Object)Unit.INSTANCE);
                    }
                }
            }, arg_0, arg_1), executor);
        }

        private static final void loadBranch$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0, p1);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0082@\u00a2\u0006\u0002\u0010\u0012J\"\u0010\u0013\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0081@\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lgit4idea/repo/GitRecentProjectsBranchesService$Companion;", "", "()V", "EXPIRE_IN", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "REFRESH_IN", "findGitHead", "Ljava/nio/file/Path;", "projectPath", "", "findGitRootFor", "path", "getBranch", "Lgit4idea/repo/GitRecentProjectCachedBranch;", "headFile", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadBranch", "previousValue", "loadBranch$intellij_vcs_git", "(Lgit4idea/repo/GitRecentProjectCachedBranch;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitRecentProjectsBranchesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRecentProjectsBranchesProvider.kt\ngit4idea/repo/GitRecentProjectsBranchesService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @VisibleForTesting
        @Nullable
        public final Object loadBranch$intellij_vcs_git(@Nullable GitRecentProjectCachedBranch var1_1, @NotNull String var2_2, @NotNull Continuation<? super GitRecentProjectCachedBranch> var3_3) {
            if (!(var3_3 instanceof loadBranch.1)) ** GOTO lbl-1000
            var9_4 = var3_3;
            if ((var9_4.label & -2147483648) != 0) {
                var9_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.loadBranch$intellij_vcs_git(null, null, (Continuation<? super GitRecentProjectCachedBranch>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (Intrinsics.areEqual((Object)previousValue, (Object)GitRecentProjectCachedBranch.Unknown.INSTANCE)) {
                        return previousValue;
                    }
                    v0 = previousValue;
                    if (v0 == null || (v0 = v0.getHeadFilePath()) == null) ** GOTO lbl24
                    p0 = v0;
                    $i$a$-let-GitRecentProjectsBranchesService$Companion$loadBranch$headFile$1 = false;
                    v1 = Path.of(p0, new String[0]);
                    v0 = v1;
                    if (v1 != null) ** GOTO lbl25
lbl24:
                    // 2 sources

                    v0 = this.findGitHead((String)projectPath);
lbl25:
                    // 2 sources

                    headFile = v0;
                    $continuation.label = 1;
                    v2 = this.getBranch((Path)headFile, (Continuation<? super GitRecentProjectCachedBranch>)$continuation);
                    ** if (v2 != var10_6) goto lbl30
lbl29:
                    // 1 sources

                    return var10_6;
lbl30:
                    // 1 sources

                    ** GOTO lbl36
                }
                case 1: {
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl36:
                        // 2 sources

                        var4_9 = (GitRecentProjectCachedBranch)v2;
                    }
                    catch (Exception e) {
                        GitRecentProjectsBranchesService.access$getLOG$cp().warn("Failed to detect git branch", (Throwable)e);
                        var4_9 = GitRecentProjectCachedBranch.Unknown.INSTANCE;
                    }
                    return var4_9;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object getBranch(Path var1_1, Continuation<? super GitRecentProjectCachedBranch> var2_2) {
            if (!(var2_2 instanceof getBranch.1)) ** GOTO lbl-1000
            var6_3 = var2_2;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return git4idea.repo.GitRecentProjectsBranchesService$Companion.access$getBranch(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (headFile == null) {
                        return GitRecentProjectCachedBranch.Unknown.INSTANCE;
                    }
                    $continuation.L$0 = headFile;
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(headFile, null){
                        int label;
                        final /* synthetic */ Path $headFile;
                        {
                            this.$headFile = $headFile;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    return ((Object)StringsKt.trim((CharSequence)PathsKt.readText$default((Path)this.$headFile, null, (int)1, null))).toString();
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    headFile = (Path)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    v1 = GitRefUtil.parseHash(headFileContent = (String)v0) == null ? GitRefUtil.getTarget(headFileContent) : null;
                    if (v1 == null) {
                        return new GitRecentProjectCachedBranch.NotOnBranch(headFile.toAbsolutePath().toString());
                    }
                    targetRef = v1;
                    v2 = GitBranchUtil.stripRefsPrefix(targetRef);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"stripRefsPrefix(...)");
                    return new GitRecentProjectCachedBranch.KnownBranch(v2, headFile.toAbsolutePath().toString());
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final Path findGitHead(String projectPath) {
            Path path = Paths.get(projectPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Path path2 = this.findGitRootFor(path);
            if (path2 == null) {
                return null;
            }
            Path gitRoot = path2;
            return gitRoot.resolve(".git").resolve("HEAD");
        }

        private final Path findGitRootFor(Path path) {
            Object v0;
            block1: {
                Sequence sequence = SequencesKt.generateSequence((Object)path, (Function1)findGitRootFor.1.INSTANCE);
                for (Object e : sequence) {
                    Path it = (Path)e;
                    boolean bl = false;
                    if (!GitUtil.isGitRoot(it)) continue;
                    v0 = e;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public static final /* synthetic */ Object access$getBranch(Companion $this, Path headFile, Continuation $completion) {
            return $this.getBranch(headFile, (Continuation<? super GitRecentProjectCachedBranch>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

