/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.validators.GitRefNameValidator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitRefUtil {
    private static final Logger LOG = Logger.getInstance(GitRefUtil.class);
    private static final Pattern BRANCH_PATTERN = Pattern.compile(" *(?:ref:)? */?((?:refs/heads/|refs/remotes/)?\\S+)");

    @Contract(value="null -> null;!null -> !null")
    @Nullable
    public static String addRefsHeadsPrefixIfNeeded(@Nullable String branchName) {
        if (branchName != null && !branchName.startsWith("refs/heads/")) {
            return "refs/heads/" + branchName;
        }
        return branchName;
    }

    @ApiStatus.Internal
    @Nullable
    public static Pair<String, String> parseBranchesLine(@NotNull String line) {
        Pair<String, String> parsedRef;
        if (line == null) {
            GitRefUtil.$$$reportNull$$$0(0);
        }
        if ((parsedRef = GitRefUtil.parseRefsLine(line)) == null) {
            return null;
        }
        String branch = (String)parsedRef.first;
        if (!branch.startsWith("refs/heads/") && !branch.startsWith("refs/remotes/")) {
            return null;
        }
        return parsedRef;
    }

    @Nullable
    public static Pair<String, String> parseRefsLine(@NotNull String line) {
        int i;
        if (line == null) {
            GitRefUtil.$$$reportNull$$$0(1);
        }
        if ((line = line.trim()).isEmpty()) {
            return null;
        }
        char firstChar = line.charAt(0);
        if (firstChar == '#') {
            return null;
        }
        if (firstChar == '^') {
            return null;
        }
        String hash = null;
        for (i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            hash = line.substring(0, i);
            break;
        }
        if (hash == null) {
            LOG.warn("Ignoring invalid packed-refs line: [" + line + "]");
            return null;
        }
        String branch = null;
        int start = i;
        if (Character.isWhitespace(line.charAt(start++))) {
            char c;
            for (i = start; i < line.length() && !Character.isWhitespace(c = line.charAt(i)); ++i) {
            }
            branch = line.substring(start, i);
        }
        if (branch == null) {
            return null;
        }
        return Pair.create(branch, (Object)hash.trim());
    }

    @NotNull
    public static Map<String, String> readFromRefsFiles(@NotNull File refsRootDir, @NotNull String prefix, GitRepositoryFiles repositoryFiles) {
        if (refsRootDir == null) {
            GitRefUtil.$$$reportNull$$$0(2);
        }
        if (prefix == null) {
            GitRefUtil.$$$reportNull$$$0(3);
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        BiConsumer<String, String> collectingConsumer = (s, s2) -> result2.put((String)s, (String)s2);
        GitRefUtil.readFromRefsFiles(refsRootDir, prefix, repositoryFiles, collectingConsumer);
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            GitRefUtil.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @Nullable
    public static GitReference getCurrentReference(GitRepository repository) {
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch != null) {
            return currentBranch;
        }
        String currentRevision = repository.getCurrentRevision();
        if (currentRevision != null) {
            return repository.getTagHolder().getTag(currentRevision);
        }
        return null;
    }

    public static void readFromRefsFiles(@NotNull File refsRootDir, @NotNull String prefix, GitRepositoryFiles repositoryFiles, BiConsumer<String, String> consumer2) {
        if (refsRootDir == null) {
            GitRefUtil.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            GitRefUtil.$$$reportNull$$$0(6);
        }
        if (!refsRootDir.exists()) {
            return;
        }
        Ref couldNotLoadFile = Ref.create((Object)false);
        FileUtil.processFilesRecursively((File)refsRootDir, file2 -> {
            String relativePath;
            if (!file2.isDirectory() && !GitRefUtil.isHidden(file2) && (relativePath = FileUtil.getRelativePath((File)refsRootDir, (File)file2)) != null) {
                String branchName = prefix + FileUtil.toSystemIndependentName((String)relativePath);
                boolean isBranchNameValid = GitRefNameValidator.getInstance().checkInput(branchName);
                if (isBranchNameValid) {
                    String hash = GitRefUtil.loadHashFromBranchFile(file2);
                    if (hash != null) {
                        consumer2.accept(branchName, hash);
                    } else {
                        couldNotLoadFile.set((Object)true);
                    }
                }
            }
            return true;
        }, dir -> !GitRefUtil.isHidden(dir));
        if (((Boolean)couldNotLoadFile.get()).booleanValue()) {
            GitRefUtil.logDebugAllRefsFiles(repositoryFiles);
        }
    }

    private static boolean isHidden(@NotNull File file2) {
        if (file2 == null) {
            GitRefUtil.$$$reportNull$$$0(7);
        }
        return file2.getName().startsWith(".");
    }

    @Nullable
    public static String loadHashFromBranchFile(@NotNull File branchFile) {
        if (branchFile == null) {
            GitRefUtil.$$$reportNull$$$0(8);
        }
        return DvcsUtil.tryLoadFileOrReturn((File)branchFile, null);
    }

    public static void logDebugAllRefsFiles(GitRepositoryFiles gitRepositoryFiles) {
        File refsHeadsFile = gitRepositoryFiles.getRefsHeadsFile();
        File refsRemotesFile = gitRepositoryFiles.getRefsRemotesFile();
        File refsTagsFile = gitRepositoryFiles.getRefsTagsFile();
        LOG.debug("Logging .git/refs files. .git/refs/heads " + (refsHeadsFile.exists() ? "exists" : "doesn't exist") + ".git/refs/remotes " + (refsRemotesFile.exists() ? "exists" : "doesn't exist") + ".git/refs/tags " + (refsTagsFile.exists() ? "exists" : "doesn't exist"));
        if (LOG.isDebugEnabled()) {
            GitRefUtil.logDebugAllFilesIn(refsHeadsFile);
            GitRefUtil.logDebugAllFilesIn(refsRemotesFile);
            GitRefUtil.logDebugAllFilesIn(refsTagsFile);
            File packedRefsPath = gitRepositoryFiles.getPackedRefsPath();
            if (packedRefsPath.exists()) {
                try {
                    LOG.debug("packed-refs file content: [\n" + FileUtil.loadFile((File)packedRefsPath) + "\n]");
                }
                catch (IOException e) {
                    LOG.debug("Couldn't load the file " + packedRefsPath, (Throwable)e);
                }
            } else {
                LOG.debug("The file " + packedRefsPath + " doesn't exist.");
            }
        }
    }

    public static void logDebugAllFilesIn(@NotNull File dir) {
        if (dir == null) {
            GitRefUtil.$$$reportNull$$$0(9);
        }
        ArrayList paths = new ArrayList();
        FileUtil.processFilesRecursively((File)dir, file2 -> {
            if (!file2.isDirectory()) {
                paths.add(FileUtil.getRelativePath((File)dir, (File)file2));
            }
            return true;
        });
        LOG.debug("Files in " + dir + ": " + paths);
    }

    @NotNull
    static Map<String, Hash> resolveRefs(@NotNull Map<String, String> data2) {
        if (data2 == null) {
            GitRefUtil.$$$reportNull$$$0(10);
        }
        Map<String, Hash> resolved = GitRefUtil.getResolvedHashes(data2);
        Map unresolved = ContainerUtil.filter(data2, refName -> !resolved.containsKey(refName));
        boolean progressed = true;
        while (progressed && !unresolved.isEmpty()) {
            progressed = false;
            Iterator iterator = unresolved.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String refName2 = (String)entry.getKey();
                String refValue = (String)entry.getValue();
                String link = GitRefUtil.getTarget(refValue);
                if (link != null) {
                    if (GitRefUtil.duplicateEntry(resolved, refName2, refValue)) {
                        iterator.remove();
                        continue;
                    }
                    if (!resolved.containsKey(link)) {
                        LOG.debug("Unresolved symbolic link [" + refName2 + "] pointing to [" + refValue + "]");
                        continue;
                    }
                    Hash targetValue = resolved.get(link);
                    resolved.put(refName2, targetValue);
                    iterator.remove();
                    progressed = true;
                    continue;
                }
                LOG.warn("Unexpected record [" + refName2 + "] -> [" + refValue + "]");
                iterator.remove();
            }
        }
        if (!unresolved.isEmpty()) {
            LOG.warn("Cyclic symbolic links among .git/refs: " + unresolved);
        }
        Map<String, Hash> map2 = resolved;
        if (map2 == null) {
            GitRefUtil.$$$reportNull$$$0(11);
        }
        return map2;
    }

    @NotNull
    public static Map<String, Hash> getResolvedHashes(@NotNull Map<String, String> data2) {
        if (data2 == null) {
            GitRefUtil.$$$reportNull$$$0(12);
        }
        HashMap<String, Hash> resolved = new HashMap<String, Hash>();
        for (Map.Entry<String, String> entry : data2.entrySet()) {
            String refName = entry.getKey();
            Hash hash = GitRefUtil.parseHash(entry.getValue());
            if (hash == null || GitRefUtil.duplicateEntry(resolved, refName, hash)) continue;
            resolved.put(refName, hash);
        }
        HashMap<String, Hash> hashMap = resolved;
        if (hashMap == null) {
            GitRefUtil.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    @Nullable
    static String getTarget(@NotNull String refName) {
        Matcher matcher;
        if (refName == null) {
            GitRefUtil.$$$reportNull$$$0(14);
        }
        if (!(matcher = BRANCH_PATTERN.matcher(refName)).matches()) {
            return null;
        }
        Object target = matcher.group(1);
        if (!((String)target).startsWith("refs/heads/") && !((String)target).startsWith("refs/remotes/")) {
            target = "refs/heads/" + (String)target;
        }
        return target;
    }

    @Nullable
    static Hash parseHash(@NotNull String value) {
        if (value == null) {
            GitRefUtil.$$$reportNull$$$0(15);
        }
        try {
            return HashImpl.build((String)value);
        }
        catch (Exception e) {
            return null;
        }
    }

    static boolean duplicateEntry(@NotNull Map<String, Hash> resolved, @NotNull String refName, @NotNull Object newValue2) {
        if (resolved == null) {
            GitRefUtil.$$$reportNull$$$0(16);
        }
        if (refName == null) {
            GitRefUtil.$$$reportNull$$$0(17);
        }
        if (newValue2 == null) {
            GitRefUtil.$$$reportNull$$$0(18);
        }
        if (resolved.containsKey(refName)) {
            LOG.error("Duplicate entry for [" + refName + "]. resolved: [" + resolved.get(refName).asString() + "], current: " + newValue2 + "]");
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsRootDir";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 4: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitRefUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitRefUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromRefsFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveRefs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedHashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseBranchesLine";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseRefsLine";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readFromRefsFiles";
                break;
            }
            case 4: 
            case 11: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadHashFromBranchFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logDebugAllFilesIn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveRefs";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedHashes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseHash";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "duplicateEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 11, 13 -> new IllegalStateException(string);
        };
    }
}

