/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.patterns;

import ai.grazie.nlp.patterns.MatchPattern;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.utils.CharUtils;
import ai.grazie.nlp.utils.RangesKt;
import ai.grazie.nlp.utils.Symbols;
import ai.grazie.text.ExtensionsKt;
import ai.grazie.text.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019J\u0010\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0000H\u0016J\u0010\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\u0000H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000bH&J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001a\u00c0\u0006\u0001"}, d2={"Lai/grazie/nlp/patterns/Pattern;", "Lai/grazie/nlp/patterns/MatchPattern;", "after", "pattern", "Lkotlin/text/Regex;", "afterWordBoundary", "before", "beforeWordBoundary", "contains", "", "text", "", "exclude", "other", "find", "", "Lai/grazie/text/TextRange;", "isMiddleApostrophe", "offset", "", "isWordBoundaryBefore", "matches", "withWordBoundariesAround", "After", "Before", "Exclusion", "nlp-patterns"})
@SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1747#2,3:117\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern\n*L\n14#1:117,3\n*E\n"})
public interface Pattern
extends MatchPattern {
    @NotNull
    public List<TextRange> find(@NotNull CharSequence var1);

    default public boolean contains(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return !((Collection)this.find(text2)).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public boolean matches(@NotNull CharSequence text2) {
        TextRange it;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List<TextRange> ranges = this.find(text2);
        if (((Collection)ranges).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$any$iv = ranges;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (TextRange)element$iv;
            boolean bl2 = false;
        } while (!it.covers(ExtensionsKt.getRange(text2)));
        return true;
    }

    @NotNull
    default public Pattern exclude(@NotNull Pattern other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Exclusion(this, other);
    }

    private boolean isWordBoundaryBefore(CharSequence text2, int offset) {
        if (offset == 0 || offset == text2.length()) {
            return true;
        }
        if (this.isMiddleApostrophe(text2, offset - 1)) {
            return false;
        }
        char c1 = text2.charAt(offset - 1);
        char c2 = text2.charAt(offset);
        return Character.isLetterOrDigit(c1) != Character.isLetterOrDigit(c2) || CharsKt.isWhitespace((char)c1) != CharsKt.isWhitespace((char)c2) || c1 != c2 && CharUtils.INSTANCE.isPunctuation(c1) && CharUtils.INSTANCE.isPunctuation(c2);
    }

    private boolean isMiddleApostrophe(CharSequence text2, int offset) {
        return offset > 0 && Character.isLetter(text2.charAt(offset - 1)) && Character.isLetter(text2.charAt(offset + 1)) && Symbols.INSTANCE.getApostrophes().contains(Character.valueOf(text2.charAt(offset)));
    }

    @NotNull
    default public Pattern before(@NotNull Regex pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return new Before(this, pattern){
            final /* synthetic */ Regex $pattern;
            {
                this.$pattern = $pattern;
                super($receiver);
            }

            public boolean suffixMatches(@NotNull CharSequence text2, int at) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return this.$pattern.matchesAt(text2, at);
            }
        };
    }

    @NotNull
    default public Pattern beforeWordBoundary() {
        return new Before(this){
            final /* synthetic */ Pattern this$0;
            {
                this.this$0 = $receiver;
                super($receiver);
            }

            public boolean suffixMatches(@NotNull CharSequence text2, int at) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return Pattern.access$isWordBoundaryBefore(this.this$0, text2, at);
            }
        };
    }

    @NotNull
    default public Pattern after(@NotNull Regex pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return new After(this, pattern);
    }

    @NotNull
    default public Pattern afterWordBoundary() {
        return new Pattern(this){
            final /* synthetic */ Pattern this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<TextRange> find(@NotNull CharSequence text2) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Iterable iterable = this.this$0.find(text2);
                Pattern pattern = this.this$0;
                boolean $i$f$filter = false;
                void var5_5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    TextRange it = (TextRange)element$iv$iv;
                    boolean bl = false;
                    if (!Pattern.access$isWordBoundaryBefore(pattern, text2, it.getStart())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            public boolean matches(@NotNull CharSequence text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return this.this$0.matches(text2);
            }
        };
    }

    @NotNull
    default public Pattern withWordBoundariesAround() {
        return this.beforeWordBoundary().afterWordBoundary();
    }

    public static /* synthetic */ boolean access$isWordBoundaryBefore(Pattern $this, CharSequence text2, int offset) {
        return $this.isWordBoundaryBefore(text2, offset);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lai/grazie/nlp/patterns/Pattern$After;", "Lai/grazie/nlp/patterns/Pattern;", "pattern", "prev", "Lkotlin/text/Regex;", "(Lai/grazie/nlp/patterns/Pattern;Lkotlin/text/Regex;)V", "getPattern", "()Lai/grazie/nlp/patterns/Pattern;", "getPrev", "()Lkotlin/text/Regex;", "find", "", "Lai/grazie/text/TextRange;", "text", "", "matches", "", "nlp-patterns"})
    @SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$After\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n766#2:117\n857#2,2:118\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$After\n*L\n107#1:117\n107#1:118,2\n*E\n"})
    private static final class After
    implements Pattern {
        @NotNull
        private final Pattern pattern;
        @NotNull
        private final Regex prev;

        public After(@NotNull Pattern pattern, @NotNull Regex prev) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
            this.pattern = pattern;
            this.prev = prev;
        }

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        @NotNull
        public final Regex getPrev() {
            return this.prev;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<TextRange> find(@NotNull CharSequence text2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            List<TextRange> ranges = this.pattern.find(text2);
            if (ranges.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Set prefixMatchEnds2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)this.prev, (CharSequence)text2, (int)0, (int)2, null), (Function1)find.prefixMatchEnds.1.INSTANCE));
            Iterable $this$filter$iv = ranges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TextRange range2 = (TextRange)element$iv$iv;
                boolean bl = false;
                if (!prefixMatchEnds2.contains(range2.getStart())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            if (!this.pattern.matches(text2)) return false;
            MatchResult matchResult = this.prev.matchAt(text2, 0);
            MatchResult matchResult2 = matchResult;
            if (matchResult == null) return false;
            IntRange intRange = matchResult2.getRange();
            matchResult2 = intRange;
            if (intRange == null) return false;
            if (RangesKt.getLength((IntRange)matchResult2) != 0) return false;
            return true;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH&R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lai/grazie/nlp/patterns/Pattern$Before;", "Lai/grazie/nlp/patterns/Pattern;", "pattern", "(Lai/grazie/nlp/patterns/Pattern;)V", "getPattern", "()Lai/grazie/nlp/patterns/Pattern;", "find", "", "Lai/grazie/text/TextRange;", "text", "", "matches", "", "suffixMatches", "at", "", "nlp-patterns"})
    @SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$Before\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n766#2:117\n857#2,2:118\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\nai/grazie/nlp/patterns/Pattern$Before\n*L\n91#1:117\n91#1:118,2\n*E\n"})
    private static abstract class Before
    implements Pattern {
        @NotNull
        private final Pattern pattern;

        public Before(@NotNull Pattern pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
        }

        @NotNull
        public final Pattern getPattern() {
            return this.pattern;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<TextRange> find(@NotNull CharSequence text2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            List<TextRange> ranges = this.pattern.find(text2);
            if (ranges.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$filter$iv = ranges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TextRange range2 = (TextRange)element$iv$iv;
                boolean bl = false;
                if (!this.suffixMatches(text2, range2.getEndExclusive())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Override
        public boolean matches(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return this.pattern.matches(text2) && this.suffixMatches(text2, text2.length());
        }

        public abstract boolean suffixMatches(@NotNull CharSequence var1, int var2);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/grazie/nlp/patterns/Pattern$Exclusion;", "Lai/grazie/nlp/patterns/Pattern;", "main", "exclude", "(Lai/grazie/nlp/patterns/Pattern;Lai/grazie/nlp/patterns/Pattern;)V", "find", "", "Lai/grazie/text/TextRange;", "text", "", "matches", "", "nlp-patterns"})
    public static final class Exclusion
    implements Pattern {
        @NotNull
        private final Pattern main;
        @NotNull
        private final Pattern exclude;

        public Exclusion(@NotNull Pattern main, @NotNull Pattern exclude) {
            Intrinsics.checkNotNullParameter((Object)main, (String)"main");
            Intrinsics.checkNotNullParameter((Object)exclude, (String)"exclude");
            this.main = main;
            this.exclude = exclude;
        }

        @Override
        @NotNull
        public List<TextRange> find(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            List<TextRange> matches = this.main.find(text2);
            Set exclusion = CollectionsKt.toSet((Iterable)this.exclude.find(text2));
            return CollectionsKt.minus((Iterable)matches, (Iterable)exclusion);
        }

        @Override
        public boolean matches(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return this.main.matches(text2) && !this.exclude.matches(text2);
        }
    }
}

