/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsCheckoutProcessor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectSetProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class VcsProjectSetProcessor
extends ProjectSetProcessor {
    private static final Logger LOG = Logger.getInstance(VcsProjectSetProcessor.class);

    public String getId() {
        return "vcs";
    }

    public void processEntries(final @NotNull List<? extends Pair<String, String>> entries, final @NotNull ProjectSetProcessor.Context context, final @NotNull Runnable runNext) {
        if (entries == null) {
            VcsProjectSetProcessor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            VcsProjectSetProcessor.$$$reportNull$$$0(1);
        }
        if (runNext == null) {
            VcsProjectSetProcessor.$$$reportNull$$$0(2);
        }
        if (!VcsProjectSetProcessor.getDirectory(context)) {
            return;
        }
        if (!VcsProjectSetProcessor.getDirectoryName(context)) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, VcsBundle.message((String)"progress.title.hey", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Pair pair : entries) {
                    String vcs = (String)pair.getFirst();
                    VcsCheckoutProcessor processor2 = VcsCheckoutProcessor.getProcessor((String)vcs);
                    if (processor2 == null) {
                        LOG.error("Checkout processor not found for " + vcs);
                        return;
                    }
                    JsonElement element = new JsonParser().parse((String)pair.getSecond());
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                        JsonElement value = (JsonElement)entry.getValue();
                        parameters.put((String)entry.getKey(), value instanceof JsonPrimitive ? value.getAsString() : value.toString());
                    }
                    Object directoryName = context.directoryName;
                    if (parameters.get("targetDir") != null) {
                        directoryName = (String)directoryName + "/" + (String)parameters.get("targetDir");
                    }
                    if (processor2.checkout(parameters, context.directory, (String)directoryName)) continue;
                    return;
                }
                runNext.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/VcsProjectSetProcessor$1", "run"));
            }
        });
    }

    private static boolean getDirectoryName(@NotNull ProjectSetProcessor.Context context) {
        if (context == null) {
            VcsProjectSetProcessor.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            context.directoryName = "test";
            return true;
        }
        context.directoryName = Messages.showInputDialog((Project)null, (String)VcsBundle.message((String)"dialog.message.enter.directory.name", (Object[])new Object[]{context.directory.getName()}), (String)VcsBundle.message((String)"dialog.title.project.directory.name", (Object[])new Object[0]), null, (String)context.directoryName, null);
        return context.directoryName != null;
    }

    private static boolean getDirectory(@NotNull ProjectSetProcessor.Context context) {
        if (context == null) {
            VcsProjectSetProcessor.$$$reportNull$$$0(4);
        }
        if (context.directory != null) {
            return true;
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        descriptor.setTitle(VcsBundle.message((String)"dialog.title.select.destination.folder", (Object[])new Object[0]));
        descriptor.setDescription("");
        VirtualFile[] files2 = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, null, null);
        context.directory = files2.length == 0 ? null : files2[0];
        return context.directory != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runNext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/VcsProjectSetProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processEntries";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDirectoryName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

