/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListDataKt;
import com.intellij.openapi.vcs.changes.ChangeListDecorator;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangeListRemoteState;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserChangeListNode
extends ChangesBrowserNode<ChangeList> {
    private final Project myProject;
    private final ChangeListManagerEx myClManager;
    private final ChangeListRemoteState myChangeListRemoteState;

    public ChangesBrowserChangeListNode(Project project, ChangeList userObject, ChangeListRemoteState changeListRemoteState) {
        super(userObject);
        this.myProject = project;
        this.myChangeListRemoteState = changeListRemoteState;
        this.myClManager = ChangeListManagerEx.getInstanceEx(project);
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Object object;
        if (renderer == null) {
            ChangesBrowserChangeListNode.$$$reportNull$$$0(0);
        }
        if ((object = this.userObject) instanceof LocalChangeList) {
            LocalChangeList list = (LocalChangeList)object;
            String listName = list.getName();
            if (StringUtil.isEmptyOrSpaces((String)listName)) {
                listName = VcsBundle.message((String)"changes.nodetitle.empty.changelist.name", (Object[])new Object[0]);
            }
            renderer.appendTextWithIssueLinks(listName, list.isDefault() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (ChangeListDataKt.getChangeListData(list) != null) {
                renderer.append(" (i)", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                renderer.setToolTipText(this.getTooltipText());
            }
            this.appendCount(renderer);
            for (ChangeListDecorator decorator : ChangeListDecorator.getDecorators((Project)this.myProject)) {
                decorator.decorateChangeList(list, (ColoredTreeCellRenderer)renderer, selected, expanded, hasFocus);
            }
            String freezed = this.myClManager.isFreezed();
            if (freezed != null) {
                renderer.append(FontUtil.spaceAndThinSpace() + freezed, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else if (this.myClManager.isInUpdate()) {
                this.appendUpdatingState(renderer);
            }
            if (!this.myChangeListRemoteState.allUpToDate()) {
                renderer.append(FontUtil.spaceAndThinSpace());
                renderer.append(VcsBundle.message((String)"changes.nodetitle.have.outdated.files", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        } else {
            renderer.append(((ChangeList)this.getUserObject()).getName(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
            this.appendCount(renderer);
        }
    }

    @NlsContexts.Tooltip
    @Nullable
    private String getTooltipText() {
        if (!(this.userObject instanceof LocalChangeList)) {
            return null;
        }
        ChangeListData data2 = ChangeListDataKt.getChangeListData((LocalChangeList)this.userObject);
        if (data2 == null) {
            return null;
        }
        String dataInfo = data2.getPresentation();
        String message = ChangesBrowserChangeListNode.cropMessageIfNeeded(((LocalChangeList)this.userObject).getComment());
        @Nls StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty((String)dataInfo)) {
            sb.append(dataInfo);
        }
        if (!StringUtil.isEmpty((String)message)) {
            if (sb.length() > 0) {
                sb.append("<br/>").append("<br/>");
            }
            sb.append(message);
        }
        return StringUtil.nullize((String)sb.toString());
    }

    @Nullable
    private static String cropMessageIfNeeded(@Nullable String comment) {
        if (comment == null) {
            return null;
        }
        Object[] lines = StringUtil.splitByLines((String)XmlStringUtil.escapeString((String)comment), (boolean)false);
        String croppedMessage = ((StreamEx)StreamEx.of((Object[])lines).limit(5L)).joining((CharSequence)"<br/>");
        return lines.length > 5 ? croppedMessage + "..." : croppedMessage;
    }

    @Override
    public String getTextPresentation() {
        return ((ChangeList)this.getUserObject()).getName().trim();
    }

    @Override
    public boolean canAcceptDrop(ChangeListDragBean dragBean) {
        List<Change> changes = dragBean.getChanges();
        for (Change change : ((ChangeList)this.getUserObject()).getChanges()) {
            for (Change incomingChange : changes) {
                if (change != incomingChange) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void acceptDrop(ChangeListOwner dragOwner, ChangeListDragBean dragBean) {
        if (!(this.userObject instanceof LocalChangeList)) {
            return;
        }
        LocalChangeList dropList = (LocalChangeList)this.getUserObject();
        dragOwner.moveChangesTo(dropList, dragBean.getChanges());
        ArrayList toUpdate = new ArrayList();
        ChangesBrowserChangeListNode.addIfNotNull(toUpdate, dragBean.getUnversionedFiles());
        ChangesBrowserChangeListNode.addIfNotNull(toUpdate, dragBean.getIgnoredFiles());
        if (!toUpdate.isEmpty()) {
            dragOwner.addUnversionedFiles(dropList, ContainerUtil.mapNotNull(toUpdate, FilePath::getVirtualFile));
        }
    }

    private static void addIfNotNull(List<? super FilePath> unversionedFiles, List<? extends FilePath> ignoredFiles) {
        if (ignoredFiles != null) {
            unversionedFiles.addAll(ignoredFiles);
        }
    }

    @Override
    public int getSortWeight() {
        if (this.userObject instanceof LocalChangeList && ((LocalChangeList)this.userObject).isDefault()) {
            return 1;
        }
        return 2;
    }

    @Override
    public int compareUserObjects(ChangeList o2) {
        return ChangesBrowserChangeListNode.compareFileNames(((ChangeList)this.getUserObject()).getName(), o2.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/vcs/changes/ui/ChangesBrowserChangeListNode", "render"));
    }
}

