/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.statistics;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.statistics.VcsUsagesCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.StringKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u001a\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0014R\u001e\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001b\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/vcs/statistics/VcsUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "ACTIVE_VCS", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "", "CHANGELISTS", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "IGNORED_FILES", "IS_BASE_DIR_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "IS_PROJECT_MAPPING_FIELD", "MAPPED_ROOTS", "MAPPING", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "PROJECT_MAPPED_ROOTS", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "UNVERSIONED_FILES", "VCS_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "VCS_FIELD_WITH_NONE", "com/intellij/openapi/vcs/statistics/VcsUsagesCollector$VCS_FIELD_WITH_NONE$1", "Lcom/intellij/openapi/vcs/statistics/VcsUsagesCollector$VCS_FIELD_WITH_NONE$1;", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsUsagesCollector.kt\ncom/intellij/openapi/vcs/statistics/VcsUsagesCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,102:1\n1#2:103\n766#3:104\n857#3,2:105\n766#3:107\n857#3,2:108\n1549#3:110\n1620#3,3:111\n766#3:117\n857#3,2:118\n3792#4:114\n4307#4,2:115\n*S KotlinDebug\n*F\n+ 1 VcsUsagesCollector.kt\ncom/intellij/openapi/vcs/statistics/VcsUsagesCollector\n*L\n56#1:104\n56#1:105,2\n57#1:107\n57#1:108,2\n58#1:110\n58#1:111,3\n63#1:117\n63#1:118,2\n62#1:114\n62#1:115,2\n*E\n"})
public final class VcsUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("vcs.configuration", 3, null, 4, null);
    @NotNull
    private final StringEventField VCS_FIELD = EventFields.StringValidatedByEnum((String)"vcs", (String)"vcs");
    @NotNull
    private final EventId2<PluginInfo, String> ACTIVE_VCS = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"active.vcs", (EventField)((EventField)EventFields.PluginInfo), (EventField)((EventField)this.VCS_FIELD), null, (int)8, null);
    @NotNull
    private final BooleanEventField IS_PROJECT_MAPPING_FIELD = EventFields.Boolean((String)"is_project_mapping");
    @NotNull
    private final BooleanEventField IS_BASE_DIR_FIELD = EventFields.Boolean((String)"is_base_dir");
    @NotNull
    private final VCS_FIELD_WITH_NONE.1 VCS_FIELD_WITH_NONE = new StringEventField(){

        @NotNull
        public List<String> getValidationRule() {
            Object[] objectArray = new String[]{"{enum#vcs}", "{enum:None}"};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    };
    @NotNull
    private final VarargEventId MAPPING;
    @NotNull
    private final EventId3<PluginInfo, String, Boolean> PROJECT_MAPPED_ROOTS;
    @NotNull
    private final EventId1<Integer> MAPPED_ROOTS;
    @NotNull
    private final EventId1<Integer> CHANGELISTS;
    @NotNull
    private final EventId1<Integer> UNVERSIONED_FILES;
    @NotNull
    private final EventId1<Integer> IGNORED_FILES;

    public VcsUsagesCollector() {
        EventField[] eventFieldArray = new EventField[]{EventFields.PluginInfo, this.VCS_FIELD_WITH_NONE, this.IS_PROJECT_MAPPING_FIELD, this.IS_BASE_DIR_FIELD};
        this.MAPPING = this.GROUP.registerVarargEvent("mapping", eventFieldArray);
        this.PROJECT_MAPPED_ROOTS = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"project.mapped.root", (EventField)((EventField)EventFields.PluginInfo), (EventField)((EventField)this.VCS_FIELD), (EventField)((EventField)EventFields.Boolean((String)"is_base_dir")), null, (int)16, null);
        this.MAPPED_ROOTS = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"mapped.roots", (EventField)((EventField)EventFields.Count), null, (int)4, null);
        this.CHANGELISTS = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"changelists", (EventField)((EventField)EventFields.Count), null, (int)4, null);
        this.UNVERSIONED_FILES = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"unversioned.files", (EventField)((EventField)EventFields.Count), null, (int)4, null);
        this.IGNORED_FILES = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"ignored.files", (EventField)((EventField)EventFields.Count), null, (int)4, null);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        List data2;
        PluginInfo pluginInfo;
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!TrustedProjects.isTrusted((Project)project)) {
            return SetsKt.emptySet();
        }
        HashSet<MetricEvent> set = new HashSet<MetricEvent>();
        ProjectLevelVcsManagerEx vcsManager2 = ProjectLevelVcsManagerEx.getInstanceEx(project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager clm = changeListManager;
        String string = project.getBasePath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            virtualFile = VcsUtil.getVirtualFile((String)it);
        } else {
            virtualFile = null;
        }
        VirtualFile projectBaseDir = virtualFile;
        AbstractVcs[] abstractVcsArray = vcsManager2.getAllActiveVcss();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
        for (AbstractVcs vcs : abstractVcsArray) {
            pluginInfo = PluginInfoDetectorKt.getPluginInfo(vcs.getClass());
            set.add(this.ACTIVE_VCS.metric((Object)pluginInfo, (Object)vcs.getName()));
        }
        for (VcsDirectoryMapping mapping : vcsManager2.getDirectoryMappings()) {
            PluginInfo pluginInfo2;
            String vcsName = StringKt.nullize((String)mapping.getVcs(), (boolean)true);
            AbstractVcs vcs = vcsManager2.findVcsByName(vcsName);
            if (vcs != null) {
                AbstractVcs it;
                boolean bl = false;
                pluginInfo2 = PluginInfoDetectorKt.getPluginInfo(it.getClass());
            } else {
                pluginInfo2 = null;
            }
            pluginInfo = pluginInfo2;
            data2 = new ArrayList();
            data2.add(EventFields.PluginInfo.with((Object)pluginInfo));
            data2.add(this.IS_PROJECT_MAPPING_FIELD.with((Object)mapping.isDefaultMapping()));
            String string2 = vcsName;
            if (string2 == null) {
                string2 = "None";
            }
            data2.add(this.VCS_FIELD_WITH_NONE.with(string2));
            if (!mapping.isDefaultMapping()) {
                data2.add(this.IS_BASE_DIR_FIELD.with((Object)(projectBaseDir != null && Intrinsics.areEqual((Object)projectBaseDir, (Object)VcsUtil.getVirtualFile((String)mapping.getDirectory())) ? 1 : 0)));
            }
            set.add(this.MAPPING.metric(data2));
        }
        AbstractVcs defaultVcs = vcsManager2.findVcsByName(vcsManager2.haveDefaultMapping());
        if (defaultVcs != null) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            VcsDirectoryMapping it;
            Iterable $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2;
            PluginInfo pluginInfo3 = PluginInfoDetectorKt.getPluginInfo(defaultVcs.getClass());
            List list = vcsManager2.getDirectoryMappings();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDirectoryMappings(...)");
            Iterable vcs = list;
            boolean $i$f$filter = false;
            data2 = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (VcsDirectoryMapping)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getVcs(), (Object)defaultVcs.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv2 = $this$filter$iv2;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (VcsDirectoryMapping)element$iv$iv;
                boolean bl = false;
                String string3 = it.getDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDirectory(...)");
                boolean bl2 = ((CharSequence)string3).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv;
            boolean $i$f$map22 = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (VcsDirectoryMapping)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VcsUtil.getVirtualFile((String)it.getDirectory()));
            }
            Set explicitRoots = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            VcsRoot[] vcsRootArray = vcsManager2.getAllVcsRoots();
            Intrinsics.checkNotNullExpressionValue((Object)vcsRootArray, (String)"getAllVcsRoots(...)");
            Object[] $i$f$map22 = vcsRootArray;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                VcsRoot it2 = (VcsRoot)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getVcs(), (Object)defaultVcs)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            $i$f$filter2 = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VcsRoot it3 = (VcsRoot)element$iv$iv;
                boolean bl = false;
                if (!(!explicitRoots.contains(it3.getPath()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List projectMappedRoots = (List)destination$iv$iv2;
            for (VcsRoot vcsRoot : projectMappedRoots) {
                set.add(this.PROJECT_MAPPED_ROOTS.metric((Object)pluginInfo3, (Object)defaultVcs.getName(), (Object)Intrinsics.areEqual((Object)vcsRoot.getPath(), (Object)projectBaseDir)));
            }
        }
        set.add(this.MAPPED_ROOTS.metric((Object)vcsManager2.getAllVcsRoots().length));
        set.add(this.CHANGELISTS.metric((Object)clm.getChangeListsNumber()));
        set.add(this.UNVERSIONED_FILES.metric((Object)clm.getUnversionedFilesPaths().size()));
        set.add(this.IGNORED_FILES.metric((Object)clm.getIgnoredFilePaths().size()));
        return set;
    }
}

