/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.compiled.ClassFileDecompilers;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.ui.components.LegalNoticeDialog;
import com.intellij.util.FileContentUtilCore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.jar.Manifest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.IdeaCancellationManager;
import org.jetbrains.java.decompiler.IdeaDecompiler;
import org.jetbrains.java.decompiler.IdeaDecompilerBundle;
import org.jetbrains.java.decompiler.IdeaDecompilerKt;
import org.jetbrains.java.decompiler.IdeaLogger;
import org.jetbrains.java.decompiler.main.CancellationManager;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.extern.ClassFormatException;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J'\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler;", "Lcom/intellij/psi/compiled/ClassFileDecompilers$Light;", "()V", "myLogger", "Lkotlin/Lazy;", "Lorg/jetbrains/java/decompiler/IdeaLogger;", "myOptions", "", "", "", "accepts", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "decompile", "", "getText", "pop", "T", "Lcom/intellij/openapi/util/Key;", "holder", "Lcom/intellij/openapi/util/UserDataHolder;", "(Lcom/intellij/openapi/util/Key;Lcom/intellij/openapi/util/UserDataHolder;)Ljava/lang/Object;", "LegalBurden", "MyBytecodeProvider", "MyResultSaver", "intellij.java.decompiler"})
@SourceDebugExtension(value={"SMAP\nIdeaDecompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaDecompiler.kt\norg/jetbrains/java/decompiler/IdeaDecompiler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n3792#2:251\n4307#2,2:252\n1855#3,2:254\n*S KotlinDebug\n*F\n+ 1 IdeaDecompiler.kt\norg/jetbrains/java/decompiler/IdeaDecompiler\n*L\n135#1:251\n135#1:252,2\n151#1:254,2\n*E\n"})
public final class IdeaDecompiler
extends ClassFileDecompilers.Light {
    @NotNull
    private final Lazy<IdeaLogger> myLogger = LazyKt.lazy((Function0)myLogger.1.INSTANCE);
    @NotNull
    private final Lazy<Map<String, Object>> myOptions = LazyKt.lazy((Function0)myOptions.1.INSTANCE);

    public boolean accepts(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    @NotNull
    public CharSequence getText(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (ApplicationManager.getApplication().isUnitTestMode() || PropertiesComponent.getInstance().isValueSet("decompiler.legal.notice.accepted")) {
            CharSequence previous;
            Future future = (Future)this.pop(IdeaDecompilerKt.access$getTASK_KEY$p(), (UserDataHolder)file);
            CharSequence charSequence = previous = future != null ? (CharSequence)future.get() : null;
            if (previous != null) {
                return previous;
            }
            return this.decompile(file);
        }
        CharSequence charSequence = ClsFileImpl.decompile((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"decompile(...)");
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    private final CharSequence decompile(VirtualFile file) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"getName(...)");
            indicator.setText(IdeaDecompilerBundle.message("decompiling.progress", objectArray));
        }
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String mask = file.getNameWithoutExtension() + "$";
            Collection collection = CollectionsKt.listOf((Object)file);
            VirtualFile[] virtualFileArray = file.getParent().getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] objectArray = virtualFileArray;
            Collection collection2 = collection;
            boolean $i$f$filter = false;
            void var7_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!(StringsKt.startsWith$default((String)string, (String)mask, (boolean)false, (int)2, null) && it.getFileType() == JavaClassFileType.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List files = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
            HashMap options = new HashMap((Map)this.myOptions.getValue());
            if (Registry.is((String)"decompiler.use.line.mapping")) {
                ((Map)options).put("bsm", "1");
            }
            if (Registry.is((String)"decompiler.dump.original.lines")) {
                ((Map)options).put("__dump_original_lines__", "1");
            }
            MyBytecodeProvider provider = new MyBytecodeProvider(files);
            MyResultSaver saver = new MyResultSaver();
            Object object = options.get("mpm");
            int maxSecProcessingMethod = object != null && (object = object.toString()) != null && (object = StringsKt.toIntOrNull(object)) != null ? (Integer)object : 0;
            BaseDecompiler decompiler = new BaseDecompiler(provider, saver, options, (IFernflowerLogger)this.myLogger.getValue(), new IdeaCancellationManager(maxSecProcessingMethod));
            Iterable $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                decompiler.addSource(new File(it.getPath()));
            }
            try {
                decompiler.decompileContext();
            }
            catch (CancellationManager.CanceledException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    throw cause;
                }
                throw e;
            }
            int[] mapping = saver.getMapping();
            if (mapping != null) {
                file.putUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY, (Object)new LineNumbersMapping.ArrayBasedMapping(mapping));
            }
            return saver.getResult();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof IdeaLogger.InternalException && e.getCause() instanceof IOException) {
                Logger.getInstance(IdeaDecompiler.class).warn(file.getUrl(), (Throwable)e);
                CharSequence charSequence = Strings.EMPTY_CHAR_SEQUENCE;
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"EMPTY_CHAR_SEQUENCE");
                return charSequence;
            }
            if (ApplicationManager.getApplication().isUnitTestMode() && !(e instanceof ClassFormatException)) {
                throw new AssertionError(file.getUrl(), e);
            }
            throw new ClassFileDecompilers.Light.CannotDecompileException(file.getUrl(), (Throwable)e);
        }
    }

    private final <T> T pop(Key<T> $this$pop, UserDataHolder holder) {
        Object value = $this$pop.get(holder);
        if (value != null) {
            $this$pop.set(holder, null);
        }
        return (T)value;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\f"}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$LegalBurden;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener$Before;", "()V", "showNotice", "", "Ljava/lang/Boolean;", "beforeFileOpened", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.java.decompiler"})
    public static final class LegalBurden
    implements FileEditorManagerListener.Before {
        @Nullable
        private Boolean showNotice;

        public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Boolean bl = this.showNotice;
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                if (!it) {
                    return;
                }
            }
            if (file.getFileType() != JavaClassFileType.INSTANCE) {
                return;
            }
            if (PropertiesComponent.getInstance().isValueSet("decompiler.legal.notice.accepted")) {
                this.showNotice = false;
                return;
            }
            ClassFileDecompilers.Light decompiler = (ClassFileDecompilers.Light)ClassFileDecompilers.getInstance().find(file, ClassFileDecompilers.Light.class);
            if (!(decompiler instanceof IdeaDecompiler)) {
                return;
            }
            IdeaDecompilerKt.access$getTASK_KEY$p().set((UserDataHolder)file, (Object)ApplicationManager.getApplication().executeOnPooledThread(() -> LegalBurden.beforeFileOpened$lambda$1(decompiler, file)));
            Object[] it = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.last((CharSequence)file.getPath(), (int)40, (boolean)true), (String)"last(...)");
            String title = IdeaDecompilerBundle.message("legal.notice.title", it);
            String message = IdeaDecompilerBundle.message("legal.notice.text", new Object[0]);
            int result = LegalNoticeDialog.build((String)title, (String)message).withCancelText(IdeaDecompilerBundle.message("legal.notice.action.postpone", new Object[0])).withCustomAction(IdeaDecompilerBundle.message("legal.notice.action.reject", new Object[0]), 2).show();
            switch (result) {
                case 0: {
                    this.showNotice = false;
                    PropertiesComponent.getInstance().setValue("decompiler.legal.notice.accepted", true);
                    ApplicationManager.getApplication().invokeLater(() -> LegalBurden.beforeFileOpened$lambda$2(file));
                    break;
                }
                case 2: {
                    this.showNotice = false;
                    IdeaDecompilerKt.access$getTASK_KEY$p().set((UserDataHolder)file, null);
                    PluginId pluginId = PluginId.getId((String)"org.jetbrains.java.decompiler");
                    Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
                    PluginId id = pluginId;
                    PluginManagerCore.disablePlugin((PluginId)id);
                    IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)id);
                    if (!(plugin instanceof IdeaPluginDescriptorImpl) || !DynamicPlugins.allowLoadUnloadWithoutRestart$default((IdeaPluginDescriptorImpl)((IdeaPluginDescriptorImpl)plugin), null, null, (int)6, null)) break;
                    ApplicationManager.getApplication().invokeLater(() -> LegalBurden.beforeFileOpened$lambda$3(plugin));
                    break;
                }
                case 1: {
                    IdeaDecompilerKt.access$getTASK_KEY$p().set((UserDataHolder)file, null);
                }
            }
        }

        private static final CharSequence beforeFileOpened$lambda$1(ClassFileDecompilers.Light $decompiler, VirtualFile $file) {
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            Intrinsics.checkNotNull((Object)$decompiler);
            return ((IdeaDecompiler)$decompiler).decompile($file);
        }

        private static final void beforeFileOpened$lambda$2(VirtualFile $file) {
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            VirtualFile[] virtualFileArray = new VirtualFile[]{$file};
            FileContentUtilCore.reparseFiles((VirtualFile[])virtualFileArray);
        }

        private static final void beforeFileOpened$lambda$3(IdeaPluginDescriptor $plugin) {
            DynamicPlugins.INSTANCE.unloadPlugin((IdeaPluginDescriptorImpl)$plugin, new DynamicPlugins.UnloadPluginOptions(false, false, false, false, false, false, null, 123, null));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0016R\"\u0010\u0006\u001a\u0016\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$MyBytecodeProvider;", "Lorg/jetbrains/java/decompiler/main/extern/IBytecodeProvider;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/util/List;)V", "pathMap", "", "", "kotlin.jvm.PlatformType", "getBytecode", "", "externalPath", "internalPath", "intellij.java.decompiler"})
    @SourceDebugExtension(value={"SMAP\nIdeaDecompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaDecompiler.kt\norg/jetbrains/java/decompiler/IdeaDecompiler$MyBytecodeProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n1194#2,2:251\n1222#2,4:253\n*S KotlinDebug\n*F\n+ 1 IdeaDecompiler.kt\norg/jetbrains/java/decompiler/IdeaDecompiler$MyBytecodeProvider\n*L\n186#1:251,2\n186#1:253,4\n*E\n"})
    private static final class MyBytecodeProvider
    implements IBytecodeProvider {
        @NotNull
        private final Map<String, VirtualFile> pathMap;

        /*
         * WARNING - void declaration
         */
        public MyBytecodeProvider(@NotNull List<? extends VirtualFile> files) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Iterable iterable = files;
            MyBytecodeProvider myBytecodeProvider = this;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var5_6 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(new File(it.getPath()).getAbsolutePath(), element$iv$iv);
            }
            myBytecodeProvider.pathMap = destination$iv$iv;
        }

        @Override
        @NotNull
        public byte[] getBytecode(@NotNull String externalPath, @Nullable String internalPath) {
            Intrinsics.checkNotNullParameter((Object)externalPath, (String)"externalPath");
            VirtualFile virtualFile = this.pathMap.get(externalPath);
            Object object = virtualFile != null ? virtualFile.contentsToByteArray(false) : null;
            if (object == null) {
                throw new AssertionError((Object)(externalPath + " not in " + this.pathMap.keySet()));
            }
            return object;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0016J(\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J \u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J0\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0016J2\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J \u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/jetbrains/java/decompiler/IdeaDecompiler$MyResultSaver;", "Lorg/jetbrains/java/decompiler/main/extern/IResultSaver;", "()V", "mapping", "", "getMapping", "()[I", "setMapping", "([I)V", "result", "", "getResult", "()Ljava/lang/String;", "setResult", "(Ljava/lang/String;)V", "closeArchive", "", "path", "archiveName", "copyEntry", "source", "entry", "copyFile", "entryName", "createArchive", "manifest", "Ljava/util/jar/Manifest;", "saveClassEntry", "qualifiedName", "content", "saveClassFile", "saveDirEntry", "saveFolder", "intellij.java.decompiler"})
    private static final class MyResultSaver
    implements IResultSaver {
        @NotNull
        private String result = "";
        @Nullable
        private int[] mapping;

        @NotNull
        public final String getResult() {
            return this.result;
        }

        public final void setResult(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.result = string;
        }

        @Nullable
        public final int[] getMapping() {
            return this.mapping;
        }

        public final void setMapping(@Nullable int[] nArray) {
            this.mapping = nArray;
        }

        @Override
        public void saveClassFile(@NotNull String path, @NotNull String qualifiedName, @NotNull String entryName, @NotNull String content, @Nullable int[] mapping) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            if (((CharSequence)this.result).length() == 0) {
                this.result = content;
                this.mapping = mapping;
            }
        }

        @Override
        public void saveFolder(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        }

        @Override
        public void copyFile(@NotNull String source, @NotNull String path, @NotNull String entryName) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        }

        @Override
        public void createArchive(@NotNull String path, @NotNull String archiveName, @NotNull Manifest manifest) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)archiveName, (String)"archiveName");
            Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        }

        @Override
        public void saveDirEntry(@NotNull String path, @NotNull String archiveName, @NotNull String entryName) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)archiveName, (String)"archiveName");
            Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
        }

        @Override
        public void copyEntry(@NotNull String source, @NotNull String path, @NotNull String archiveName, @NotNull String entry) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)archiveName, (String)"archiveName");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        }

        @Override
        public void saveClassEntry(@NotNull String path, @NotNull String archiveName, @NotNull String qualifiedName, @NotNull String entryName, @NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)archiveName, (String)"archiveName");
            Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
            Intrinsics.checkNotNullParameter((Object)entryName, (String)"entryName");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        }

        @Override
        public void closeArchive(@NotNull String path, @NotNull String archiveName) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)archiveName, (String)"archiveName");
        }
    }
}

