/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.main.AssertProcessor;
import org.jetbrains.java.decompiler.main.ClassReference14Processor;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.EnumProcessor;
import org.jetbrains.java.decompiler.main.InitializerProcessor;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TargetInfo;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotation;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotationWriteHelper;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.StructRecordComponent;
import org.jetbrains.java.decompiler.struct.attr.StructAnnDefaultAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationParameterAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructConstantValueAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructExceptionsAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGenericSignatureAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLineNumberTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructModuleAttribute;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.Type;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class ClassWriter {
    private final PoolInterceptor interceptor = DecompilerContext.getPoolInterceptor();
    private static final Map<Integer, String> MODIFIERS = new LinkedHashMap<Integer, String>();
    private static final int CLASS_ALLOWED = 3103;
    private static final int FIELD_ALLOWED = 223;
    private static final int METHOD_ALLOWED = 3391;
    private static final int CLASS_EXCLUDED = 1032;
    private static final int FIELD_EXCLUDED = 25;
    private static final int METHOD_EXCLUDED = 1025;
    private static final int ACCESSIBILITY_FLAGS = 7;

    private static void invokeProcessors(ClassesProcessor.ClassNode node) {
        ClassWrapper wrapper = node.getWrapper();
        StructClass cl = wrapper.getClassStruct();
        InitializerProcessor.extractInitializers(wrapper);
        if (node.type == 0 && !cl.isVersion5() && DecompilerContext.getOption("dc4")) {
            ClassReference14Processor.processClassReferences(node);
        }
        if (cl.hasModifier(16384) && DecompilerContext.getOption("den")) {
            EnumProcessor.clearEnum(wrapper);
        }
        if (DecompilerContext.getOption("das")) {
            AssertProcessor.buildAssertions(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classLambdaToJava(ClassesProcessor.ClassNode node, TextBuffer buffer, Exprent method_object, int indent, BytecodeMappingTracer origTracer) {
        ClassWrapper wrapper = node.getWrapper();
        if (wrapper == null) {
            return;
        }
        boolean lambdaToAnonymous = DecompilerContext.getOption("lac");
        ClassesProcessor.ClassNode outerNode = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        DecompilerContext.setProperty("CURRENT_CLASS_NODE", node);
        BytecodeMappingTracer tracer = new BytecodeMappingTracer(origTracer.getCurrentSourceLine());
        try {
            StructClass cl = wrapper.getClassStruct();
            DecompilerContext.getLogger().startWriteClass(node.simpleName);
            if (node.lambdaInformation.is_method_reference) {
                if (!node.lambdaInformation.is_content_method_static && method_object != null) {
                    buffer.append(method_object.toJava(indent, tracer));
                } else {
                    buffer.append(ExprProcessor.getCastTypeName(new VarType(node.lambdaInformation.content_class_name, true), Collections.emptyList()));
                }
                buffer.append("::").append("<init>".equals(node.lambdaInformation.content_method_name) ? "new" : node.lambdaInformation.content_method_name);
            } else {
                boolean explicitlyTyped;
                StructMethod mt = cl.getMethod(node.lambdaInformation.content_method_key);
                MethodWrapper methodWrapper = wrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
                MethodDescriptor md_content = MethodDescriptor.parseDescriptor(node.lambdaInformation.content_method_descriptor);
                MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(node.lambdaInformation.method_descriptor);
                List<TypeAnnotation> parameterTypeAnnotations = TargetInfo.FormalParameterTarget.extract(TypeAnnotation.listFrom(mt));
                boolean bl = explicitlyTyped = !parameterTypeAnnotations.isEmpty();
                if (!lambdaToAnonymous) {
                    buffer.append('(');
                    boolean firstParameter = true;
                    int index = node.lambdaInformation.is_content_method_static ? 0 : 1;
                    int start_index = md_content.params.length - md_lambda.params.length;
                    for (int i = 0; i < md_content.params.length; ++i) {
                        if (i >= start_index) {
                            String parameterName;
                            if (!firstParameter) {
                                buffer.append(", ");
                            }
                            if (explicitlyTyped) {
                                List<TypeAnnotation> iParameterTypeAnnotations = TargetInfo.FormalParameterTarget.extract(parameterTypeAnnotations, i);
                                VarType type = md_content.params[i];
                                buffer.append(ExprProcessor.getCastTypeName(type, TypeAnnotationWriteHelper.create(iParameterTypeAnnotations)));
                                buffer.append(' ');
                            }
                            buffer.append((String)((parameterName = methodWrapper.varproc.getVarName(new VarVersionPair(index, 0))) == null ? "param" + index : parameterName));
                            firstParameter = false;
                        }
                        index += md_content.params[i].getStackSize();
                    }
                    buffer.append(") ->");
                }
                buffer.append(" {").appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                ClassWriter.methodLambdaToJava(node, wrapper, mt, buffer, indent + 1, !lambdaToAnonymous, tracer);
                buffer.appendIndent(indent).append("}");
                ClassWriter.addTracer(cl, mt, tracer);
            }
        }
        finally {
            DecompilerContext.setProperty("CURRENT_CLASS_NODE", outerNode);
        }
        DecompilerContext.getLogger().endWriteClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classToJava(ClassesProcessor.ClassNode node, TextBuffer buffer, int indent, BytecodeMappingTracer tracer) {
        ClassesProcessor.ClassNode outerNode = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        DecompilerContext.setProperty("CURRENT_CLASS_NODE", node);
        int startLine = tracer != null ? tracer.getCurrentSourceLine() : 0;
        BytecodeMappingTracer dummy_tracer = new BytecodeMappingTracer(startLine);
        try {
            boolean hide;
            ClassWriter.invokeProcessors(node);
            ClassWrapper wrapper = node.getWrapper();
            StructClass cl = wrapper.getClassStruct();
            DecompilerContext.getLogger().startWriteClass(cl.qualifiedName);
            int start_class_def = buffer.length();
            this.writeClassDefinition(node, buffer, indent);
            boolean hasContent = false;
            boolean enumFields = false;
            dummy_tracer.incrementCurrentSourceLine(buffer.countLines(start_class_def));
            List<StructRecordComponent> components = cl.getRecordComponents();
            for (StructField fd : cl.getFields()) {
                boolean isEnum;
                hide = fd.isSynthetic() && DecompilerContext.getOption("rsy") || wrapper.getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
                if (hide || components != null && fd.getAccessFlags() == 18 && components.stream().anyMatch(c -> c.getName().equals(fd.getName()) && c.getDescriptor().equals(fd.getDescriptor()))) continue;
                boolean bl = isEnum = fd.hasModifier(16384) && DecompilerContext.getOption("den");
                if (isEnum) {
                    if (enumFields) {
                        buffer.append(',').appendLineSeparator();
                        dummy_tracer.incrementCurrentSourceLine();
                    }
                    enumFields = true;
                } else if (enumFields) {
                    buffer.append(';');
                    buffer.appendLineSeparator();
                    buffer.appendLineSeparator();
                    dummy_tracer.incrementCurrentSourceLine(2);
                    enumFields = false;
                }
                this.fieldToJava(wrapper, cl, fd, buffer, indent + 1, dummy_tracer);
                hasContent = true;
            }
            if (enumFields) {
                buffer.append(';').appendLineSeparator();
                dummy_tracer.incrementCurrentSourceLine();
            }
            startLine += buffer.countLines(start_class_def);
            for (StructMethod mt : cl.getMethods()) {
                BytecodeMappingTracer method_tracer;
                boolean methodSkipped;
                boolean bl = hide = mt.isSynthetic() && DecompilerContext.getOption("rsy") || mt.hasModifier(64) && DecompilerContext.getOption("rbr") || wrapper.getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
                if (hide) continue;
                int position = buffer.length();
                int storedLine = startLine++;
                if (hasContent) {
                    buffer.appendLineSeparator();
                }
                boolean bl2 = methodSkipped = !this.methodToJava(node, mt, buffer, indent + 1, method_tracer = new BytecodeMappingTracer(startLine));
                if (!methodSkipped) {
                    hasContent = true;
                    ClassWriter.addTracer(cl, mt, method_tracer);
                    startLine = method_tracer.getCurrentSourceLine();
                    continue;
                }
                buffer.setLength(position);
                startLine = storedLine;
            }
            for (ClassesProcessor.ClassNode inner : node.nested) {
                if (inner.type != 1) continue;
                StructClass innerCl = inner.classStruct;
                boolean isSynthetic = (inner.access & 0x1000) != 0 || innerCl.isSynthetic();
                boolean hide2 = isSynthetic && DecompilerContext.getOption("rsy") || wrapper.getHiddenMembers().contains(innerCl.qualifiedName);
                if (hide2) continue;
                if (hasContent) {
                    buffer.appendLineSeparator();
                    ++startLine;
                }
                BytecodeMappingTracer class_tracer = new BytecodeMappingTracer(startLine);
                this.classToJava(inner, buffer, indent + 1, class_tracer);
                startLine = buffer.countLines();
                hasContent = true;
            }
            buffer.appendIndent(indent).append('}');
            if (node.type != 2) {
                buffer.appendLineSeparator();
            }
        }
        finally {
            DecompilerContext.setProperty("CURRENT_CLASS_NODE", outerNode);
        }
        DecompilerContext.getLogger().endWriteClass();
    }

    private static boolean isSyntheticRecordMethod(StructClass cl, StructMethod mt, TextBuffer code) {
        if (cl.getRecordComponents() != null) {
            String name = mt.getName();
            String descriptor = mt.getDescriptor();
            if ((name.equals("equals") && descriptor.equals("(Ljava/lang/Object;)Z") || name.equals("hashCode") && descriptor.equals("()I") || name.equals("toString") && descriptor.equals("()Ljava/lang/String;")) && code.countLines() == 1) {
                String str = code.toString().trim();
                return str.startsWith("return this." + name + "<invokedynamic>(this");
            }
        }
        return false;
    }

    private void writeClassDefinition(ClassesProcessor.ClassNode node, TextBuffer buffer, int indent) {
        Set qualifiedNested;
        boolean allSubClassesAreNested;
        int[] interfaces;
        boolean isAnnotation;
        if (node.type == 2) {
            buffer.append(" {").appendLineSeparator();
            return;
        }
        ClassWrapper wrapper = node.getWrapper();
        StructClass cl = wrapper.getClassStruct();
        int flags = node.type == 0 ? cl.getAccessFlags() : node.access;
        boolean isDeprecated = cl.hasAttribute(StructGeneralAttribute.ATTRIBUTE_DEPRECATED);
        boolean isSynthetic = (flags & 0x1000) != 0 || cl.hasAttribute(StructGeneralAttribute.ATTRIBUTE_SYNTHETIC);
        boolean isEnum = DecompilerContext.getOption("den") && (flags & 0x4000) != 0;
        boolean isInterface = (flags & 0x200) != 0;
        boolean bl = isAnnotation = (flags & 0x2000) != 0;
        if (isDeprecated) {
            ClassWriter.appendDeprecation(buffer, indent);
        }
        if (this.interceptor != null) {
            String oldName = this.interceptor.getOldName(cl.qualifiedName);
            ClassWriter.appendRenameComment(buffer, oldName, MType.CLASS, indent);
        }
        if (isSynthetic) {
            ClassWriter.appendComment(buffer, "synthetic class", indent);
        }
        ClassWriter.appendAnnotations(buffer, indent, cl);
        buffer.appendIndent(indent);
        if (isEnum) {
            flags &= 0xFFFFFBFF;
            flags &= 0xFFFFFFEF;
        }
        List<StructRecordComponent> components = cl.getRecordComponents();
        List<String> permittedSubclassQualifiedNames = cl.getPermittedSubclasses();
        if (components != null) {
            flags &= 0xFFFFFFEF;
        }
        ClassWriter.appendModifiers(buffer, flags, 3103, isInterface, 1032);
        if (permittedSubclassQualifiedNames != null && !isEnum) {
            buffer.append("sealed ");
        } else if (node.isNonSealed()) {
            buffer.append("non-sealed ");
        }
        if (isEnum) {
            buffer.append("enum ");
        } else if (isInterface) {
            if (isAnnotation) {
                buffer.append('@');
            }
            buffer.append("interface ");
        } else if (components != null) {
            buffer.append("record ");
        } else {
            buffer.append("class ");
        }
        buffer.append(node.simpleName);
        List<TypeAnnotation> typeAnnotations = TypeAnnotation.listFrom(cl);
        GenericClassDescriptor descriptor = ClassWriter.getGenericClassDescriptor(cl);
        if (descriptor != null && !descriptor.fparameters.isEmpty()) {
            ClassWriter.appendTypeParameters(buffer, descriptor.fparameters, descriptor.fbounds, typeAnnotations);
        }
        if (components != null) {
            buffer.append('(');
            for (int i = 0; i < components.size(); ++i) {
                StructRecordComponent cd = components.get(i);
                if (i > 0) {
                    buffer.append(", ");
                }
                boolean varArgComponent = i == components.size() - 1 && ClassWriter.isVarArgRecord(cl);
                ClassWriter.recordComponentToJava(cd, buffer, varArgComponent);
            }
            buffer.append(')');
        }
        buffer.append(' ');
        if (!isEnum && !isInterface && components == null && cl.superClass != null) {
            VarType supertype = new VarType(cl.superClass.getString(), true);
            List<TypeAnnotation> extendsTypeAnnotations = TargetInfo.SupertypeTarget.extractExtends(typeAnnotations);
            if (!VarType.VARTYPE_OBJECT.equals(supertype)) {
                buffer.append("extends ");
                if (descriptor != null) {
                    buffer.append(GenericMain.getGenericCastTypeName(descriptor.superclass, TypeAnnotationWriteHelper.create(extendsTypeAnnotations)));
                } else {
                    buffer.append(ExprProcessor.getCastTypeName(supertype, TypeAnnotationWriteHelper.create(extendsTypeAnnotations)));
                }
                buffer.append(' ');
            }
        }
        if (!isAnnotation && (interfaces = cl.getInterfaces()).length > 0) {
            buffer.append(isInterface ? "extends " : "implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                List<TypeAnnotation> superTypeAnnotations = TargetInfo.SupertypeTarget.extract(typeAnnotations, i);
                if (descriptor != null) {
                    buffer.append(GenericMain.getGenericCastTypeName(descriptor.superinterfaces.get(i), TypeAnnotationWriteHelper.create(superTypeAnnotations)));
                    continue;
                }
                buffer.append(ExprProcessor.getCastTypeName(new VarType(cl.getInterface(i), true), TypeAnnotationWriteHelper.create(superTypeAnnotations)));
            }
            buffer.append(' ');
        }
        if (permittedSubclassQualifiedNames != null && !permittedSubclassQualifiedNames.isEmpty() && !(allSubClassesAreNested = (qualifiedNested = node.nested.stream().map(nestedNode -> nestedNode.classStruct.qualifiedName).collect(Collectors.toSet())).containsAll(permittedSubclassQualifiedNames))) {
            buffer.append("permits ");
            for (int i = 0; i < permittedSubclassQualifiedNames.size(); ++i) {
                String qualifiedName = permittedSubclassQualifiedNames.get(i);
                if (i > 0) {
                    buffer.append(", ");
                }
                String nestedName = DecompilerContext.getImportCollector().getNestedName(qualifiedName);
                buffer.append(nestedName);
            }
            buffer.append(' ');
        }
        buffer.append('{').appendLineSeparator();
    }

    private void fieldToJava(ClassWrapper wrapper, StructClass cl, StructField fd, TextBuffer buffer, int indent, BytecodeMappingTracer tracer) {
        StructConstantValueAttribute attr;
        boolean isEnum;
        int start = buffer.length();
        boolean isInterface = cl.hasModifier(512);
        boolean isDeprecated = fd.hasAttribute(StructGeneralAttribute.ATTRIBUTE_DEPRECATED);
        boolean bl = isEnum = fd.hasModifier(16384) && DecompilerContext.getOption("den");
        if (isDeprecated) {
            ClassWriter.appendDeprecation(buffer, indent);
        }
        if (this.interceptor != null) {
            String oldName = this.interceptor.getOldName(cl.qualifiedName + " " + fd.getName() + " " + fd.getDescriptor());
            ClassWriter.appendRenameComment(buffer, oldName, MType.FIELD, indent);
        }
        if (fd.isSynthetic()) {
            ClassWriter.appendComment(buffer, "synthetic field", indent);
        }
        Map.Entry<VarType, GenericFieldDescriptor> fieldTypeData = ClassWriter.getFieldTypeData(fd);
        VarType fieldType = fieldTypeData.getKey();
        ClassWriter.appendAnnotations(buffer, indent, fd);
        buffer.appendIndent(indent);
        if (!isEnum) {
            ClassWriter.appendModifiers(buffer, fd.getAccessFlags(), 223, isInterface, 25);
        }
        GenericFieldDescriptor descriptor = fieldTypeData.getValue();
        List<TypeAnnotation> typeAnnotations = TypeAnnotation.listFrom(fd);
        if (!isEnum) {
            if (descriptor != null) {
                buffer.append(GenericMain.getGenericCastTypeName(descriptor.type, TypeAnnotationWriteHelper.create(typeAnnotations)));
            } else {
                buffer.append(ExprProcessor.getCastTypeName(fieldType, TypeAnnotationWriteHelper.create(typeAnnotations)));
            }
            buffer.append(' ');
        }
        buffer.append(fd.getName());
        tracer.incrementCurrentSourceLine(buffer.countLines(start));
        Exprent initializer = fd.hasModifier(8) ? wrapper.getStaticFieldInitializers().getWithKey(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor())) : wrapper.getDynamicFieldInitializers().getWithKey(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
        if (initializer != null) {
            if (isEnum && initializer.type == 10) {
                NewExprent expr = (NewExprent)initializer;
                expr.setEnumConst(true);
                buffer.append(expr.toJava(indent, tracer));
            } else {
                buffer.append(" = ");
                if (initializer.type == 3) {
                    ((ConstExprent)initializer).adjustConstType(fieldType);
                }
                buffer.append(initializer.toJava(indent, tracer));
            }
        } else if (fd.hasModifier(16) && fd.hasModifier(8) && (attr = fd.getAttribute(StructGeneralAttribute.ATTRIBUTE_CONSTANT_VALUE)) != null) {
            PrimitiveConstant constant = cl.getPool().getPrimitiveConstant(attr.getIndex());
            buffer.append(" = ");
            buffer.append(new ConstExprent(fieldType, constant.value, null, fd).toJava(indent, tracer));
        }
        if (!isEnum) {
            buffer.append(';').appendLineSeparator();
            tracer.incrementCurrentSourceLine();
        }
    }

    private static void writeModuleInfoBody(TextBuffer buffer, StructModuleAttribute moduleAttribute) {
        List<StructModuleAttribute.ProvidesEntry> list;
        List<String> list2;
        List<StructModuleAttribute.OpensEntry> list3;
        List<StructModuleAttribute.ExportsEntry> exportsEntries;
        boolean newLineNeeded = false;
        List<StructModuleAttribute.RequiresEntry> requiresEntries = moduleAttribute.requires;
        if (!requiresEntries.isEmpty()) {
            for (StructModuleAttribute.RequiresEntry requiresEntry : requiresEntries) {
                if (ClassWriter.isGenerated(requiresEntry.flags)) continue;
                buffer.appendIndent(1).append("requires ");
                if ((requiresEntry.flags & 0x40) != 0) {
                    buffer.append("static ");
                }
                if ((requiresEntry.flags & 0x20) != 0) {
                    buffer.append("transitive ");
                }
                buffer.append(requiresEntry.moduleName.replace('/', '.')).append(';').appendLineSeparator();
                newLineNeeded = true;
            }
        }
        if (!(exportsEntries = moduleAttribute.exports).isEmpty()) {
            if (newLineNeeded) {
                buffer.appendLineSeparator();
            }
            for (StructModuleAttribute.ExportsEntry exportsEntry : exportsEntries) {
                if (ClassWriter.isGenerated(exportsEntry.flags)) continue;
                buffer.appendIndent(1).append("exports ").append(exportsEntry.packageName.replace('/', '.'));
                List<String> list4 = exportsEntry.exportToModules;
                if (!list4.isEmpty()) {
                    buffer.append(" to").appendLineSeparator();
                    ClassWriter.appendFQClassNames(buffer, list4);
                }
                buffer.append(';').appendLineSeparator();
                newLineNeeded = true;
            }
        }
        if (!(list3 = moduleAttribute.opens).isEmpty()) {
            if (newLineNeeded) {
                buffer.appendLineSeparator();
            }
            for (StructModuleAttribute.OpensEntry opensEntry : list3) {
                if (ClassWriter.isGenerated(opensEntry.flags)) continue;
                buffer.appendIndent(1).append("opens ").append(opensEntry.packageName.replace('/', '.'));
                List<String> opensToModules = opensEntry.opensToModules;
                if (!opensToModules.isEmpty()) {
                    buffer.append(" to").appendLineSeparator();
                    ClassWriter.appendFQClassNames(buffer, opensToModules);
                }
                buffer.append(';').appendLineSeparator();
                newLineNeeded = true;
            }
        }
        if (!(list2 = moduleAttribute.uses).isEmpty()) {
            if (newLineNeeded) {
                buffer.appendLineSeparator();
            }
            for (String uses : list2) {
                buffer.appendIndent(1).append("uses ").append(ExprProcessor.buildJavaClassName(uses)).append(';').appendLineSeparator();
            }
            newLineNeeded = true;
        }
        if (!(list = moduleAttribute.provides).isEmpty()) {
            if (newLineNeeded) {
                buffer.appendLineSeparator();
            }
            for (StructModuleAttribute.ProvidesEntry provides : list) {
                buffer.appendIndent(1).append("provides ").append(ExprProcessor.buildJavaClassName(provides.interfaceName)).append(" with").appendLineSeparator();
                ClassWriter.appendFQClassNames(buffer, provides.implementationNames.stream().map(ExprProcessor::buildJavaClassName).collect(Collectors.toList()));
                buffer.append(';').appendLineSeparator();
            }
        }
    }

    private static boolean isGenerated(int flags) {
        return (flags & 0x9000) != 0;
    }

    private static void addTracer(StructClass cls, StructMethod method, BytecodeMappingTracer tracer) {
        StructLineNumberTableAttribute table = method.getAttribute(StructGeneralAttribute.ATTRIBUTE_LINE_NUMBER_TABLE);
        tracer.setLineNumberTable(table);
        String key = InterpreterUtil.makeUniqueKey(method.getName(), method.getDescriptor());
        DecompilerContext.getBytecodeSourceMapper().addTracer(cls.qualifiedName, key, tracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean methodToJava(ClassesProcessor.ClassNode node, StructMethod mt, TextBuffer buffer, int indent, BytecodeMappingTracer tracer) {
        ClassWrapper wrapper = node.getWrapper();
        StructClass cl = wrapper.getClassStruct();
        MethodWrapper methodWrapper = wrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
        boolean hideMethod = false;
        int start_index_method = buffer.length();
        MethodWrapper outerWrapper = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", methodWrapper);
        try {
            StructGenericSignatureAttribute attr;
            boolean isBridge;
            boolean isInterface = cl.hasModifier(512);
            boolean isAnnotation = cl.hasModifier(8192);
            boolean isDeprecated = mt.hasAttribute(StructGeneralAttribute.ATTRIBUTE_DEPRECATED);
            boolean clInit = false;
            boolean dInit = false;
            MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
            int flags = mt.getAccessFlags();
            if ((flags & 0x100) != 0) {
                flags &= 0xFFFFF7FF;
            }
            if ("<clinit>".equals(mt.getName())) {
                flags &= 8;
            }
            if (isDeprecated) {
                ClassWriter.appendDeprecation(buffer, indent);
            }
            if (this.interceptor != null) {
                String oldName = this.interceptor.getOldName(cl.qualifiedName + " " + mt.getName() + " " + mt.getDescriptor());
                ClassWriter.appendRenameComment(buffer, oldName, MType.METHOD, indent);
            }
            boolean isSynthetic = (flags & 0x1000) != 0 || mt.hasAttribute(StructGeneralAttribute.ATTRIBUTE_SYNTHETIC);
            boolean bl = isBridge = (flags & 0x40) != 0;
            if (isSynthetic) {
                ClassWriter.appendComment(buffer, "synthetic method", indent);
            }
            if (isBridge) {
                ClassWriter.appendComment(buffer, "bridge method", indent);
            }
            GenericMethodDescriptor descriptor = null;
            if (DecompilerContext.getOption("dgs") && (attr = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_SIGNATURE)) != null && (descriptor = GenericMain.parseMethodSignature(attr.getSignature())) != null) {
                long actualParams = md.params.length;
                List<VarVersionPair> mask = methodWrapper.synthParameters;
                if (mask != null) {
                    actualParams = mask.stream().filter(Objects::isNull).count();
                }
                if (actualParams != (long)descriptor.parameterTypes.size()) {
                    String message = "Inconsistent generic signature in method " + mt.getName() + " " + mt.getDescriptor() + " in " + cl.qualifiedName;
                    DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN);
                    descriptor = null;
                }
            }
            ClassWriter.appendAnnotations(buffer, indent, mt);
            buffer.appendIndent(indent);
            ClassWriter.appendModifiers(buffer, flags, 3391, isInterface, 1025);
            if (isInterface && !mt.hasModifier(8) && !mt.hasModifier(2) && mt.containsCode()) {
                buffer.append("default ");
            }
            String name = mt.getName();
            boolean init = false;
            if ("<init>".equals(name)) {
                if (node.type == 2) {
                    name = "";
                    dInit = true;
                } else {
                    name = node.simpleName;
                    init = true;
                }
            } else if ("<clinit>".equals(name)) {
                name = "";
                clInit = true;
            }
            boolean throwsExceptions = false;
            int paramCount = 0;
            List<TypeAnnotation> typeAnnotations = TypeAnnotation.listFrom(mt);
            if (!clInit && !dInit) {
                if (descriptor != null && !descriptor.typeParameters.isEmpty()) {
                    ClassWriter.appendTypeParameters(buffer, descriptor.typeParameters, descriptor.typeParameterBounds, typeAnnotations);
                    buffer.append(' ');
                }
                List<TypeAnnotation> emptyTypeAnnotations = TargetInfo.EmptyTarget.extract(typeAnnotations);
                if (init) {
                    emptyTypeAnnotations.forEach(typeAnnotation -> typeAnnotation.writeTo(buffer));
                } else {
                    if (descriptor != null) {
                        buffer.append(GenericMain.getGenericCastTypeName(descriptor.returnType, TypeAnnotationWriteHelper.create(emptyTypeAnnotations)));
                    } else {
                        buffer.append(ExprProcessor.getCastTypeName(md.ret, TypeAnnotationWriteHelper.create(emptyTypeAnnotations)));
                    }
                    buffer.append(' ');
                }
                buffer.append(ClassWriter.toValidJavaIdentifier(name));
                buffer.append('(');
                List<VarVersionPair> mask = methodWrapper.synthParameters;
                int lastVisibleParameterIndex = -1;
                for (int i = 0; i < md.params.length; ++i) {
                    if (mask != null && mask.get(i) != null) continue;
                    lastVisibleParameterIndex = i;
                }
                int index = methodWrapper.varproc.getFirstParameterVarIndex();
                for (int i = methodWrapper.varproc.getFirstParameterPosition(); i < md.params.length; ++i) {
                    if (mask == null || mask.get(i) == null) {
                        String typeName;
                        if (paramCount > 0) {
                            buffer.append(", ");
                        }
                        Type paramType = descriptor != null ? (Type)descriptor.parameterTypes.get(paramCount) : md.params[i];
                        ClassWriter.appendParameterAnnotations(buffer, mt, paramType, paramCount);
                        VarVersionPair pair = new VarVersionPair(index, 0);
                        if (methodWrapper.varproc.isParameterFinal(pair) || methodWrapper.varproc.getVarFinal(pair) == 2) {
                            buffer.append("final ");
                        }
                        boolean isVarArg = i == lastVisibleParameterIndex && mt.hasModifier(128);
                        List<TypeAnnotation> typeParamAnnotations = TargetInfo.FormalParameterTarget.extract(typeAnnotations, i);
                        if (paramType instanceof GenericType) {
                            GenericType genParamType = (GenericType)paramType;
                            if (isVarArg &= genParamType.getArrayDim() > 0) {
                                genParamType = genParamType.decreaseArrayDim();
                            }
                            typeName = GenericMain.getGenericCastTypeName(genParamType, TypeAnnotationWriteHelper.create(typeParamAnnotations));
                        } else {
                            Type varParamType = paramType;
                            if (isVarArg &= ((VarType)varParamType).getArrayDim() > 0) {
                                varParamType = ((VarType)varParamType).decreaseArrayDim();
                            }
                            typeName = ExprProcessor.getCastTypeName((VarType)varParamType, TypeAnnotationWriteHelper.create(typeParamAnnotations));
                        }
                        if ("<undefinedtype>".equals(typeName) && DecompilerContext.getOption("uto")) {
                            typeName = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT, TypeAnnotationWriteHelper.create(typeParamAnnotations));
                        }
                        buffer.append(typeName);
                        if (isVarArg) {
                            buffer.append("...");
                        }
                        buffer.append(' ');
                        String parameterName = methodWrapper.varproc.getVarName(pair);
                        buffer.append((String)(parameterName == null ? "param" + index : parameterName));
                        ++paramCount;
                    }
                    index += md.params[i].getStackSize();
                }
                buffer.append(')');
                StructExceptionsAttribute attr2 = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_EXCEPTIONS);
                if (descriptor != null && !descriptor.exceptionTypes.isEmpty() || attr2 != null) {
                    throwsExceptions = true;
                    buffer.append(" throws ");
                    for (int i = 0; i < attr2.getThrowsExceptions().size(); ++i) {
                        Type type;
                        if (i > 0) {
                            buffer.append(", ");
                        }
                        TargetInfo.ThrowsTarget.extract(typeAnnotations, i).forEach(typeAnnotation -> typeAnnotation.writeTo(buffer));
                        if (descriptor != null && !descriptor.exceptionTypes.isEmpty()) {
                            type = descriptor.exceptionTypes.get(i);
                            buffer.append(GenericMain.getGenericCastTypeName(type, Collections.emptyList()));
                            continue;
                        }
                        type = new VarType(attr2.getExcClassname(i, cl.getPool()), true);
                        buffer.append(ExprProcessor.getCastTypeName((VarType)type, Collections.emptyList()));
                    }
                }
            }
            tracer.incrementCurrentSourceLine(buffer.countLines(start_index_method));
            if ((flags & 0x500) != 0) {
                StructAnnDefaultAttribute attr3;
                if (isAnnotation && (attr3 = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_ANNOTATION_DEFAULT)) != null) {
                    buffer.append(" default ");
                    buffer.append(attr3.getDefaultValue().toJava(0, BytecodeMappingTracer.DUMMY));
                }
                buffer.append(';');
                buffer.appendLineSeparator();
            } else {
                if (!clInit && !dInit) {
                    buffer.append(' ');
                }
                buffer.append('{').appendLineSeparator();
                tracer.incrementCurrentSourceLine();
                RootStatement root = wrapper.getMethodWrapper((String)mt.getName(), (String)mt.getDescriptor()).root;
                if (root != null && !methodWrapper.decompiledWithErrors) {
                    try {
                        BytecodeMappingTracer codeTracer = new BytecodeMappingTracer(tracer.getCurrentSourceLine());
                        TextBuffer code = root.toJava(indent + 1, codeTracer);
                        hideMethod = code.length() == 0 && (clInit || dInit || ClassWriter.hideConstructor(node, !typeAnnotations.isEmpty(), init, throwsExceptions, paramCount, flags)) || ClassWriter.isSyntheticRecordMethod(cl, mt, code);
                        buffer.append(code);
                        tracer.setCurrentSourceLine(codeTracer.getCurrentSourceLine());
                        tracer.addTracer(codeTracer);
                    }
                    catch (Throwable t) {
                        String message = "Method " + mt.getName() + " " + mt.getDescriptor() + " couldn't be written.";
                        DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN, t);
                        methodWrapper.decompiledWithErrors = true;
                    }
                }
                if (methodWrapper.decompiledWithErrors) {
                    buffer.appendIndent(indent + 1);
                    buffer.append("// $FF: Couldn't be decompiled");
                    buffer.appendLineSeparator();
                    tracer.incrementCurrentSourceLine();
                } else if (root != null) {
                    tracer.addMapping(root.getDummyExit().bytecode);
                }
                buffer.appendIndent(indent).append('}').appendLineSeparator();
            }
            tracer.incrementCurrentSourceLine();
        }
        finally {
            DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", outerWrapper);
        }
        return !hideMethod;
    }

    private static boolean isVarArgRecord(StructClass cl) {
        String canonicalConstructorDescriptor = cl.getRecordComponents().stream().map(StructField::getDescriptor).collect(Collectors.joining("", "(", ")V"));
        StructMethod init = cl.getMethod("<init>", canonicalConstructorDescriptor);
        return init != null && init.hasModifier(128);
    }

    public static void packageInfoToJava(StructClass cl, TextBuffer buffer) {
        ClassWriter.appendAnnotations(buffer, 0, cl);
        int index = cl.qualifiedName.lastIndexOf(47);
        String packageName = cl.qualifiedName.substring(0, index).replace('/', '.');
        buffer.append("package ").append(packageName).append(';').appendLineSeparator().appendLineSeparator();
    }

    public static void moduleInfoToJava(StructClass cl, TextBuffer buffer) {
        ClassWriter.appendAnnotations(buffer, 0, cl);
        StructModuleAttribute moduleAttribute = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_MODULE);
        if ((moduleAttribute.moduleFlags & 0x20) != 0) {
            buffer.append("open ");
        }
        buffer.append("module ").append(moduleAttribute.moduleName).append(" {").appendLineSeparator();
        ClassWriter.writeModuleInfoBody(buffer, moduleAttribute);
        buffer.append('}').appendLineSeparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void methodLambdaToJava(ClassesProcessor.ClassNode lambdaNode, ClassWrapper classWrapper, StructMethod mt, TextBuffer buffer, int indent, boolean codeOnly, BytecodeMappingTracer tracer) {
        MethodWrapper methodWrapper = classWrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
        MethodWrapper outerWrapper = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", methodWrapper);
        try {
            String method_name = lambdaNode.lambdaInformation.method_name;
            MethodDescriptor md_content = MethodDescriptor.parseDescriptor(lambdaNode.lambdaInformation.content_method_descriptor);
            MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(lambdaNode.lambdaInformation.method_descriptor);
            if (!codeOnly) {
                buffer.appendIndent(indent);
                buffer.append("public ");
                buffer.append(method_name);
                buffer.append("(");
                boolean firstParameter = true;
                int index = lambdaNode.lambdaInformation.is_content_method_static ? 0 : 1;
                int start_index = md_content.params.length - md_lambda.params.length;
                for (int i = 0; i < md_content.params.length; ++i) {
                    if (i >= start_index) {
                        String typeName;
                        if (!firstParameter) {
                            buffer.append(", ");
                        }
                        if ("<undefinedtype>".equals(typeName = ExprProcessor.getCastTypeName(md_content.params[i].copy(), Collections.emptyList())) && DecompilerContext.getOption("uto")) {
                            typeName = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT, Collections.emptyList());
                        }
                        buffer.append(typeName);
                        buffer.append(" ");
                        String parameterName = methodWrapper.varproc.getVarName(new VarVersionPair(index, 0));
                        buffer.append((String)(parameterName == null ? "param" + index : parameterName));
                        firstParameter = false;
                    }
                    index += md_content.params[i].getStackSize();
                }
                buffer.append(") {").appendLineSeparator();
                ++indent;
            }
            RootStatement root = classWrapper.getMethodWrapper((String)mt.getName(), (String)mt.getDescriptor()).root;
            if (!methodWrapper.decompiledWithErrors && root != null) {
                try {
                    buffer.append(root.toJava(indent, tracer));
                }
                catch (Throwable t) {
                    String message = "Method " + mt.getName() + " " + mt.getDescriptor() + " couldn't be written.";
                    DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN, t);
                    methodWrapper.decompiledWithErrors = true;
                }
            }
            if (methodWrapper.decompiledWithErrors) {
                buffer.appendIndent(indent);
                buffer.append("// $FF: Couldn't be decompiled");
                buffer.appendLineSeparator();
            }
            if (root != null) {
                tracer.addMapping(root.getDummyExit().bytecode);
            }
            if (!codeOnly) {
                buffer.appendIndent(--indent).append('}').appendLineSeparator();
            }
        }
        finally {
            DecompilerContext.setProperty("CURRENT_METHOD_WRAPPER", outerWrapper);
        }
    }

    private static String toValidJavaIdentifier(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        boolean changed = false;
        StringBuilder res = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(c) || i > 0 && !Character.isJavaIdentifierPart(c)) {
                changed = true;
                res.append("_");
                continue;
            }
            res.append(c);
        }
        if (!changed) {
            return name;
        }
        return res.append("/* $FF was: ").append(name).append("*/").toString();
    }

    private static void recordComponentToJava(StructRecordComponent cd, TextBuffer buffer, boolean varArgComponent) {
        Map.Entry<VarType, GenericFieldDescriptor> fieldTypeData = ClassWriter.getFieldTypeData(cd);
        VarType fieldType = fieldTypeData.getKey();
        GenericFieldDescriptor descriptor = fieldTypeData.getValue();
        ClassWriter.appendAnnotations(buffer, -1, cd);
        List<TypeAnnotation> typeAnnotations = TypeAnnotation.listFrom(cd);
        if (descriptor != null) {
            buffer.append(GenericMain.getGenericCastTypeName(varArgComponent ? descriptor.type.decreaseArrayDim() : descriptor.type, TypeAnnotationWriteHelper.create(typeAnnotations)));
        } else {
            buffer.append(ExprProcessor.getCastTypeName(varArgComponent ? fieldType.decreaseArrayDim() : fieldType, TypeAnnotationWriteHelper.create(typeAnnotations)));
        }
        if (varArgComponent) {
            buffer.append("...");
        }
        buffer.append(' ');
        buffer.append(cd.getName());
    }

    private static boolean hideConstructor(ClassesProcessor.ClassNode node, boolean hasAnnotation, boolean init, boolean throwsExceptions, int paramCount, int methodAccessFlags) {
        boolean isEnum;
        if (!init || hasAnnotation || throwsExceptions || paramCount > 0 || !DecompilerContext.getOption("hdc")) {
            return false;
        }
        StructClass cl = node.getWrapper().getClassStruct();
        int classAccessFlags = node.type == 0 ? cl.getAccessFlags() : node.access;
        boolean bl = isEnum = cl.hasModifier(16384) && DecompilerContext.getOption("den");
        if (!isEnum && (classAccessFlags & 7) != (methodAccessFlags & 7)) {
            return false;
        }
        int count = 0;
        for (StructMethod mt : cl.getMethods()) {
            if (!"<init>".equals(mt.getName()) || ++count <= 1) continue;
            return false;
        }
        return true;
    }

    private static Map.Entry<VarType, GenericFieldDescriptor> getFieldTypeData(StructField fd) {
        StructGenericSignatureAttribute attr;
        VarType fieldType = new VarType(fd.getDescriptor(), false);
        GenericFieldDescriptor descriptor = null;
        if (DecompilerContext.getOption("dgs") && (attr = fd.getAttribute(StructGeneralAttribute.ATTRIBUTE_SIGNATURE)) != null) {
            descriptor = GenericMain.parseFieldSignature(attr.getSignature());
        }
        return new AbstractMap.SimpleImmutableEntry<VarType, Object>(fieldType, descriptor);
    }

    private static void appendDeprecation(TextBuffer buffer, int indent) {
        buffer.appendIndent(indent).append("/** @deprecated */").appendLineSeparator();
    }

    private static void appendRenameComment(TextBuffer buffer, String oldName, MType type, int indent) {
        if (oldName == null) {
            return;
        }
        buffer.appendIndent(indent);
        buffer.append("// $FF: renamed from: ");
        switch (type) {
            case CLASS: {
                buffer.append(ExprProcessor.buildJavaClassName(oldName));
                break;
            }
            case FIELD: {
                String[] fParts = oldName.split(" ");
                FieldDescriptor fd = FieldDescriptor.parseDescriptor(fParts[2]);
                buffer.append(fParts[1]);
                buffer.append(' ');
                buffer.append(ClassWriter.getTypePrintOut(fd.type));
                break;
            }
            default: {
                String[] mParts = oldName.split(" ");
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mParts[2]);
                buffer.append(mParts[1]);
                buffer.append(" (");
                boolean first = true;
                for (VarType paramType : md.params) {
                    if (!first) {
                        buffer.append(", ");
                    }
                    first = false;
                    buffer.append(ClassWriter.getTypePrintOut(paramType));
                }
                buffer.append(") ");
                buffer.append(ClassWriter.getTypePrintOut(md.ret));
            }
        }
        buffer.appendLineSeparator();
    }

    private static String getTypePrintOut(VarType type) {
        String typeText = ExprProcessor.getCastTypeName(type, false, Collections.emptyList());
        if ("<undefinedtype>".equals(typeText) && DecompilerContext.getOption("uto")) {
            typeText = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT, false, Collections.emptyList());
        }
        return typeText;
    }

    private static void appendComment(TextBuffer buffer, String comment, int indent) {
        buffer.appendIndent(indent).append("// $FF: ").append(comment).appendLineSeparator();
    }

    private static void appendAnnotations(TextBuffer buffer, int indent, StructMember mb) {
        for (StructGeneralAttribute.Key<?> key : StructGeneralAttribute.ANNOTATION_ATTRIBUTES) {
            StructAnnotationAttribute attribute = (StructAnnotationAttribute)mb.getAttribute(key);
            if (attribute == null) continue;
            for (AnnotationExprent annotation : attribute.getAnnotations()) {
                if (mb.memberAnnCollidesWithTypeAnnotation(annotation)) continue;
                String text = annotation.toJava(indent, BytecodeMappingTracer.DUMMY).toString();
                buffer.append(text);
                if (indent < 0) {
                    buffer.append(' ');
                    continue;
                }
                buffer.appendLineSeparator();
            }
        }
    }

    private static void appendParameterAnnotations(TextBuffer buffer, StructMethod mt, @NotNull Type type, int param) {
        if (type == null) {
            ClassWriter.$$$reportNull$$$0(0);
        }
        for (StructGeneralAttribute.Key<?> key : StructGeneralAttribute.PARAMETER_ANNOTATION_ATTRIBUTES) {
            List<List<AnnotationExprent>> annotations;
            StructAnnotationParameterAttribute attribute = (StructAnnotationParameterAttribute)mt.getAttribute(key);
            if (attribute == null || param >= (annotations = attribute.getParamAnnotations()).size()) continue;
            for (AnnotationExprent annotation : annotations.get(param)) {
                if (mt.paramAnnCollidesWithTypeAnnotation(annotation, type, param)) continue;
                String text = annotation.toJava(-1, BytecodeMappingTracer.DUMMY).toString();
                buffer.append(text).append(' ');
            }
        }
    }

    private static void appendModifiers(TextBuffer buffer, int flags, int allowed, boolean isInterface, int excluded) {
        flags &= allowed;
        if (!isInterface) {
            excluded = 0;
        }
        for (int modifier : MODIFIERS.keySet()) {
            if ((flags & modifier) != modifier || (modifier & excluded) != 0) continue;
            buffer.append(MODIFIERS.get(modifier)).append(' ');
        }
    }

    public static GenericClassDescriptor getGenericClassDescriptor(StructClass cl) {
        StructGenericSignatureAttribute attr;
        if (DecompilerContext.getOption("dgs") && (attr = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_SIGNATURE)) != null) {
            return GenericMain.parseClassSignature(attr.getSignature());
        }
        return null;
    }

    public static void appendTypeParameters(TextBuffer buffer, List<String> parameters, List<? extends List<GenericType>> bounds, List<TypeAnnotation> typeAnnotations) {
        buffer.append('<');
        for (int i = 0; i < parameters.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            TargetInfo.TypeParameterTarget.extract(typeAnnotations, i).forEach(typeAnnotation -> typeAnnotation.writeTo(buffer));
            buffer.append(parameters.get(i));
            List<GenericType> parameterBounds = bounds.get(i);
            if (parameterBounds.size() <= 1 && "java/lang/Object".equals(parameterBounds.get(0).getValue())) continue;
            buffer.append(" extends ");
            TargetInfo.TypeParameterBoundTarget.extract(typeAnnotations, i, 0).forEach(typeAnnotation -> typeAnnotation.writeTo(buffer));
            buffer.append(GenericMain.getGenericCastTypeName(parameterBounds.get(0), Collections.emptyList()));
            for (int j = 1; j < parameterBounds.size(); ++j) {
                buffer.append(" & ");
                TargetInfo.TypeParameterBoundTarget.extract(typeAnnotations, i, j).forEach(typeAnnotation -> typeAnnotation.writeTo(buffer));
                buffer.append(GenericMain.getGenericCastTypeName(parameterBounds.get(j), Collections.emptyList()));
            }
        }
        buffer.append('>');
    }

    private static void appendFQClassNames(TextBuffer buffer, List<String> names) {
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            buffer.appendIndent(2).append(name);
            if (i >= names.size() - 1) continue;
            buffer.append(',').appendLineSeparator();
        }
    }

    static {
        MODIFIERS.put(1, "public");
        MODIFIERS.put(4, "protected");
        MODIFIERS.put(2, "private");
        MODIFIERS.put(1024, "abstract");
        MODIFIERS.put(8, "static");
        MODIFIERS.put(16, "final");
        MODIFIERS.put(2048, "strictfp");
        MODIFIERS.put(128, "transient");
        MODIFIERS.put(64, "volatile");
        MODIFIERS.put(32, "synchronized");
        MODIFIERS.put(256, "native");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/java/decompiler/main/ClassWriter", "appendParameterAnnotations"));
    }

    private static enum MType {
        CLASS,
        FIELD,
        METHOD;

    }
}

