/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public class StatEdge {
    @NotNull
    private EdgeType type;
    private Statement source;
    private Statement destination;
    private List<String> exceptions;
    public Statement closure;
    public boolean labeled;
    public boolean explicit;

    private StatEdge(@NotNull EdgeType type, Statement source, Statement destination, List<String> exceptions, Statement closure, boolean labeled, boolean explicit) {
        if (type == null) {
            StatEdge.$$$reportNull$$$0(0);
        }
        this.labeled = true;
        this.explicit = true;
        this.type = type;
        this.source = source;
        this.destination = destination;
        this.exceptions = exceptions;
        this.closure = closure;
        this.labeled = labeled;
        this.explicit = explicit;
    }

    public StatEdge(@NotNull EdgeType type, Statement source, Statement destination, Statement closure) {
        if (type == null) {
            StatEdge.$$$reportNull$$$0(1);
        }
        this(type, source, destination);
        this.closure = closure;
    }

    public StatEdge(@NotNull EdgeType type, Statement source, Statement destination) {
        if (type == null) {
            StatEdge.$$$reportNull$$$0(2);
        }
        this.labeled = true;
        this.explicit = true;
        this.type = type;
        this.source = source;
        this.destination = destination;
    }

    public StatEdge(Statement source, Statement destination, List<String> exceptions) {
        this(EdgeType.EXCEPTION, source, destination);
        if (exceptions != null) {
            this.exceptions = new ArrayList<String>(exceptions);
        }
    }

    @NotNull
    public EdgeType getType() {
        EdgeType edgeType = this.type;
        if (edgeType == null) {
            StatEdge.$$$reportNull$$$0(3);
        }
        return edgeType;
    }

    public void setType(@NotNull EdgeType type) {
        if (type == null) {
            StatEdge.$$$reportNull$$$0(4);
        }
        this.type = type;
    }

    public Statement getSource() {
        return this.source;
    }

    public void setSource(Statement source) {
        this.source = source;
    }

    public Statement getDestination() {
        return this.destination;
    }

    public void setDestination(Statement destination) {
        this.destination = destination;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public StatEdge copy() {
        return new StatEdge(this.type, this.source, this.destination, this.exceptions, this.closure, this.labeled, this.explicit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/decompiler/modules/decompiler/StatEdge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/decompiler/modules/decompiler/StatEdge";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static interface EdgeType {
        public static final EdgeType REGULAR = new EdgeType(){

            @Override
            public int mask() {
                return 1;
            }

            public String toString() {
                return "REGULAR";
            }
        };
        public static final EdgeType EXCEPTION = new EdgeType(){

            @Override
            public int mask() {
                return 2;
            }

            public String toString() {
                return "EXCEPTION";
            }
        };
        public static final EdgeType BREAK = new EdgeType(){

            @Override
            public int mask() {
                return 4;
            }

            public String toString() {
                return "BREAK";
            }
        };
        public static final EdgeType CONTINUE = new EdgeType(){

            @Override
            public int mask() {
                return 8;
            }

            public String toString() {
                return "CONTINUE";
            }
        };
        public static final EdgeType FINALLY_EXIT = new EdgeType(){

            @Override
            public int mask() {
                return 32;
            }

            public String toString() {
                return "FINALLY_EXIT";
            }
        };
        public static final EdgeType ALL = new EdgeType(){

            @Override
            public int mask() {
                return Integer.MIN_VALUE;
            }

            @Override
            @NotNull
            public EdgeType unite(@NotNull EdgeType other) {
                if (other == null) {
                    6.$$$reportNull$$$0(0);
                }
                6 v0 = this;
                if (v0 == null) {
                    6.$$$reportNull$$$0(1);
                }
                return v0;
            }

            public String toString() {
                return "ALL";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "other";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/java/decompiler/modules/decompiler/StatEdge$EdgeType$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/java/decompiler/modules/decompiler/StatEdge$EdgeType$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "unite";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "unite";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        public static final EdgeType DIRECT_ALL = new EdgeType(){

            @Override
            public int mask() {
                return 0x40000000;
            }

            @Override
            @NotNull
            public EdgeType unite(@NotNull EdgeType other) {
                if (other == null) {
                    7.$$$reportNull$$$0(0);
                }
                7 v0 = this;
                if (v0 == null) {
                    7.$$$reportNull$$$0(1);
                }
                return v0;
            }

            public String toString() {
                return "DIRECT_ALL";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "other";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/java/decompiler/modules/decompiler/StatEdge$EdgeType$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/java/decompiler/modules/decompiler/StatEdge$EdgeType$7";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "unite";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "unite";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        public static final EdgeType NULL = new EdgeType(){

            @Override
            public int mask() {
                return -1;
            }

            @Override
            @NotNull
            public EdgeType unite(@NotNull EdgeType other) {
                if (other == null) {
                    8.$$$reportNull$$$0(0);
                }
                throw new UnsupportedOperationException("Union operation is not supported for NULL edge type");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/java/decompiler/modules/decompiler/StatEdge$EdgeType$8", "unite"));
            }
        };

        public int mask();

        @NotNull
        default public EdgeType unite(final @NotNull EdgeType other) {
            if (other == null) {
                EdgeType.$$$reportNull$$$0(0);
            }
            return new EdgeType(){

                @Override
                public int mask() {
                    return this.mask() | other.mask();
                }
            };
        }

        public static EdgeType[] types() {
            return new EdgeType[]{REGULAR, EXCEPTION, BREAK, CONTINUE, FINALLY_EXIT};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/java/decompiler/modules/decompiler/StatEdge$EdgeType", "unite"));
        }
    }

    public static enum EdgeDirection {
        BACKWARD,
        FORWARD;

    }
}

