/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceBundleImpl
extends ResourceBundle {
    @NotNull
    private final SmartPsiElementPointer<PsiFile> myDefaultPropertiesFile;
    private boolean myValid;

    public ResourceBundleImpl(@NotNull PropertiesFile defaultPropertiesFile) {
        if (defaultPropertiesFile == null) {
            ResourceBundleImpl.$$$reportNull$$$0(0);
        }
        this.myValid = true;
        this.myDefaultPropertiesFile = SmartPointerManager.getInstance((Project)defaultPropertiesFile.getProject()).createSmartPsiElementPointer((PsiElement)defaultPropertiesFile.getContainingFile());
    }

    @Override
    @NotNull
    public List<PropertiesFile> getPropertiesFiles() {
        List<PropertiesFile> list = PropertiesImplUtil.getResourceBundleFiles(this.getDefaultPropertiesFile());
        if (list == null) {
            ResourceBundleImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public PropertiesFile getDefaultPropertiesFile() {
        PropertiesFile propertiesFile = Objects.requireNonNull(PropertiesImplUtil.getPropertiesFile((PsiFile)this.myDefaultPropertiesFile.getElement()));
        if (propertiesFile == null) {
            ResourceBundleImpl.$$$reportNull$$$0(2);
        }
        return propertiesFile;
    }

    @ApiStatus.Internal
    @Nullable
    public VirtualFile getDefaultVirtualFile() {
        return this.myDefaultPropertiesFile.getVirtualFile();
    }

    @Override
    @NotNull
    public String getBaseName() {
        String string = ResourceBundleManager.getInstance(this.getProject()).getBaseName(Objects.requireNonNull((PsiFile)this.myDefaultPropertiesFile.getElement()));
        if (string == null) {
            ResourceBundleImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getBaseDirectory() {
        VirtualFile virtualFile = this.getDefaultPropertiesFile().getVirtualFile().getParent();
        if (virtualFile == null) {
            ResourceBundleImpl.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @Override
    public boolean isValid() {
        return this.myValid && PropertiesImplUtil.getPropertiesFile((PsiFile)this.myDefaultPropertiesFile.getElement()) != null;
    }

    public void invalidate() {
        this.myValid = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleImpl resourceBundle = (ResourceBundleImpl)o;
        return this.myDefaultPropertiesFile.equals(resourceBundle.myDefaultPropertiesFile);
    }

    public int hashCode() {
        return this.myDefaultPropertiesFile.hashCode();
    }

    public String getUrl() {
        return this.getBaseDirectory() + "/" + this.getBaseName();
    }

    public String toString() {
        return "ResourceBundleImpl:" + this.getBaseName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPropertiesFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/ResourceBundleImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/ResourceBundleImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPropertiesFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

