/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndex;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0017\u0010\u000e\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0013H\u0002J\u001f\u0010\u001e\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0014H\u0002J-\u0010!\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0013H\u0002J\u0017\u0010!\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/CliVirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "index", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "enableSearchInCtSym", "", "<init>", "(Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;Lcom/intellij/psi/search/GlobalSearchScope;Z)V", "findVirtualFileWithHeader", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findSourceOrBinaryVirtualFile", "Lorg/jetbrains/annotations/Nullable;", "findMetadata", "Ljava/io/InputStream;", "findMetadataTopLevelClassesInPackage", "", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "hasMetadataPackage", "fqName", "findBuiltInsData", "findClass", "fileName", "rootType", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "findSigFileIfEnabled", "dir", "simpleName", "findBinaryOrSigClass", "findBinaryClass", "findSourceClass", "cli-base"})
@SourceDebugExtension(value={"SMAP\nCliVirtualFileFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliVirtualFileFinder.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CliVirtualFileFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,97:1\n1#2:98\n12574#3,2:99\n*S KotlinDebug\n*F\n+ 1 CliVirtualFileFinder.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CliVirtualFileFinder\n*L\n61#1:99,2\n*E\n"})
public final class CliVirtualFileFinder
extends VirtualFileFinder {
    @NotNull
    private final JvmDependenciesIndex index;
    @NotNull
    private final GlobalSearchScope scope;
    private final boolean enableSearchInCtSym;

    public CliVirtualFileFinder(@NotNull JvmDependenciesIndex index, @NotNull GlobalSearchScope scope, boolean enableSearchInCtSym) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.index = index;
        this.scope = scope;
        this.enableSearchInCtSym = enableSearchInCtSym;
    }

    @Nullable
    public VirtualFile findVirtualFileWithHeader(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.findBinaryOrSigClass(classId);
    }

    @Nullable
    public VirtualFile findSourceOrBinaryVirtualFile(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        VirtualFile virtualFile = this.findBinaryOrSigClass(classId);
        if (virtualFile == null) {
            virtualFile = this.findSourceClass(classId, classId.getRelativeClassName().asString() + ".java");
        }
        return virtualFile;
    }

    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        boolean bl2 = bl = !classId.isNestedClass();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Nested classes are not supported here: " + classId;
            throw new AssertionError((Object)string);
        }
        VirtualFile virtualFile = this.findBinaryClass(classId, classId.getShortClassName().asString() + ".kotlin_metadata");
        return virtualFile != null ? virtualFile.getInputStream() : null;
    }

    @NotNull
    public Set<String> findMetadataTopLevelClassesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        JvmDependenciesIndex.traverseDirectoriesInPackage$default(this.index, packageFqName, null, (arg_0, arg_1) -> CliVirtualFileFinder.findMetadataTopLevelClassesInPackage$lambda$1(result, arg_0, arg_1), 2, null);
        return (Set)result;
    }

    public boolean hasMetadataPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Ref.BooleanRef found = new Ref.BooleanRef();
        JvmDependenciesIndex.traverseDirectoriesInPackage$default(this.index, fqName, null, (arg_0, arg_1) -> CliVirtualFileFinder.hasMetadataPackage$lambda$3(found, arg_0, arg_1), 2, null);
        return found.element;
    }

    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Name name = Name.special((String)"<builtins-metadata>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(...)");
        ClassId classId = new ClassId(packageFqName, name);
        VirtualFile virtualFile = this.findBinaryClass(classId, BuiltInSerializerProtocol.INSTANCE.getBuiltInsFileName(packageFqName));
        return virtualFile != null ? virtualFile.getInputStream() : null;
    }

    private final VirtualFile findClass(ClassId classId, String fileName, Set<? extends JavaRoot.RootType> rootType) {
        Object object;
        VirtualFile virtualFile = (VirtualFile)this.index.findClass(classId, rootType, (arg_0, arg_1) -> CliVirtualFileFinder.findClass$lambda$4(fileName, arg_0, arg_1));
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            object = this.scope.contains(it) ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final VirtualFile findSigFileIfEnabled(VirtualFile dir, String simpleName) {
        return this.enableSearchInCtSym ? dir.findChild(simpleName + ".sig") : null;
    }

    private final VirtualFile findBinaryOrSigClass(ClassId classId, String simpleName, Set<? extends JavaRoot.RootType> rootType) {
        Object object;
        VirtualFile virtualFile = (VirtualFile)this.index.findClass(classId, rootType, (arg_0, arg_1) -> CliVirtualFileFinder.findBinaryOrSigClass$lambda$6(simpleName, this, arg_0, arg_1));
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            object = this.scope.contains(it) ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final VirtualFile findBinaryOrSigClass(ClassId classId) {
        String string = classId.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return this.findBinaryOrSigClass(classId, StringsKt.replace$default((String)string, (char)'.', (char)'$', (boolean)false, (int)4, null), JavaRoot.RootTypes.getOnlyBinary());
    }

    private final VirtualFile findBinaryClass(ClassId classId, String fileName) {
        return this.findClass(classId, fileName, JavaRoot.RootTypes.getOnlyBinary());
    }

    private final VirtualFile findSourceClass(ClassId classId, String fileName) {
        return this.findClass(classId, fileName, JavaRoot.RootTypes.getOnlySource());
    }

    private static final boolean findMetadataTopLevelClassesInPackage$lambda$1(ObjectOpenHashSet $result, VirtualFile dir, JavaRoot.RootType rootType) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"<unused var>");
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])dir.getChildren());
        while (iterator2.hasNext()) {
            VirtualFile child = (VirtualFile)iterator2.next();
            if (!Intrinsics.areEqual((Object)child.getExtension(), (Object)"kotlin_metadata")) continue;
            $result.add((Object)child.getNameWithoutExtension());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasMetadataPackage$lambda$3(Ref.BooleanRef $found, VirtualFile dir, JavaRoot.RootType rootType) {
        boolean bl;
        boolean bl2;
        block1: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"<unused var>");
            boolean bl3 = $found.element;
            VirtualFile[] virtualFileArray = dir.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] objectArray = virtualFileArray;
            bl2 = bl3;
            Ref.BooleanRef booleanRef = $found;
            boolean $i$f$any = false;
            for (void element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getExtension(), (Object)"kotlin_metadata")) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        boolean bl5 = bl;
        booleanRef.element = bl2 | bl5;
        return !$found.element;
    }

    private static final VirtualFile findClass$lambda$4(String $fileName, VirtualFile dir, JavaRoot.RootType rootType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"<unused var>");
        VirtualFile virtualFile = dir.findChild($fileName);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile p0 = virtualFile2 = virtualFile;
            boolean bl = false;
            object = p0.isValid() ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final VirtualFile findBinaryOrSigClass$lambda$6(String $simpleName, CliVirtualFileFinder this$0, VirtualFile dir, JavaRoot.RootType rootType) {
        VirtualFile file;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"<unused var>");
        VirtualFile virtualFile = dir.findChild($simpleName + ".class");
        if (virtualFile == null) {
            virtualFile = this$0.findSigFileIfEnabled(dir, $simpleName);
        }
        return (file = virtualFile) != null && file.isValid() ? file : null;
    }
}

