/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EscapedIdentifiersLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "transformer", "Lorg/jetbrains/kotlin/ir/backend/js/lower/EscapedIdentifiersLowering$ReferenceTransformer;", "moduleKind", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "isEscapedIdentifiersResolved", "", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ReferenceTransformer", "backend.js"})
public final class EscapedIdentifiersLowering
implements BodyLoweringPass {
    @NotNull
    private final ReferenceTransformer transformer;
    @NotNull
    private final ModuleKind moduleKind;
    private final boolean isEscapedIdentifiersResolved;

    public EscapedIdentifiersLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.transformer = new ReferenceTransformer(context);
        Object object = context.getConfiguration().get(JSConfigurationKeys.MODULE_KIND);
        Intrinsics.checkNotNull((Object)object);
        this.moduleKind = (ModuleKind)((Object)object);
        this.isEscapedIdentifiersResolved = CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)context.getConfiguration()).supportsFeature(LanguageFeature.JsAllowInvalidCharsIdentifiersEscaping);
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (!this.isEscapedIdentifiersResolved || this.moduleKind != ModuleKind.PLAIN) {
            return;
        }
        LowerKt.runOnFilePostfix((BodyLoweringPass)this, (IrFile)irFile, (boolean)true);
    }

    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!this.isEscapedIdentifiersResolved || this.moduleKind != ModuleKind.PLAIN) {
            return;
        }
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irBody), (IrElementTransformerVoid)this.transformer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\u001f*\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\f\u0010 \u001a\u00020\u001c*\u00020!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/EscapedIdentifiersLowering$ReferenceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "globalThisReceiver", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "getGlobalThisReceiver", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "dummyDispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getDummyDispatchReceiverParameter", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "needToBeWrappedWithGlobalThis", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "wrapInGlobalThis", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicMemberExpression;", "isThisReceiver", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "backend.js"})
    @SourceDebugExtension(value={"SMAP\nEscapedIdentifiersLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EscapedIdentifiersLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/EscapedIdentifiersLowering$ReferenceTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
    private static final class ReferenceTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final JsIrBackendContext context;

        public ReferenceTransformer(@NotNull JsIrBackendContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
        }

        @NotNull
        public final JsIrBackendContext getContext() {
            return this.context;
        }

        private final IrCallImpl getGlobalThisReceiver() {
            IrType irType = (IrType)this.context.getDynamicType();
            IrSimpleFunction irSimpleFunction = ((IrProperty)this.context.getIntrinsics().getGlobalThis().getOwner()).getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            return new IrCallImpl(-1, -1, irType, irSimpleFunction.getSymbol(), 0, 0, null, null, 192, null);
        }

        private final IrValueParameter getDummyDispatchReceiverParameter(IrFunction $this$dummyDispatchReceiverParameter) {
            IrValueParameter irValueParameter;
            IrValueParameter it = irValueParameter = this.context.getIrFactory().createValueParameter($this$dummyDispatchReceiverParameter.getStartOffset(), $this$dummyDispatchReceiverParameter.getEndOffset(), $this$dummyDispatchReceiverParameter.getOrigin(), SpecialNames.THIS, this.context.getIrBuiltIns().getAnyType(), false, (IrValueParameterSymbol)new IrValueParameterSymbolImpl(null, null, 3, null), -1, null, false, false, false);
            boolean bl = false;
            it.setParent((IrDeclarationParent)$this$dummyDispatchReceiverParameter);
            return irValueParameter;
        }

        @NotNull
        public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration owner = expression2.getSymbol().getOwner();
            return !IrUtilsKt.isEffectivelyExternal((IrDeclaration)((IrDeclaration)owner)) || this.isThisReceiver(owner) || !this.needToBeWrappedWithGlobalThis((IrDeclarationWithName)owner) ? super.visitGetValue(expression2) : (IrExpression)this.wrapInGlobalThis((IrDeclarationWithName)owner, (IrExpression)expression2);
        }

        @NotNull
        public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
            IrExpression irExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrValueDeclaration field = expression2.getSymbol().getOwner();
            if (!IrUtilsKt.isEffectivelyExternal((IrDeclaration)((IrDeclaration)field)) || !this.needToBeWrappedWithGlobalThis((IrDeclarationWithName)field)) {
                irExpression = super.visitSetValue(expression2);
            } else {
                int n = expression2.getStartOffset();
                int n2 = expression2.getEndOffset();
                IrDynamicMemberExpression irDynamicMemberExpression = this.wrapInGlobalThis((IrDeclarationWithName)field, (IrExpression)expression2);
                IrExpression irExpression2 = expression2.getValue();
                IrType irType = expression2.getType();
                IrFieldSymbolImpl irFieldSymbolImpl = new IrFieldSymbolImpl(null, null, 3, null);
                irExpression = (IrExpression)BuildersKt.IrSetFieldImpl((int)n, (int)n2, (IrFieldSymbol)((IrFieldSymbol)irFieldSymbolImpl), (IrExpression)((IrExpression)irDynamicMemberExpression), (IrExpression)irExpression2, (IrType)irType, null, null);
            }
            return irExpression;
        }

        @NotNull
        public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrClass owner = (IrClass)expression2.getSymbol().getOwner();
            return !IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)owner)) || !this.needToBeWrappedWithGlobalThis((IrDeclarationWithName)owner) ? super.visitGetObjectValue(expression2) : (IrExpression)this.wrapInGlobalThis((IrDeclarationWithName)owner, (IrExpression)expression2);
        }

        @NotNull
        public IrExpression visitCall(@NotNull IrCall expression2) {
            IrCall irCall;
            IrElement property;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            IrSimpleFunction function2 = IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)expression2.getSymbol().getOwner());
            IrPropertySymbol irPropertySymbol = function2.getCorrespondingPropertySymbol();
            IrElement irElement = irPropertySymbol != null && (irPropertySymbol = (IrProperty)irPropertySymbol.getOwner()) != null ? (IrElement)irPropertySymbol : (property = (IrElement)function2);
            if (expression2.getDispatchReceiver() != null || !IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)property)) || !this.needToBeWrappedWithGlobalThis((IrDeclarationWithName)property)) {
                irCall = expression2;
            } else {
                IrCall irCall2;
                IrCall $this$visitCall_u24lambda_u241 = irCall2 = expression2;
                boolean bl = false;
                $this$visitCall_u24lambda_u241.setDispatchReceiver((IrExpression)this.getGlobalThisReceiver());
                IrCall it = irCall2;
                boolean bl2 = false;
                if (function2.getDispatchReceiverParameter() == null) {
                    function2.setDispatchReceiverParameter(this.getDummyDispatchReceiverParameter((IrFunction)function2));
                }
                irCall = irCall2;
            }
            IrCall updatedCall = irCall;
            return super.visitCall(updatedCall);
        }

        private final boolean needToBeWrappedWithGlobalThis(IrDeclarationWithName $this$needToBeWrappedWithGlobalThis) {
            String string = AnnotationUtilsKt.getJsNameOrKotlinName($this$needToBeWrappedWithGlobalThis).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return !IdentifierPolicyKt.isValidES5Identifier(string);
        }

        private final IrDynamicMemberExpression wrapInGlobalThis(IrDeclarationWithName $this$wrapInGlobalThis, IrExpression expression2) {
            int n = expression2.getStartOffset();
            int n2 = expression2.getEndOffset();
            IrType irType = expression2.getType();
            String string = AnnotationUtilsKt.getJsNameOrKotlinName($this$wrapInGlobalThis).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            return (IrDynamicMemberExpression)BuildersKt.IrDynamicMemberExpressionImpl((int)n, (int)n2, (IrType)irType, (String)string, (IrExpression)((IrExpression)this.getGlobalThisReceiver()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isThisReceiver(IrValueDeclaration $this$isThisReceiver) {
            if ($this$isThisReceiver instanceof IrVariable) return false;
            IrDeclarationParent p = $this$isThisReceiver.getParent();
            if (p instanceof IrSimpleFunction) {
                if ($this$isThisReceiver != ((IrSimpleFunction)p).getDispatchReceiverParameter()) return false;
                return true;
            }
            if (!(p instanceof IrClass)) return false;
            if ($this$isThisReceiver != ((IrClass)p).getThisReceiver()) return false;
            return true;
        }
    }
}

