/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.common.Symbol;
import org.jetbrains.kotlin.js.util.AstUtil;

public class JsVars
extends SourceInfoAwareJsNode
implements JsStatement,
Iterable<JsVar> {
    private final List<JsVar> vars;
    private boolean multiline;

    public JsVars() {
        this((List<JsVar>)new SmartList(), false);
    }

    public JsVars(boolean multiline) {
        this((List<JsVar>)new SmartList(), multiline);
    }

    public JsVars(List<JsVar> vars, boolean multiline) {
        this.vars = vars;
        this.multiline = multiline;
    }

    public JsVars(JsVar var) {
        this((List<JsVar>)new SmartList((Object)var), false);
    }

    public JsVars(JsVar ... vars) {
        this((List<JsVar>)new SmartList((Object[])vars), false);
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public void add(JsVar var) {
        this.vars.add(var);
    }

    public void addAll(Collection<? extends JsVar> vars) {
        this.vars.addAll(vars);
    }

    public void addAll(JsVars otherVars) {
        this.vars.addAll(otherVars.vars);
    }

    public void addIfHasInitializer(JsVar var) {
        if (var.getInitExpression() != null) {
            this.add(var);
        }
    }

    public boolean isEmpty() {
        return this.vars.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<JsVar> iterator() {
        Iterator<JsVar> iterator2 = this.vars.iterator();
        if (iterator2 == null) {
            JsVars.$$$reportNull$$$0(0);
        }
        return iterator2;
    }

    public List<JsVar> getVars() {
        return this.vars;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitVars(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.vars);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        if (v.visit(this, ctx)) {
            v.acceptList(this.vars);
        }
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsVars deepCopy() {
        JsVars jsVars = (JsVars)new JsVars(AstUtil.deepCopy(this.vars), this.multiline).withMetadataFrom(this);
        if (jsVars == null) {
            JsVars.$$$reportNull$$$0(1);
        }
        return jsVars;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/kotlin/js/backend/ast/JsVars";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "deepCopy";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class JsVar
    extends SourceInfoAwareJsNode
    implements HasName {
        private JsName name;
        private JsExpression initExpression;

        public JsVar(JsName name) {
            this.name = name;
        }

        public JsVar(JsName name, @Nullable JsExpression initExpression) {
            this.name = name;
            this.initExpression = initExpression;
        }

        public JsExpression getInitExpression() {
            return this.initExpression;
        }

        @Override
        public JsName getName() {
            return this.name;
        }

        @Override
        public void setName(JsName name) {
            this.name = name;
        }

        @Override
        public Symbol getSymbol() {
            return this.name;
        }

        public void setInitExpression(JsExpression initExpression) {
            this.initExpression = initExpression;
        }

        @Override
        public void accept(JsVisitor v) {
            v.visit(this);
        }

        @Override
        public void acceptChildren(JsVisitor visitor2) {
            if (this.initExpression != null) {
                visitor2.accept(this.initExpression);
            }
        }

        @Override
        public void traverse(JsVisitorWithContext v, JsContext ctx) {
            if (v.visit(this, ctx) && this.initExpression != null) {
                this.initExpression = v.accept(this.initExpression);
            }
            v.endVisit(this, ctx);
        }

        @Override
        @NotNull
        public JsVar deepCopy() {
            if (this.initExpression == null) {
                return new JsVar(this.name);
            }
            JsVar jsVar = (JsVar)new JsVar(this.name, this.initExpression.deepCopy()).withMetadataFrom(this);
            if (jsVar == null) {
                JsVar.$$$reportNull$$$0(0);
            }
            return jsVar;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsVars$JsVar", "deepCopy"));
        }
    }
}

