/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.IntentionUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GrLambdaExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\b\u0010\b\u001a\u00020\u0006H\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J!\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/AddParenthesesToLambdaParameterIntention;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;", "parameterList", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/GrLambdaExpression;)V", "closureText", "", "lambda", "getFamilyName", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.groovy.psi"})
public final class AddParenthesesToLambdaParameterIntention
extends PsiUpdateModCommandAction<GrLambdaExpression> {
    public AddParenthesesToLambdaParameterIntention(@NotNull GrLambdaExpression parameterList) {
        Intrinsics.checkNotNullParameter((Object)parameterList, (String)"parameterList");
        super((PsiElement)parameterList);
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.parenthesis.to.lambda.parameter.list", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull GrLambdaExpression lambda) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        GrParameterList grParameterList = lambda.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)grParameterList, (String)"getParameterList(...)");
        GrParameterList parameterList = grParameterList;
        if (parameterList.getLParen() == null) {
            return Presentation.of((String)this.getFamilyName());
        }
        return null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull GrLambdaExpression lambda, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        String closureText = this.closureText(lambda);
        GrLambdaExpression grLambdaExpression = GroovyPsiElementFactory.getInstance(context.project()).createLambdaFromText(closureText);
        Intrinsics.checkNotNullExpressionValue((Object)grLambdaExpression, (String)"createLambdaFromText(...)");
        GrLambdaExpression closure = grLambdaExpression;
        lambda.replaceWithExpression(closure, false);
    }

    private final String closureText(GrLambdaExpression lambda) {
        StringBuilder closureText = new StringBuilder();
        closureText.append("(");
        GrParameterList grParameterList = lambda.getParameterList();
        Intrinsics.checkNotNullExpressionValue((Object)grParameterList, (String)"getParameterList(...)");
        GrParameterList parameterList = grParameterList;
        String string = parameterList.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        IntentionUtilKt.appendTextBetween(closureText, string, parameterList.getLParen(), parameterList.getRParen());
        closureText.append(")");
        String string2 = lambda.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        IntentionUtilKt.appendTextBetween(closureText, string2, parameterList, null);
        String string3 = closureText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }
}

