/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.bugs.AddMethodFix;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class AddClassToExtendsFix
extends GroovyFix {
    private final SmartPsiElementPointer<GrTypeDefinition> myPsiClassPointer;
    private final String myInterfaceName;

    public AddClassToExtendsFix(@NotNull GrTypeDefinition psiClass, @NotNull String interfaceName) {
        if (psiClass == null) {
            AddClassToExtendsFix.$$$reportNull$$$0(0);
        }
        if (interfaceName == null) {
            AddClassToExtendsFix.$$$reportNull$$$0(1);
        }
        this.myPsiClassPointer = SmartPointersKt.createSmartPointer((PsiElement)psiClass);
        this.myInterfaceName = interfaceName;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        GrTypeDefinition element;
        if (target == null) {
            AddClassToExtendsFix.$$$reportNull$$$0(2);
        }
        if ((element = (GrTypeDefinition)this.myPsiClassPointer.getElement()) == null) {
            return null;
        }
        GrTypeDefinition copy = (GrTypeDefinition)PsiTreeUtil.findSameElementInCopy((PsiElement)element, (PsiFile)target);
        return new AddClassToExtendsFix(copy, this.myInterfaceName);
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        boolean addTypeParam;
        GrTypeDefinition psiClass;
        if (project == null) {
            AddClassToExtendsFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            AddClassToExtendsFix.$$$reportNull$$$0(4);
        }
        if ((psiClass = (GrTypeDefinition)this.myPsiClassPointer.getElement()) == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        PsiClass comparable = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Comparable", psiClass.getResolveScope());
        boolean bl = addTypeParam = comparable != null && comparable.getTypeParameters().length == 1;
        if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"java.lang.Comparable")) {
            GrReferenceList list;
            if (psiClass.isInterface()) {
                list = psiClass.getExtendsClause();
                if (list == null) {
                    list = factory.createExtendsClause();
                    anchor = psiClass.getImplementsClause();
                    if (anchor == null) {
                        anchor = psiClass.getBody();
                    }
                    if (anchor == null) {
                        return;
                    }
                    list = (GrReferenceList)psiClass.addBefore(list, anchor);
                    psiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor.getNode());
                    psiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", list.getNode());
                }
            } else {
                list = psiClass.getImplementsClause();
                if (list == null) {
                    list = factory.createImplementsClause();
                    anchor = psiClass.getBody();
                    if (anchor == null) {
                        return;
                    }
                    list = (GrReferenceList)psiClass.addBefore(list, anchor);
                    psiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", list.getNode());
                    psiClass.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor.getNode());
                }
            }
            GrCodeReferenceElement _ref = factory.createCodeReference(this.myInterfaceName + (String)(addTypeParam ? "<" + AddMethodFix.generateTypeText(psiClass) + ">" : ""));
            GrCodeReferenceElement ref2 = (GrCodeReferenceElement)list.add(_ref);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)ref2);
        }
        if (comparable != null && !psiClass.isInterface()) {
            PsiMethod baseMethod = comparable.getMethods()[0];
            OverrideImplementUtil.overrideOrImplement((PsiClass)psiClass, (PsiMethod)baseMethod);
        }
    }

    @NotNull
    public String getName() {
        String string = GroovyBundle.message("implement.class", this.myInterfaceName);
        if (string == null) {
            AddClassToExtendsFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.class.to.extends.family.name", new Object[0]);
        if (string == null) {
            AddClassToExtendsFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/codeInspection/bugs/AddClassToExtendsFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/bugs/AddClassToExtendsFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

