/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.ext.spock.DataTablesKt;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.ext.spock.SpockVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0002\u001a \u0010\b\u001a\u00020\t2\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\f\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00032\u0006\u0010\u0010\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a2\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010&H\u0002\u001a$\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e2\u0006\u0010(\u001a\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$H\u0002\u001a\u0018\u0010)\u001a\u0004\u0018\u00010\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$H\u0002\u001a\"\u0010*\u001a\u00020\u00012\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070,2\b\u0010-\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\f\u0010.\u001a\u00020\t*\u00020 H\u0002\u00a8\u0006/"}, d2={"addInitializers", "", "variables", "", "Lorg/jetbrains/plugins/groovy/ext/spock/SpockVariableDescriptor;", "initializers", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "addInitializersFromTableRow", "", "row", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrStatement;", "addParameterizationInitializers", "list", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/GrListOrMap;", "createVariableDescriptor", "element", "Lcom/intellij/psi/PsiElement;", "createVariableMap", "", "", "methodBlock", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrOpenBlock;", "method", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/members/GrMethod;", "extractColumns", "extractVariableFromAssignment", "assignment", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrAssignmentExpression;", "extractVariablesFromParameterization", "", "parameterization", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrBinaryExpression;", "extractVariablesFromStatement", "current", "statements", "Ljava/util/Queue;", "consumer", "Lkotlin/Function1;", "extractVariablesFromTable", "header", "findWhereBlockStart", "splitOr", "res", "", "expression", "isLeftShift", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\ndataVariables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dataVariables.kt\norg/jetbrains/plugins/groovy/ext/spock/DataVariablesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,161:1\n1#2:162\n1855#3,2:163\n1855#3,2:165\n1549#3:171\n1620#3,3:172\n11065#4:167\n11400#4,3:168\n*S KotlinDebug\n*F\n+ 1 dataVariables.kt\norg/jetbrains/plugins/groovy/ext/spock/DataVariablesKt\n*L\n54#1:163,2\n57#1:165,2\n102#1:171\n102#1:172,3\n78#1:167\n78#1:168,3\n*E\n"})
public final class DataVariablesKt {
    @NotNull
    public static final Map<String, SpockVariableDescriptor> createVariableMap(@NotNull GrMethod method) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                object = method.getBlock();
                if (object == null) break block2;
                GrOpenBlock p0 = object;
                boolean bl = false;
                Map<String, SpockVariableDescriptor> map2 = DataVariablesKt.createVariableMap(p0);
                object = map2;
                if (map2 != null) break block3;
            }
            object = MapsKt.emptyMap();
        }
        return object;
    }

    private static final Map<String, SpockVariableDescriptor> createVariableMap(GrOpenBlock methodBlock) {
        GrStatement[] grStatementArray = methodBlock.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)grStatementArray, (String)"getStatements(...)");
        LinkedList statements2 = new LinkedList(ArraysKt.asList((Object[])grStatementArray));
        GrStatement grStatement = DataVariablesKt.findWhereBlockStart(statements2);
        if (grStatement == null) {
            return MapsKt.emptyMap();
        }
        GrStatement whereBlockStart = grStatement;
        HashMap<String, SpockVariableDescriptor> result2 = new HashMap<String, SpockVariableDescriptor>();
        DataVariablesKt.extractVariablesFromStatement(whereBlockStart, statements2, (Function1<? super SpockVariableDescriptor, Unit>)((Function1)new Function1<SpockVariableDescriptor, Unit>(result2){
            final /* synthetic */ HashMap<String, SpockVariableDescriptor> $result;
            {
                this.$result = $result;
                super(1, Intrinsics.Kotlin.class, "consume", "createVariableMap$consume(Ljava/util/HashMap;Lorg/jetbrains/plugins/groovy/ext/spock/SpockVariableDescriptor;)V", 0);
            }

            public final void invoke(@NotNull SpockVariableDescriptor p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                DataVariablesKt.access$createVariableMap$consume(this.$result, p0);
            }
        }));
        while (!statements2.isEmpty()) {
            Object e = statements2.remove();
            Intrinsics.checkNotNullExpressionValue(e, (String)"remove(...)");
            DataVariablesKt.extractVariablesFromStatement((GrStatement)e, statements2, (Function1<? super SpockVariableDescriptor, Unit>)((Function1)new Function1<SpockVariableDescriptor, Unit>(result2){
                final /* synthetic */ HashMap<String, SpockVariableDescriptor> $result;
                {
                    this.$result = $result;
                    super(1, Intrinsics.Kotlin.class, "consume", "createVariableMap$consume(Ljava/util/HashMap;Lorg/jetbrains/plugins/groovy/ext/spock/SpockVariableDescriptor;)V", 0);
                }

                public final void invoke(@NotNull SpockVariableDescriptor p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    DataVariablesKt.access$createVariableMap$consume(this.$result, p0);
                }
            }));
        }
        return result2;
    }

    private static final GrStatement findWhereBlockStart(Queue<GrStatement> statements2) {
        while (!statements2.isEmpty()) {
            GrLabeledStatement topStatement;
            GrStatement grStatement = statements2.remove();
            if ((grStatement instanceof GrLabeledStatement ? (GrLabeledStatement)grStatement : null) == null) continue;
            topStatement = topStatement;
            GrStatement grStatement2 = DataTablesKt.findWhereLabeledStatement(topStatement);
            if (grStatement2 == null) continue;
            return grStatement2;
        }
        return null;
    }

    private static final void extractVariablesFromStatement(GrStatement current, Queue<GrStatement> statements2, Function1<? super SpockVariableDescriptor, Unit> consumer) {
        if (current instanceof GrAssignmentExpression) {
            SpockVariableDescriptor spockVariableDescriptor = DataVariablesKt.extractVariableFromAssignment((GrAssignmentExpression)current);
            if (spockVariableDescriptor != null) {
                consumer.invoke((Object)spockVariableDescriptor);
            }
        } else if (current instanceof GrBinaryExpression && DataVariablesKt.isLeftShift((GrBinaryExpression)current)) {
            Iterable $this$forEach$iv = DataVariablesKt.extractVariablesFromParameterization((GrBinaryExpression)current);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                consumer.invoke(element$iv);
            }
        } else if (current instanceof GrBinaryExpression && DataTablesKt.isOr((GrBinaryExpression)current)) {
            Iterable $this$forEach$iv = DataVariablesKt.extractVariablesFromTable((GrBinaryExpression)current, statements2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                consumer.invoke(element$iv);
            }
        } else if (current instanceof GrLabeledStatement && Intrinsics.areEqual((Object)((GrLabeledStatement)current).getName(), (Object)"and")) {
            GrStatement grStatement = ((GrLabeledStatement)current).getStatement();
            if (grStatement == null) {
                return;
            }
            GrStatement labeledStatement = grStatement;
            DataVariablesKt.extractVariablesFromStatement(labeledStatement, statements2, consumer);
        }
    }

    private static final SpockVariableDescriptor extractVariableFromAssignment(GrAssignmentExpression assignment) {
        SpockVariableDescriptor spockVariableDescriptor = DataVariablesKt.createVariableDescriptor(assignment.getLValue());
        return spockVariableDescriptor != null ? spockVariableDescriptor.addExpression(assignment.getRValue()) : null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final Collection<SpockVariableDescriptor> extractVariablesFromParameterization(GrBinaryExpression parameterization) {
        void $this$mapTo$iv$iv;
        GrExpression grExpression = parameterization.getLeftOperand();
        Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"getLeftOperand(...)");
        GrExpression leftOperand = grExpression;
        GrExpression rightOperand = parameterization.getRightOperand();
        GrExpression grExpression2 = leftOperand;
        if (grExpression2 instanceof GrReferenceExpression) {
            Collection collection;
            SpockVariableDescriptor spockVariableDescriptor = DataVariablesKt.createVariableDescriptor(leftOperand);
            SpockVariableDescriptor variable = spockVariableDescriptor != null ? spockVariableDescriptor.addExpressionOfCollection(rightOperand) : null;
            Object object = variable;
            if (object != null) {
                SpockVariableDescriptor p0 = object;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)p0);
                object = list;
                if (list != null) {
                    collection = (Collection)object;
                    return collection;
                }
            }
            collection = CollectionsKt.emptyList();
            return collection;
        }
        if (!(grExpression2 instanceof GrListOrMap)) return CollectionsKt.emptyList();
        GrExpression[] grExpressionArray = ((GrListOrMap)leftOperand).getInitializers();
        Intrinsics.checkNotNullExpressionValue((Object)grExpressionArray, (String)"getInitializers(...)");
        Object[] $this$map$iv = grExpressionArray;
        boolean $i$f$map = false;
        Object[] p0 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = 0;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        while (true) {
            void p02;
            if (n >= n2) {
                List variables = (List)destination$iv$iv;
                if (!(rightOperand instanceof GrListOrMap)) return CollectionsKt.filterNotNull((Iterable)variables);
                DataVariablesKt.addParameterizationInitializers(variables, (GrListOrMap)rightOperand);
                return CollectionsKt.filterNotNull((Iterable)variables);
            }
            void item$iv$iv = $this$mapTo$iv$iv[n];
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DataVariablesKt.createVariableDescriptor((PsiElement)p02));
            ++n;
        }
    }

    private static final void addParameterizationInitializers(List<SpockVariableDescriptor> variables, GrListOrMap list) {
        GrExpression[] grExpressionArray = list.getInitializers();
        Intrinsics.checkNotNullExpressionValue((Object)grExpressionArray, (String)"getInitializers(...)");
        for (GrExpression expression : grExpressionArray) {
            if (expression instanceof GrListOrMap) {
                GrExpression[] grExpressionArray2 = ((GrListOrMap)expression).getInitializers();
                Intrinsics.checkNotNullExpressionValue((Object)grExpressionArray2, (String)"getInitializers(...)");
                DataVariablesKt.addInitializers(variables, ArraysKt.toList((Object[])grExpressionArray2));
                continue;
            }
            Iterator<SpockVariableDescriptor> iterator2 = variables.iterator();
            while (iterator2.hasNext()) {
                SpockVariableDescriptor variable;
                SpockVariableDescriptor spockVariableDescriptor = variable = iterator2.next();
                if (spockVariableDescriptor == null) continue;
                spockVariableDescriptor.addExpressionOfCollection(expression);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<SpockVariableDescriptor> extractVariablesFromTable(GrBinaryExpression header2, Queue<GrStatement> statements2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = DataVariablesKt.extractColumns(header2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DataVariablesKt.createVariableDescriptor((PsiElement)p0));
        }
        List variables = (List)destination$iv$iv;
        while (!((Collection)statements2).isEmpty()) {
            GrStatement statement = statements2.peek();
            Intrinsics.checkNotNull((Object)statement);
            if (!DataVariablesKt.addInitializersFromTableRow(variables, statement)) break;
            statements2.remove();
        }
        return CollectionsKt.filterNotNull((Iterable)variables);
    }

    private static final boolean addInitializersFromTableRow(List<SpockVariableDescriptor> variables, GrStatement row) {
        if (row instanceof GrBinaryExpression && DataTablesKt.isOr((GrBinaryExpression)row)) {
            DataVariablesKt.addInitializers(variables, (Iterable<? extends GrExpression>)DataVariablesKt.extractColumns((GrExpression)row));
            return true;
        }
        if (row instanceof GrLabeledStatement && Intrinsics.areEqual((Object)((GrLabeledStatement)row).getName(), (Object)"and")) {
            GrStatement labeledStatement = ((GrLabeledStatement)row).getStatement();
            return labeledStatement != null && DataVariablesKt.addInitializersFromTableRow(variables, labeledStatement);
        }
        return false;
    }

    private static final List<GrExpression> extractColumns(GrExpression element) {
        ArrayList result2 = new ArrayList();
        DataVariablesKt.splitOr(result2, element);
        return result2;
    }

    private static final void splitOr(List<GrExpression> res, GrExpression expression) {
        if (expression instanceof GrBinaryExpression && DataTablesKt.isOr((GrBinaryExpression)expression)) {
            DataVariablesKt.splitOr(res, ((GrBinaryExpression)expression).getLeftOperand());
            DataVariablesKt.splitOr(res, ((GrBinaryExpression)expression).getRightOperand());
        } else {
            res.add(expression);
        }
    }

    private static final SpockVariableDescriptor createVariableDescriptor(PsiElement element) {
        String string = SpockUtils.getNameByReference(element);
        if (string == null) {
            return null;
        }
        String name = string;
        if (Intrinsics.areEqual((Object)name, (Object)"_")) {
            return null;
        }
        return new SpockVariableDescriptor(element, name);
    }

    private static final void addInitializers(List<SpockVariableDescriptor> variables, Iterable<? extends GrExpression> initializers) {
        for (Pair pair : CollectionsKt.zip((Iterable)variables, initializers)) {
            SpockVariableDescriptor variable = (SpockVariableDescriptor)pair.component1();
            GrExpression initializer = (GrExpression)pair.component2();
            SpockVariableDescriptor spockVariableDescriptor = variable;
            if (spockVariableDescriptor == null) continue;
            spockVariableDescriptor.addExpression(initializer);
        }
    }

    private static final boolean isLeftShift(GrBinaryExpression $this$isLeftShift) {
        return $this$isLeftShift.getOperationTokenType() == GroovyElementTypes.LEFT_SHIFT_SIGN;
    }

    private static final void createVariableMap$consume(HashMap<String, SpockVariableDescriptor> result2, SpockVariableDescriptor variable) {
        Map map2 = result2;
        String string = variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        map2.put(string, variable);
    }

    public static final /* synthetic */ void access$createVariableMap$consume(HashMap result2, SpockVariableDescriptor variable) {
        DataVariablesKt.createVariableMap$consume(result2, variable);
    }
}

