/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.conversions.IndexedExpressionConversionPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;

public final class IndexedExpressionConversionIntention
extends GrPsiUpdateIntention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new IndexedExpressionConversionPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        if (element == null) {
            IndexedExpressionConversionIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            IndexedExpressionConversionIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            IndexedExpressionConversionIntention.$$$reportNull$$$0(2);
        }
        GrIndexProperty arrayIndexExpression = (GrIndexProperty)element;
        GrArgumentList argList = (GrArgumentList)arrayIndexExpression.getLastChild();
        assert (argList != null);
        GrExpression[] arguments2 = argList.getExpressionArguments();
        PsiElement parent2 = element.getParent();
        GrExpression arrayExpression = arrayIndexExpression.getInvokedExpression();
        if (!(parent2 instanceof GrAssignmentExpression)) {
            IndexedExpressionConversionIntention.rewriteAsGetAt(arrayIndexExpression, arrayExpression, arguments2[0]);
            return;
        }
        GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)parent2;
        GrExpression rhs = assignmentExpression.getRValue();
        if (rhs.equals(element)) {
            IndexedExpressionConversionIntention.rewriteAsGetAt(arrayIndexExpression, arrayExpression, arguments2[0]);
        } else {
            IndexedExpressionConversionIntention.rewriteAsSetAt(assignmentExpression, arrayExpression, arguments2[0], rhs);
        }
    }

    private static void rewriteAsGetAt(GrIndexProperty arrayIndexExpression, GrExpression arrayExpression, GrExpression argument) throws IncorrectOperationException {
        PsiImplUtil.replaceExpression(arrayExpression.getText() + ".getAt(" + argument.getText() + ")", arrayIndexExpression);
    }

    private static void rewriteAsSetAt(GrAssignmentExpression assignment, GrExpression arrayExpression, GrExpression argument, GrExpression value2) throws IncorrectOperationException {
        PsiImplUtil.replaceExpression(arrayExpression.getText() + ".putAt(" + argument.getText() + ", " + value2.getText() + ")", assignment);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "updater";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/intentions/conversions/IndexedExpressionConversionIntention";
        objectArray[2] = "processIntention";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

