/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.impl;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.api.GroovyCompletionConsumer;

public class AccumulatingGroovyCompletionConsumer
implements GroovyCompletionConsumer {
    private final CompletionResultSet myResultSet;
    private final Set<LookupElement> myAccumulator;

    public AccumulatingGroovyCompletionConsumer(CompletionResultSet set) {
        this(set, ConcurrentCollectionFactory.createConcurrentIdentitySet());
    }

    private AccumulatingGroovyCompletionConsumer(CompletionResultSet set, Set<LookupElement> accumulator) {
        this.myResultSet = set;
        this.myAccumulator = accumulator;
    }

    @Override
    public void consume(@NotNull LookupElement element) {
        if (element == null) {
            AccumulatingGroovyCompletionConsumer.$$$reportNull$$$0(0);
        }
        this.myAccumulator.add(element);
    }

    @Override
    public void fastElementsProcessed(CompletionParameters parameters2) {
        HashSet<LookupElement> newSet = new HashSet<LookupElement>(this.myAccumulator);
        this.myAccumulator.clear();
        this.myResultSet.addAllElements(newSet);
    }

    @Override
    public void interrupt() {
        this.close();
        this.myResultSet.stopHere();
    }

    @Override
    public void close() {
        this.myResultSet.addAllElements(this.myAccumulator);
    }

    @Override
    @NotNull
    public GroovyCompletionConsumer transform(@NotNull Function<? super CompletionResultSet, ? extends CompletionResultSet> transformer) {
        if (transformer == null) {
            AccumulatingGroovyCompletionConsumer.$$$reportNull$$$0(1);
        }
        return new AccumulatingGroovyCompletionConsumer(transformer.apply((CompletionResultSet)this.getCompletionResultSet()), this.myAccumulator);
    }

    @Override
    @NotNull
    public CompletionResultSet getCompletionResultSet() {
        CompletionResultSet completionResultSet = this.myResultSet;
        if (completionResultSet == null) {
            AccumulatingGroovyCompletionConsumer.$$$reportNull$$$0(2);
        }
        return completionResultSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/completion/impl/AccumulatingGroovyCompletionConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/impl/AccumulatingGroovyCompletionConsumer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionResultSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "transform";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

