/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class StringPartInfo {
    private final GrLiteral myLiteral;
    private final TextRange myRange;
    private final List<GrStringInjection> myInjections;
    private final String myText;
    private final String myStartQuote;
    private final String myEndQuote;

    @Nullable
    public static StringPartInfo findStringPart(@NotNull PsiFile file, int startOffset, int endOffset) {
        if (file == null) {
            StringPartInfo.$$$reportNull$$$0(0);
        }
        PsiElement start = file.findElementAt(startOffset);
        PsiElement fin = file.findElementAt(endOffset - 1);
        if (start == null || fin == null) {
            return null;
        }
        PsiElement psi = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)fin);
        if (psi == null) {
            return null;
        }
        GrLiteral literal = StringPartInfo.findLiteral(psi);
        if (literal != null && StringPartInfo.checkSelectedRange(startOffset, endOffset, literal)) {
            return new StringPartInfo(literal, new TextRange(startOffset, endOffset));
        }
        return null;
    }

    public StringPartInfo(@NotNull GrLiteral literal, @NotNull TextRange range) {
        if (literal == null) {
            StringPartInfo.$$$reportNull$$$0(1);
        }
        if (range == null) {
            StringPartInfo.$$$reportNull$$$0(2);
        }
        this.myLiteral = literal;
        if (literal instanceof GrString) {
            Object[] injections = ((GrString)literal).getInjections();
            this.myInjections = ContainerUtil.filter((Object[])injections, injection -> range.contains(injection.getTextRange()));
        } else {
            this.myInjections = Collections.emptyList();
        }
        this.myText = this.myLiteral.getText();
        this.myStartQuote = GrStringUtil.getStartQuote(this.myText);
        this.myEndQuote = GrStringUtil.getEndQuote(this.myText);
        TextRange dataRange = new TextRange(this.myStartQuote.length(), this.myText.length() - this.myEndQuote.length());
        this.myRange = range.shiftRight(-literal.getTextRange().getStartOffset()).intersection(dataRange);
    }

    private static boolean checkSelectedRange(int startOffset, int endOffset, GrLiteral literal) {
        if (StringPartInfo.isWholeLiteralContentSelected(literal, startOffset, endOffset)) {
            return false;
        }
        if (literal instanceof GrString && StringPartInfo.areInjectionsCut((GrString)literal, startOffset, endOffset)) {
            return false;
        }
        return !StringPartInfo.isEscapesCut(literal, startOffset, endOffset);
    }

    private static boolean isEscapesCut(GrLiteral literal, int startOffset, int endOffset) {
        String rawContent = GrStringUtil.removeQuotes(literal.getText());
        int[] offsets = new int[rawContent.length() + 1];
        if (GrStringUtil.isSingleQuoteString(literal) || GrStringUtil.isDoubleQuoteString(literal)) {
            GrStringUtil.parseStringCharacters(rawContent, new StringBuilder(), offsets);
        } else if (GrStringUtil.isSlashyString(literal)) {
            GrStringUtil.parseRegexCharacters(rawContent, new StringBuilder(), offsets, true);
        } else if (GrStringUtil.isDollarSlashyString(literal)) {
            GrStringUtil.parseRegexCharacters(rawContent, new StringBuilder(), offsets, false);
        }
        int contentStart = literal.getTextRange().getStartOffset() + GrStringUtil.getStartQuote(literal.getText()).length();
        int relativeStart = startOffset - contentStart;
        int relativeEnd = endOffset - contentStart;
        return ArrayUtil.find((int[])offsets, (int)relativeStart) < 0 || ArrayUtil.find((int[])offsets, (int)relativeEnd) < 0;
    }

    public static boolean isWholeLiteralContentSelected(GrLiteral literal, int startOffset, int endOffset) {
        TextRange literalRange = literal.getTextRange();
        String literalText = literal.getText();
        String startQuote = GrStringUtil.getStartQuote(literalText);
        String endQuote = GrStringUtil.getEndQuote(literalText);
        return literalRange.getStartOffset() <= startOffset && startOffset <= literalRange.getStartOffset() + startQuote.length() && literalRange.getEndOffset() - endQuote.length() <= endOffset && endOffset <= literalRange.getEndOffset();
    }

    private static boolean areInjectionsCut(GrString literal, int startOffset, int endOffset) {
        GrStringInjection[] injections;
        TextRange selectionRange = new TextRange(startOffset, endOffset);
        for (GrStringInjection injection : injections = literal.getInjections()) {
            TextRange range = injection.getTextRange();
            if (selectionRange.contains(range) || range.contains(selectionRange) || !range.intersects(selectionRange)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static GrLiteral findLiteral(@NotNull PsiElement psi) {
        PsiElement parent2;
        if (psi == null) {
            StringPartInfo.$$$reportNull$$$0(3);
        }
        if (StringPartInfo.isStringLiteral(parent2 = psi.getParent())) {
            return (GrLiteral)parent2;
        }
        if (parent2 == null) {
            return null;
        }
        PsiElement gParent = parent2.getParent();
        if (StringPartInfo.isStringLiteral(gParent)) {
            return (GrLiteral)gParent;
        }
        if (psi instanceof GrString) {
            return (GrLiteral)psi;
        }
        return null;
    }

    @Contract(value="null -> false")
    private static boolean isStringLiteral(@Nullable PsiElement psi) {
        return psi instanceof GrLiteral && TokenSets.STRING_LITERAL_SET.contains(GrLiteralImpl.getLiteralType((GrLiteral)psi)) || psi instanceof GrString;
    }

    @NotNull
    public GrExpression replaceLiteralWithConcatenation(@Nullable String varName) {
        GrExpression replaced;
        block13: {
            boolean prefixExists;
            block12: {
                boolean suffixExists;
                block11: {
                    GrExpression grExpression;
                    String prefix = this.preparePrefix();
                    String suffix = this.prepareSuffix();
                    StringBuilder buffer = new StringBuilder();
                    boolean bl = prefixExists = !GrStringUtil.removeQuotes(prefix).isEmpty();
                    if (prefixExists) {
                        buffer.append(prefix).append('+');
                    }
                    buffer.append(varName != null ? varName : this.prepareSelected());
                    boolean bl2 = suffixExists = !GrStringUtil.removeQuotes(suffix).isEmpty();
                    if (suffixExists) {
                        buffer.append('+').append(suffix);
                    }
                    GrExpression concatenation = GroovyPsiElementFactory.getInstance(this.myLiteral.getProject()).createExpressionFromText(buffer);
                    replaced = this.getLiteral().replaceWithExpression(concatenation, false);
                    try {
                        if (!prefixExists || !suffixExists) break block11;
                        grExpression = Objects.requireNonNull(((GrBinaryExpression)((GrBinaryExpression)replaced).getLeftOperand()).getRightOperand());
                    }
                    catch (ClassCastException c) {
                        throw new IncorrectOperationException(buffer.toString());
                    }
                    if (grExpression == null) {
                        StringPartInfo.$$$reportNull$$$0(4);
                    }
                    return grExpression;
                }
                if (prefixExists || !suffixExists) break block12;
                GrExpression grExpression = ((GrBinaryExpression)replaced).getLeftOperand();
                if (grExpression == null) {
                    StringPartInfo.$$$reportNull$$$0(5);
                }
                return grExpression;
            }
            if (!prefixExists) break block13;
            GrExpression grExpression = Objects.requireNonNull(((GrBinaryExpression)replaced).getRightOperand());
            if (grExpression == null) {
                StringPartInfo.$$$reportNull$$$0(6);
            }
            return grExpression;
        }
        GrExpression grExpression = replaced;
        if (grExpression == null) {
            StringPartInfo.$$$reportNull$$$0(7);
        }
        return grExpression;
    }

    private String prepareSelected() {
        String content = this.myRange.substring(this.myLiteral.getText());
        return this.prepareLiteral(content);
    }

    private String prepareSuffix() {
        return this.myStartQuote + this.myText.substring(this.myRange.getEndOffset());
    }

    private String preparePrefix() {
        String prefix = this.myText.substring(0, this.myRange.getStartOffset());
        String content = GrStringUtil.removeQuotes(prefix);
        return this.prepareLiteral(content);
    }

    private String prepareLiteral(String content) {
        if (GrStringUtil.isSlashyString(this.myLiteral)) {
            if (content.endsWith("\\")) {
                String unescaped = GrStringUtil.unescapeSlashyString(content);
                return StringPartInfo.prepareGString(unescaped);
            }
        } else if (GrStringUtil.isDollarSlashyString(this.myLiteral) && content.endsWith("$")) {
            String unescaped = GrStringUtil.unescapeDollarSlashyString(content);
            return StringPartInfo.prepareGString(unescaped);
        }
        return this.myStartQuote + content + this.myEndQuote;
    }

    @NotNull
    private static String prepareGString(@NotNull String content) {
        if (content == null) {
            StringPartInfo.$$$reportNull$$$0(8);
        }
        StringBuilder buffer = new StringBuilder();
        boolean multiline = content.contains("\n");
        buffer.append(multiline ? "\"\"\"" : "\"");
        GrStringUtil.escapeSymbolsForGString(content, multiline, false, buffer);
        buffer.append(multiline ? "\"\"\"" : "\"");
        String string = buffer.toString();
        if (string == null) {
            StringPartInfo.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public GrLiteral getLiteral() {
        GrLiteral grLiteral = this.myLiteral;
        if (grLiteral == null) {
            StringPartInfo.$$$reportNull$$$0(10);
        }
        return grLiteral;
    }

    @NotNull
    public TextRange getRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            StringPartInfo.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    @NotNull
    public List<GrStringInjection> getInjections() {
        List<GrStringInjection> list = this.myInjections;
        if (list == null) {
            StringPartInfo.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public GrLiteral createLiteralFromSelected() {
        GrLiteral grLiteral = (GrLiteral)GroovyPsiElementFactory.getInstance(this.myLiteral.getProject()).createExpressionFromText(this.prepareSelected());
        if (grLiteral == null) {
            StringPartInfo.$$$reportNull$$$0(13);
        }
        return grLiteral;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/StringPartInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceLiteralWithConcatenation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareGString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjections";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralFromSelected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findStringPart";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findLiteral";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareGString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

