/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.io.File;
import java.util.Objects;
import org.eclipse.aether.repository.ArtifactRepository;

public final class LocalRepository
implements ArtifactRepository {
    private final File basedir;
    private final String type;

    public LocalRepository(String basedir) {
        this(basedir != null ? new File(basedir) : null, "");
    }

    public LocalRepository(File basedir) {
        this(basedir, "");
    }

    public LocalRepository(File basedir, String type2) {
        this.basedir = basedir;
        this.type = type2 != null ? type2 : "";
    }

    @Override
    public String getContentType() {
        return this.type;
    }

    @Override
    public String getId() {
        return "local";
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String toString() {
        return this.getBasedir() + " (" + this.getContentType() + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        LocalRepository that = (LocalRepository)obj;
        return Objects.equals(this.basedir, that.basedir) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + LocalRepository.hash(this.basedir);
        hash = hash * 31 + LocalRepository.hash(this.type);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

