/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.components;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSettingListener;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.VersionsExKt;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.BackendDaemonStateEnum;
import com.jetbrains.rd.ide.model.HighlightingSettingsModel;
import com.jetbrains.rd.ide.model.RdDaemonModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdMarkupKey;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.ide.model.RdMarkupModelBase;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.daemon.ModelUtilKt;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rd.platform.util.ListenersKt;
import com.jetbrains.rd.util.Boxed;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.daemon.DaemonKind;
import com.jetbrains.rdclient.daemon.FrontendDaemon;
import com.jetbrains.rdclient.daemon.FrontendDaemonModel;
import com.jetbrains.rdclient.daemon.FrontendMarkupSuppressor;
import com.jetbrains.rdclient.daemon.MarkupSuppressionKind;
import com.jetbrains.rdclient.daemon.components.FrontendDaemonHost;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.daemon.components.statistics.DaemonRedCodeLogUsageCollector;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.document.FrontendDocumentHostListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdclient/daemon/components/FrontendDaemonHost;", "Lcom/jetbrains/rdclient/daemon/FrontendDaemon;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "dropAllBackendHighlighters", "", "getHighlightingSetting", "Lcom/intellij/codeInsight/daemon/impl/analysis/FileHighlightingSetting;", "psiFile", "Lcom/intellij/psi/PsiFile;", "reportDaemonState", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "document", "Lcom/intellij/openapi/editor/Document;", "markup", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "restart", "daemon", "Lcom/jetbrains/rdclient/daemon/DaemonKind;", "setHighlightingSetting", "setting", "Companion", "MyListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendDaemonHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDaemonHost.kt\ncom/jetbrains/rdclient/daemon/components/FrontendDaemonHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,201:1\n13#2:202\n*S KotlinDebug\n*F\n+ 1 FrontendDaemonHost.kt\ncom/jetbrains/rdclient/daemon/components/FrontendDaemonHost\n*L\n49#1:202\n*E\n"})
public final class FrontendDaemonHost
implements FrontendDaemon {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<Map<Document, FrontendDaemonModel>> KEY;

    public FrontendDaemonHost(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    private final Project getProject() {
        return this.session.getProject();
    }

    private final void reportDaemonState(Lifetime lifetime, Document document, RdMarkupModel markup) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        if (EditorHistoryManager.Companion.getInstance(this.getProject()).hasBeenOpen(file)) {
            return;
        }
        RdDocumentId rdDocumentId = DocumentExKt.getDocumentId(document, this.getProject());
        if (rdDocumentId == null) {
            return;
        }
        RdDocumentId documentId = rdDocumentId;
        DocumentSynchronizer documentSynchronizer2 = FrontendDocumentHost.Companion.getInstance(this.session.getAppSession()).getSynchronizer(documentId);
        if (documentSynchronizer2 == null) {
            return;
        }
        DocumentSynchronizer documentSynchronizer3 = documentSynchronizer2;
        if (VersionsExKt.moreThan((AbstractDocumentVersion)documentSynchronizer3.getVersion(), (int)1)) {
            return;
        }
        SourceExKt.adviseUntil((ISource)((ISource)markup.getDaemon().getState()), (Lifetime)lifetime, (Function1)((Function1)new Function1<BackendDaemonStateEnum, Boolean>(documentSynchronizer3, this, document){
            final /* synthetic */ DocumentSynchronizer $documentSynchronizer;
            final /* synthetic */ FrontendDaemonHost this$0;
            final /* synthetic */ Document $document;
            {
                this.$documentSynchronizer = $documentSynchronizer;
                this.this$0 = $receiver;
                this.$document = $document;
                super(1);
            }

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final Boolean invoke(@NotNull BackendDaemonStateEnum it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                switch (reportDaemonState.WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        v0 = true;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        v0 = false;
                        break;
                    }
                    case 8: {
                        if (VersionsExKt.moreThan((AbstractDocumentVersion)this.$documentSynchronizer.getVersion(), (int)1)) {
                            return true;
                        }
                        v1 = FrontendMarkupHost.Companion.getMarkupContributor(FrontendDaemonHost.access$getProject(this.this$0), this.$document);
                        if (v1 == null) {
                            return true;
                        }
                        markupContributor = v1;
                        markupAdapter = markupContributor.getMarkupAdapter();
                        $this$any$iv = markupAdapter.getAllHighlighters();
                        $i$f$any = false;
                        var8_7 = $this$any$iv.length;
                        for (var7_6 = 0; var7_6 < var8_7; ++var7_6) {
                            highlighter = element$iv = $this$any$iv[var7_6];
                            $i$a$-any-FrontendDaemonHost$reportDaemonState$1$hasErrors$1 = false;
                            v2 = HighlightInfo.fromRangeHighlighter((RangeHighlighter)((RangeHighlighter)highlighter));
                            if (!Intrinsics.areEqual((Object)(v2 != null ? v2.getSeverity() : null), (Object)HighlightSeverity.ERROR)) continue;
                            v3 = true;
                            ** GOTO lbl28
                        }
                        v3 = hasErrors = false;
lbl28:
                        // 2 sources

                        if (hasErrors) {
                            DaemonRedCodeLogUsageCollector.INSTANCE.log(FrontendDaemonHost.access$getProject(this.this$0));
                        }
                        v0 = true;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return v0;
            }
        }));
    }

    @Override
    public void setHighlightingSetting(@NotNull PsiFile psiFile, @NotNull FileHighlightingSetting setting) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        HighlightingSettingsPerFile settings = HighlightingSettingsPerFile.getInstance((Project)this.getProject());
        if (settings.getHighlightingSettingForRoot((PsiElement)psiFile) == setting) {
            return;
        }
        settings.setHighlightingSettingForRoot((PsiElement)psiFile, setting);
        InjectedLanguageManager.getInstance((Project)this.getProject()).dropFileCaches(psiFile);
        this.restart(DaemonKind.Frontend);
    }

    @Override
    @NotNull
    public FileHighlightingSetting getHighlightingSetting(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        FileHighlightingSetting fileHighlightingSetting = HighlightingSettingsPerFile.getInstance((Project)this.getProject()).getHighlightingSettingForRoot((PsiElement)psiFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileHighlightingSetting, (String)"getHighlightingSettingForRoot(...)");
        return fileHighlightingSetting;
    }

    @Override
    public void restart(@NotNull DaemonKind daemon) {
        Intrinsics.checkNotNullParameter((Object)((Object)daemon), (String)"daemon");
        if (daemon.isFrontendInvolved()) {
            DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
        }
        if (daemon.isBackendInvolved()) {
            InterfacesKt.fire((ISignal)FrontendSessionsUtilKt.getProtocolModel(FrontendSessionsUtilKt.getFrontendProjectSession(this.getProject())).getDaemon().getInvalidateAll());
        }
    }

    public final void dropAllBackendHighlighters() {
        InterfacesKt.fire((ISignal)FrontendSessionsUtilKt.getProtocolModel(FrontendSessionsUtilKt.getFrontendProjectSession(this.getProject())).getDaemon().getDropAllHighlighters());
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$reportDaemonState(FrontendDaemonHost $this, Lifetime lifetime, Document document, RdMarkupModel markup) {
        $this.reportDaemonState(lifetime, document, markup);
    }

    public static final /* synthetic */ Project access$getProject(FrontendDaemonHost $this) {
        return $this.getProject();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendDaemonHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendDaemonHost.logger = logger;
        KEY = new Key("FRONTEND_DAEMON_KEY");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0007H\u0002R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rdclient/daemon/components/FrontendDaemonHost$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/openapi/editor/Document;", "Lcom/jetbrains/rdclient/daemon/FrontendDaemonModel;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "createMarkupSuppressor", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupSuppressor;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "daemonModel", "Lcom/jetbrains/rd/ide/model/RdDaemonModel;", "getFrontendDaemonModel", "project", "Lcom/intellij/openapi/project/Project;", "document", "getInstance", "Lcom/jetbrains/rdclient/daemon/components/FrontendDaemonHost;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "putFrontendDaemonModel", "", "contributor", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendDaemonHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendDaemonHost.kt\ncom/jetbrains/rdclient/daemon/components/FrontendDaemonHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n*L\n1#1,201:1\n31#2,2:202\n7#3,6:204\n*S KotlinDebug\n*F\n+ 1 FrontendDaemonHost.kt\ncom/jetbrains/rdclient/daemon/components/FrontendDaemonHost$Companion\n*L\n52#1:202,2\n61#1:204,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendDaemonHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project));
        }

        @NotNull
        public final FrontendDaemonHost getInstance(@NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session;
            boolean $i$f$service = false;
            Class<FrontendDaemonHost> serviceClass$iv = FrontendDaemonHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendDaemonHost)object;
        }

        @Nullable
        public final FrontendDaemonModel getFrontendDaemonModel(@NotNull Project project, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Map map = (Map)project.getUserData(KEY);
            return map != null ? (FrontendDaemonModel)map.get(document) : null;
        }

        /*
         * WARNING - void declaration
         */
        private final void putFrontendDaemonModel(Lifetime lifetime, Project project, Document document, FrontendDaemonModel contributor) {
            void $this$getOrCreateUserData$iv;
            UserDataHolder userDataHolder = (UserDataHolder)project;
            Key key$iv = KEY;
            boolean $i$f$getOrCreateUserData = false;
            Object existing$iv = $this$getOrCreateUserData$iv.getUserData(key$iv);
            Object object = existing$iv;
            if (object == null) {
                boolean bl = false;
                Map value$iv = new LinkedHashMap();
                $this$getOrCreateUserData$iv.putUserData(key$iv, (Object)value$iv);
                object = value$iv;
            }
            Map map = (Map)object;
            CollectionExKt.addUnique((Map)map, (Lifetime)lifetime, (Object)document, (Object)contributor);
        }

        @NotNull
        public final FrontendMarkupSuppressor createMarkupSuppressor(@NotNull Lifetime lifetime, @NotNull RdDaemonModel daemonModel) {
            FrontendMarkupSuppressor frontendMarkupSuppressor;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)daemonModel, (String)"daemonModel");
            IOptPropertyView isLocalStageRunning2 = PropertyCombinatorsKt.map((IOptPropertyView)((IOptPropertyView)daemonModel.getHighlightingProgressState()), (Function1)createMarkupSuppressor.isLocalStageRunning.1.INSTANCE);
            IOptPropertyView isDaemonStateInvalidated2 = PropertyCombinatorsKt.map((IOptPropertyView)((IOptPropertyView)daemonModel.getState()), (Function1)createMarkupSuppressor.isDaemonStateInvalidated.1.INSTANCE);
            IOptPropertyView localAnalysisViewable = BoolPropertyExKt.or((IOptPropertyView)isLocalStageRunning2, (IOptPropertyView)isDaemonStateInvalidated2);
            FrontendMarkupSuppressor $this$createMarkupSuppressor_u24lambda_u241 = frontendMarkupSuppressor = new FrontendMarkupSuppressor(lifetime);
            boolean bl = false;
            $this$createMarkupSuppressor_u24lambda_u241.addSuppressionRule(lifetime, MarkupSuppressionKind.DELETION, (IViewable<Boolean>)((IViewable)localAnalysisViewable));
            return frontendMarkupSuppressor;
        }

        public static final /* synthetic */ void access$putFrontendDaemonModel(Companion $this, Lifetime lifetime, Project project, Document document, FrontendDaemonModel contributor) {
            $this.putFrontendDaemonModel(lifetime, project, document, contributor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/daemon/components/FrontendDaemonHost$MyListener;", "Lcom/jetbrains/rdclient/document/FrontendDocumentHostListener;", "()V", "documentBound", "", "documentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.rd.client"})
    public static final class MyListener
    implements FrontendDocumentHostListener {
        @Override
        public void documentBound(@NotNull Lifetime documentLifetime, @NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            com.jetbrains.rd.ide.document.DocumentExKt.getMarkups((RdDocumentModel)documentModel).view(documentLifetime, (Function3)new Function3<Lifetime, RdMarkupKey, RdMarkupModelBase, Unit>(document, documentId){
                final /* synthetic */ Document $document;
                final /* synthetic */ RdDocumentId $documentId;
                {
                    this.$document = $document;
                    this.$documentId = $documentId;
                    super(3);
                }

                public final void invoke(@NotNull Lifetime markupLifetime, @NotNull RdMarkupKey key, @NotNull RdMarkupModelBase markup) {
                    Intrinsics.checkNotNullParameter((Object)markupLifetime, (String)"markupLifetime");
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)markup, (String)"markup");
                    if (!(markup instanceof RdMarkupModel)) {
                        return;
                    }
                    long daemonStartTime = System.nanoTime();
                    RdDaemonModel daemon = ((RdMarkupModel)markup).getDaemon();
                    daemon.getState().advise(markupLifetime, (Function1)new Function1<BackendDaemonStateEnum, Unit>(this.$documentId){
                        final /* synthetic */ RdDocumentId $documentId;
                        {
                            this.$documentId = $documentId;
                            super(1);
                        }

                        public final void invoke(@NotNull BackendDaemonStateEnum it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            FrontendDaemonHost.access$getLogger$cp().debug("Daemon state for " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString((RdDocumentId)this.$documentId) + " -> " + it);
                        }
                    });
                    RdProjectId rdProjectId = key.getProjectId();
                    if (rdProjectId == null || (rdProjectId = ProjectUtilKt.toProject((RdProjectId)rdProjectId)) == null) {
                        return;
                    }
                    RdProjectId project = rdProjectId;
                    Ref.ObjectRef psiFile = new Ref.ObjectRef();
                    PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.$document);
                    if (psiFile2 == null) {
                        return;
                    }
                    psiFile.element = psiFile2;
                    IOptProperty settingsModel2 = daemon.getSettings();
                    Boxed guard = new Boxed((Object)false);
                    settingsModel2.advise(markupLifetime, (Function1)new Function1<HighlightingSettingsModel, Unit>((Ref.ObjectRef<PsiFile>)psiFile, (Boxed<Boolean>)guard, this.$documentId, (Project)project){
                        final /* synthetic */ Ref.ObjectRef<PsiFile> $psiFile;
                        final /* synthetic */ Boxed<Boolean> $guard;
                        final /* synthetic */ RdDocumentId $documentId;
                        final /* synthetic */ Project $project;
                        {
                            this.$psiFile = $psiFile;
                            this.$guard = $guard;
                            this.$documentId = $documentId;
                            this.$project = $project;
                            super(1);
                        }

                        public final void invoke(@NotNull HighlightingSettingsModel it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (ModelUtilKt.fromModel((HighlightingSettingsModel)it) == FileHighlightingSetting.FORCE_HIGHLIGHTING && SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)((PsiFile)this.$psiFile.element).getVirtualFile())) {
                                SingleRootFileViewProvider.doNotCheckFileSizeLimit((VirtualFile)((PsiFile)this.$psiFile.element).getVirtualFile());
                                VirtualFile[] virtualFileArray = new VirtualFile[]{((PsiFile)this.$psiFile.element).getVirtualFile()};
                                FileDocumentManager.getInstance().reloadFiles(virtualFileArray);
                            }
                            if (((Boolean)this.$guard.getValue()).booleanValue()) {
                                return;
                            }
                            FrontendDaemonHost.access$getLogger$cp().debug("Daemon settings changed from protocol. " + this.$documentId + " -> " + it);
                            FrontendDaemonHost.Companion.getInstance(this.$project).setHighlightingSetting((PsiFile)this.$psiFile.element, ModelUtilKt.fromModel((HighlightingSettingsModel)it));
                        }
                    });
                    OptProperty frontendDaemonState = new OptProperty();
                    markupLifetime.onTermination((Function0)new Function0<Unit>((OptProperty<BackendDaemonStateEnum>)frontendDaemonState){
                        final /* synthetic */ OptProperty<BackendDaemonStateEnum> $frontendDaemonState;
                        {
                            this.$frontendDaemonState = $frontendDaemonState;
                            super(0);
                        }

                        public final void invoke() {
                            this.$frontendDaemonState.set((Object)BackendDaemonStateEnum.UNSUPPORTED);
                        }
                    });
                    MessageBus messageBus = project.getMessageBus();
                    Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
                    Topic topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
                    Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DAEMON_EVENT_TOPIC");
                    ListenersKt.subscribe((MessageBus)messageBus, (Lifetime)markupLifetime, (Topic)topic, (Object)new DaemonCodeAnalyzer.DaemonListener((OptProperty<BackendDaemonStateEnum>)frontendDaemonState, this.$document, daemonStartTime){
                        final /* synthetic */ OptProperty<BackendDaemonStateEnum> $frontendDaemonState;
                        final /* synthetic */ Document $document;
                        final /* synthetic */ long $daemonStartTime;
                        {
                            this.$frontendDaemonState = $frontendDaemonState;
                            this.$document = $document;
                            this.$daemonStartTime = $daemonStartTime;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void daemonStarting(@NotNull Collection<? extends FileEditor> fileEditors) {
                            boolean bl;
                            block4: {
                                void $this$any$iv;
                                Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
                                Iterable iterable = fileEditors;
                                Document document = this.$document;
                                boolean $i$f$any = false;
                                if (((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        FileEditor it = (FileEditor)element$iv;
                                        boolean bl2 = false;
                                        TextEditor textEditor = it instanceof TextEditor ? (TextEditor)it : null;
                                        if (!Intrinsics.areEqual((Object)(textEditor != null && (textEditor = textEditor.getEditor()) != null ? textEditor.getDocument() : null), (Object)document)) continue;
                                        bl = true;
                                        break block4;
                                    }
                                    bl = false;
                                }
                            }
                            if (bl) {
                                this.$frontendDaemonState.set((Object)BackendDaemonStateEnum.IN_PROGRESS_LOCAL);
                            }
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public void daemonFinished(@NotNull Collection<? extends FileEditor> fileEditors) {
                            boolean bl;
                            block4: {
                                void $this$any$iv;
                                Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
                                Iterable iterable = fileEditors;
                                Document document = this.$document;
                                boolean $i$f$any = false;
                                if (((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        FileEditor it = (FileEditor)element$iv;
                                        boolean bl2 = false;
                                        TextEditor textEditor = it instanceof TextEditor ? (TextEditor)it : null;
                                        if (!Intrinsics.areEqual((Object)(textEditor != null && (textEditor = textEditor.getEditor()) != null ? textEditor.getDocument() : null), (Object)document)) continue;
                                        bl = true;
                                        break block4;
                                    }
                                    bl = false;
                                }
                            }
                            if (bl) {
                                this.$frontendDaemonState.set((Object)BackendDaemonStateEnum.UP_TO_DATE);
                            }
                            StructuredLoggingKt.logMeasuredTime$default((Logger)FrontendDaemonHost.access$getLogger$cp(), (String)"FrontendDaemonHost", (long)((long)((double)(System.nanoTime() - this.$daemonStartTime) / 1000000.0)), null, (int)4, null);
                        }
                    });
                    com.jetbrains.rdclient.daemon.components.FrontendDaemonHost$Companion.access$putFrontendDaemonModel(FrontendDaemonHost.Companion, markupLifetime, (Project)project, this.$document, new FrontendDaemonModel((IOptPropertyView<? extends BackendDaemonStateEnum>)((IOptPropertyView)frontendDaemonState)));
                    MessageBus messageBus2 = project.getMessageBus();
                    Intrinsics.checkNotNullExpressionValue((Object)messageBus2, (String)"getMessageBus(...)");
                    Topic topic2 = FileHighlightingSettingListener.SETTING_CHANGE;
                    Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"SETTING_CHANGE");
                    ListenersKt.subscribe((MessageBus)messageBus2, (Lifetime)markupLifetime, (Topic)topic2, (arg_0, arg_1) -> documentBound.1.invoke$lambda$1(psiFile, (Project)project, this.$document, guard, settingsModel2, this.$documentId, daemon, arg_0, arg_1));
                    FrontendDaemonHost.access$reportDaemonState(FrontendDaemonHost.Companion.getInstance((Project)project), markupLifetime, this.$document, (RdMarkupModel)markup);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                private static final void invoke$lambda$1(Ref.ObjectRef $psiFile, Project $project, Document $document, Boxed $guard, IOptProperty $settingsModel, RdDocumentId $documentId, RdDaemonModel $daemon, PsiElement root, FileHighlightingSetting change) {
                    Intrinsics.checkNotNullParameter((Object)$psiFile, (String)"$psiFile");
                    Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                    Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
                    Intrinsics.checkNotNullParameter((Object)$guard, (String)"$guard");
                    Intrinsics.checkNotNullParameter((Object)$settingsModel, (String)"$settingsModel");
                    Intrinsics.checkNotNullParameter((Object)$documentId, (String)"$documentId");
                    Intrinsics.checkNotNullParameter((Object)$daemon, (String)"$daemon");
                    Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                    Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                    if (!((PsiFile)$psiFile.element).isValid()) {
                        PsiFile psiFile = PsiDocumentManager.getInstance((Project)$project).getPsiFile($document);
                        if (psiFile == null) {
                            return;
                        }
                        $psiFile.element = psiFile;
                    }
                    if (Intrinsics.areEqual((Object)root.getContainingFile(), (Object)$psiFile.element)) {
                        void $this$usingTrueFlag_u24default$iv;
                        Boxed boxed = $guard;
                        KMutableProperty1 flag$iv = (KMutableProperty1)documentBound.5.1.INSTANCE;
                        boolean set$iv = true;
                        boolean $i$f$usingTrueFlag = false;
                        if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        try {
                            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
                            boolean bl = false;
                            HighlightingSettingsModel oldValue = (HighlightingSettingsModel)$settingsModel.getValueOrNull();
                            HighlightingSettingsModel newValue = ModelUtilKt.toModel((FileHighlightingSetting)change);
                            HighlightingSettingsModel highlightingSettingsModel = oldValue;
                            if ((highlightingSettingsModel != null ? highlightingSettingsModel.getState() : null) != newValue.getState()) {
                                FrontendDaemonHost.access$getLogger$cp().debug("Daemon settings changed from frontend. " + $documentId + " -> " + newValue);
                                $settingsModel.set((Object)newValue);
                                $daemon.getStateChanged().fire((Object)newValue.getState());
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
                        }
                    }
                }
            });
        }
    }
}

