/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.hyperlinks;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.BrowseMode;
import com.jetbrains.rd.ide.model.HyperlinkHighlightingArgs;
import com.jetbrains.rd.ide.model.HyperlinkHighlightingDumpModeResult;
import com.jetbrains.rd.ide.model.HyperlinkHighlightingModel_GeneratedKt;
import com.jetbrains.rd.ide.model.HyperlinkHighlightingResult;
import com.jetbrains.rd.ide.model.HyperlinkHighlightingResultBase;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.platform.util.idea.LifetimedProjectService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdclient.actions.ActionCallPolicy;
import com.jetbrains.rdclient.actions.ActionCallStrategy;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.hyperlinks.FrontendCtrlClickHost;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000}\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t*\u0001\u000b\b\u0016\u0018\u0000 22\u00020\u0001:\u00041234B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0014H\u0002J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020$H\u0002J\u0018\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0007H\u0002J\u000e\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u0014H\u0014J\u0018\u0010/\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0014H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0014H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedProjectService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "browsingSession", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost$BrowsingData;", "currentBrowseMode", "Lcom/jetbrains/rd/ide/model/BrowseMode;", "editorKeyListener", "com/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost$editorKeyListener$1", "Lcom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost$editorKeyListener$1;", "hyperlinkAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getHyperlinkAttributes", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "lastCursor", "Ljava/awt/Cursor;", "requestedOffset", "", "Ljava/lang/Integer;", "sequentialLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "visibleAreaListener", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "addHyperlink", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/util/TextRange;", "atCurrentRequestedOffset", "", "offset", "dropBrowsingSession", "", "dropHyperlinkRequest", "enterBrowseMode", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "data", "handleMouseMode", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "modifiersToBrowseMode", "modifiers", "requestHyperlink", "updateBrowsingMode", "BrowsingData", "Companion", "MyEditorMouseListener", "MyEditorMouseMotionListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendCtrlClickHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCtrlClickHost.kt\ncom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,218:1\n65#2,4:219\n13#2:223\n*S KotlinDebug\n*F\n+ 1 FrontendCtrlClickHost.kt\ncom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost\n*L\n121#1:219,4\n43#1:223\n*E\n"})
public class FrontendCtrlClickHost
extends LifetimedProjectService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SequentialLifetimes sequentialLifetimes;
    @NotNull
    private final Property<BrowsingData> browsingSession;
    @NotNull
    private final Property<BrowseMode> currentBrowseMode;
    @Nullable
    private Integer requestedOffset;
    @Nullable
    private Cursor lastCursor;
    @NotNull
    private final VisibleAreaListener visibleAreaListener;
    @NotNull
    private final editorKeyListener.1 editorKeyListener;
    @NotNull
    private static final Logger LOG;
    private static final Cursor hand;
    @NotNull
    private static final BrowsingData EMPTY_DATA;
    @NotNull
    public static final String backendActionId = "CtrlClick";

    public FrontendCtrlClickHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.sequentialLifetimes = new SequentialLifetimes(this.getProjectServiceLifetime());
        this.browsingSession = new Property((Object)EMPTY_DATA);
        this.currentBrowseMode = new Property((Object)BrowseMode.None);
        this.visibleAreaListener = arg_0 -> FrontendCtrlClickHost.visibleAreaListener$lambda$0(this, arg_0);
        this.editorKeyListener = new KeyAdapter(this){
            final /* synthetic */ FrontendCtrlClickHost this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FrontendCtrlClickHost.access$updateBrowsingMode(this.this$0, e.getModifiers());
            }

            public void keyReleased(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FrontendCtrlClickHost.access$updateBrowsingMode(this.this$0, e.getModifiers());
            }
        };
        ThreadingAssertions.assertEventDispatchThread();
        this.browsingSession.view(this.getProjectServiceLifetime(), (Function2)new Function2<Lifetime, BrowsingData, Unit>(){

            public final void invoke(@NotNull Lifetime lf, @NotNull BrowsingData data) {
                Intrinsics.checkNotNullParameter((Object)lf, (String)"lf");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.enterBrowseMode(lf, data);
            }
        });
        this.currentBrowseMode.advise(this.getProjectServiceLifetime(), (Function1)new Function1<BrowseMode, Unit>(){

            public final void invoke(@NotNull BrowseMode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.dropHyperlinkRequest();
                this.dropBrowsingSession();
            }
        });
    }

    public final void handleMouseMode(@NotNull EditorMouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.isConsumed() || !this.getProject().isInitialized() || this.getProject().isDisposed()) {
            return;
        }
        MouseEvent mouseEvent = e.getMouseEvent();
        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
        MouseEvent mouseEvent2 = mouseEvent;
        Editor editor2 = e.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        this.updateBrowsingMode(mouseEvent2.getModifiers());
        if (this.currentBrowseMode.getValue() == BrowseMode.None || e.getArea() != EditorMouseEventArea.EDITING_AREA) {
            return;
        }
        LogicalPosition logicalPosition = editor3.xyToLogicalPosition(mouseEvent2.getPoint());
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
        LogicalPosition pos = logicalPosition;
        if (EditorUtil.inVirtualSpace((Editor)editor3, (LogicalPosition)pos) || e.getInlay() != null) {
            this.dropBrowsingSession();
            return;
        }
        int offset = editor3.logicalPositionToOffset(pos);
        ActionCallStrategy strategy2 = ActionCallPolicy.Companion.getInstance().getCallStrategy(editor3, offset, backendActionId);
        if (strategy2.isFrontendOnly()) {
            return;
        }
        if (this.atCurrentRequestedOffset(offset)) {
            return;
        }
        this.requestHyperlink(editor3, offset);
    }

    private final void requestHyperlink(Editor editor2, int offset) {
        ThreadingAssertions.assertEventDispatchThread();
        TextControlId textControlId = DocumentExKt.getTextControlId(editor2);
        Intrinsics.checkNotNull((Object)textControlId);
        TextControlId id = textControlId;
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("send hyperlink request for " + offset);
        }
        HyperlinkHighlightingArgs args = new HyperlinkHighlightingArgs(id, offset, (BrowseMode)this.currentBrowseMode.getValue());
        LifetimeDefinition lifetime = this.sequentialLifetimes.next();
        IdeBackend backend = IdeBackend.Companion.getInstance(this.getProject());
        this.requestedOffset = offset;
        RdCoroutinesUtilKt.launchOnUiAllowInlining$default((Lifetime)((Lifetime)lifetime), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(lifetime, this, editor2, offset, backend, args, null){
            Object L$0;
            int label;
            final /* synthetic */ LifetimeDefinition $lifetime;
            final /* synthetic */ FrontendCtrlClickHost this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ int $offset;
            final /* synthetic */ IdeBackend $backend;
            final /* synthetic */ HyperlinkHighlightingArgs $args;
            {
                this.$lifetime = $lifetime;
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$offset = $offset;
                this.$backend = $backend;
                this.$args = $args;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_3 = FrontendCtrlClickHost.access$getLOG$cp();
                        var4_6 /* !! */  = this.$backend;
                        var5_7 = this.$lifetime;
                        var6_8 = this.$args;
                        $i$f$runAndLogException = false;
                        var8_11 = $this$runAndLogException$iv;
                        $i$a$-runCatching-LoggerKt$runAndLogException$1$iv = false;
                        $i$a$-runAndLogException-FrontendCtrlClickHost$requestHyperlink$2$value$1 = false;
                        this.L$0 = $this$runAndLogException$iv;
                        this.label = 1;
                        v0 = IRdCall.DefaultImpls.startSuspending$default((IRdCall)((IRdCall)HyperlinkHighlightingModel_GeneratedKt.getHyperlinkHighlightingModel((Solution)var4_6 /* !! */ .getSolution()).getGetElementRange()), (Lifetime)((Lifetime)var5_7), (Object)var6_8, null, (Continuation)this, (int)4, null);
                        ** if (v0 != var12_2) goto lbl21
lbl20:
                        // 1 sources

                        return var12_2;
lbl21:
                        // 1 sources

                        ** GOTO lbl31
                    }
                    case 1: {
                        $i$f$runAndLogException = false;
                        $i$a$-runCatching-LoggerKt$runAndLogException$1$iv = false;
                        $i$a$-runAndLogException-FrontendCtrlClickHost$requestHyperlink$2$value$1 = false;
                        $this$runAndLogException$iv = (Logger)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl31:
                            // 2 sources

                            var9_17 = Result.constructor-impl((Object)((HyperlinkHighlightingResultBase)v0));
                        }
                        catch (Throwable var10_14) {
                            var9_17 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var10_14));
                        }
                        value = (HyperlinkHighlightingResultBase)LoggerKt.getOrLogException((Object)var9_17, (Logger)$this$runAndLogException$iv);
                        var3_4 = RLifetimeKt.isAlive((Lifetime)((Lifetime)this.$lifetime));
                        if (_Assertions.ENABLED && !var3_4) {
                            var4_6 /* !! */  = "Assertion failed";
                            throw new AssertionError((Object)var4_6 /* !! */ );
                        }
                        FrontendCtrlClickHost.access$setRequestedOffset$p(this.this$0, null);
                        var3_5 = value;
                        if (var3_5 instanceof HyperlinkHighlightingResult) {
                            range = RangeUtilKt.toIdeaRange(((HyperlinkHighlightingResult)value).getTextRange());
                            if (range.isEmpty()) {
                                return Unit.INSTANCE;
                            }
                            FrontendCtrlClickHost.access$getLOG$cp().debug("got hyperlink for range " + range);
                            FrontendCtrlClickHost.access$getBrowsingSession$p(this.this$0).setValue((Object)new BrowsingData(this.$editor, this.$offset, range));
                        } else if (var3_5 instanceof HyperlinkHighlightingDumpModeResult) {
                            this.this$0.dropBrowsingSession();
                            DumbService.Companion.getInstance(this.this$0.getProject()).showDumbModeNotificationForFunctionality(((HyperlinkHighlightingDumpModeResult)value).getMessage(), DumbModeBlockedFunctionality.RDClientHyperlink);
                        } else if (var3_5 == null) {
                            this.this$0.dropBrowsingSession();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void enterBrowseMode(Lifetime lifetime, BrowsingData data) {
        Editor editor2 = data.component1();
        TextRange range2 = data.component3();
        if (editor2 == null) {
            return;
        }
        if (range2.isEmpty()) {
            return;
        }
        RangeHighlighter hyperlink = this.addHyperlink(editor2, range2);
        JComponent jComponent = editor2.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent contentComponent = jComponent;
        Cursor cursor = contentComponent.getCursor();
        if (this.lastCursor == null || cursor.getType() != hand.getType()) {
            this.lastCursor = cursor;
        }
        editor2.getContentComponent().setCursor(hand);
        contentComponent.addKeyListener(this.editorKeyListener);
        editor2.getScrollingModel().addVisibleAreaListener(this.visibleAreaListener);
        RLifetimeKt.plusAssign((Lifetime)lifetime, (Function0)((Function0)new Function0<Unit>(editor2, this, contentComponent, cursor, hyperlink){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ FrontendCtrlClickHost this$0;
            final /* synthetic */ JComponent $contentComponent;
            final /* synthetic */ Cursor $cursor;
            final /* synthetic */ RangeHighlighter $hyperlink;
            {
                this.$editor = $editor;
                this.this$0 = $receiver;
                this.$contentComponent = $contentComponent;
                this.$cursor = $cursor;
                this.$hyperlink = $hyperlink;
                super(0);
            }

            public final void invoke() {
                this.$editor.getScrollingModel().removeVisibleAreaListener(FrontendCtrlClickHost.access$getVisibleAreaListener$p(this.this$0));
                this.$contentComponent.removeKeyListener(FrontendCtrlClickHost.access$getEditorKeyListener$p(this.this$0));
                Cursor cursor = FrontendCtrlClickHost.access$getLastCursor$p(this.this$0);
                if (cursor == null) {
                    cursor = this.$cursor;
                }
                this.$contentComponent.setCursor(cursor);
                this.$editor.getMarkupModel().removeHighlighter(this.$hyperlink);
                HintManager.getInstance().hideAllHints();
            }
        }));
    }

    private final TextAttributes getHyperlinkAttributes() {
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"getAttributes(...)");
        return textAttributes;
    }

    private final RangeHighlighter addHyperlink(Editor editor2, TextRange range2) {
        RangeHighlighter rangeHighlighter = editor2.getMarkupModel().addRangeHighlighter(range2.getStartOffset(), range2.getEndOffset(), 6001, this.getHyperlinkAttributes(), HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        return rangeHighlighter;
    }

    private final boolean atCurrentRequestedOffset(int offset) {
        Integer n = this.requestedOffset;
        int n2 = offset;
        return n != null && n == n2;
    }

    public final void dropBrowsingSession() {
        this.browsingSession.setValue((Object)EMPTY_DATA);
    }

    private final void dropHyperlinkRequest() {
        this.sequentialLifetimes.next();
        this.requestedOffset = null;
    }

    private final void updateBrowsingMode(int modifiers) {
        this.currentBrowseMode.setValue((Object)this.modifiersToBrowseMode(modifiers));
    }

    @NotNull
    protected BrowseMode modifiersToBrowseMode(int modifiers) {
        if (modifiers == 0) {
            return BrowseMode.None;
        }
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"getActiveKeymap(...)");
        Keymap activeKeymap = keymap;
        if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoDeclaration")) {
            return BrowseMode.Declaration;
        }
        if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoTypeDeclaration")) {
            return BrowseMode.TypeDeclaration;
        }
        if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoImplementation")) {
            return BrowseMode.Implementation;
        }
        return BrowseMode.None;
    }

    private static final void visibleAreaListener$lambda$0(FrontendCtrlClickHost this$0, VisibleAreaEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.dropBrowsingSession();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$setRequestedOffset$p(FrontendCtrlClickHost $this, Integer n) {
        $this.requestedOffset = n;
    }

    public static final /* synthetic */ Property access$getBrowsingSession$p(FrontendCtrlClickHost $this) {
        return $this.browsingSession;
    }

    public static final /* synthetic */ VisibleAreaListener access$getVisibleAreaListener$p(FrontendCtrlClickHost $this) {
        return $this.visibleAreaListener;
    }

    public static final /* synthetic */ editorKeyListener.1 access$getEditorKeyListener$p(FrontendCtrlClickHost $this) {
        return $this.editorKeyListener;
    }

    public static final /* synthetic */ Cursor access$getLastCursor$p(FrontendCtrlClickHost $this) {
        return $this.lastCursor;
    }

    public static final /* synthetic */ void access$updateBrowsingMode(FrontendCtrlClickHost $this, int modifiers) {
        $this.updateBrowsingMode(modifiers);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendCtrlClickHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        hand = Cursor.getPredefinedCursor(12);
        TextRange textRange = TextRange.EMPTY_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
        EMPTY_DATA = new BrowsingData(null, -1, textRange);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost$BrowsingData;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "requestOffset", "", "range", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/openapi/editor/Editor;ILcom/intellij/openapi/util/TextRange;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getRequestOffset", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rd.client"})
    private static final class BrowsingData {
        @Nullable
        private final Editor editor;
        private final int requestOffset;
        @NotNull
        private final TextRange range;

        public BrowsingData(@Nullable Editor editor2, int requestOffset, @NotNull TextRange range2) {
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
            this.editor = editor2;
            this.requestOffset = requestOffset;
            this.range = range2;
        }

        @Nullable
        public final Editor getEditor() {
            return this.editor;
        }

        public final int getRequestOffset() {
            return this.requestOffset;
        }

        @NotNull
        public final TextRange getRange() {
            return this.range;
        }

        @Nullable
        public final Editor component1() {
            return this.editor;
        }

        public final int component2() {
            return this.requestOffset;
        }

        @NotNull
        public final TextRange component3() {
            return this.range;
        }

        @NotNull
        public final BrowsingData copy(@Nullable Editor editor2, int requestOffset, @NotNull TextRange range2) {
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
            return new BrowsingData(editor2, requestOffset, range2);
        }

        public static /* synthetic */ BrowsingData copy$default(BrowsingData browsingData, Editor editor2, int n, TextRange textRange, int n2, Object object) {
            if ((n2 & 1) != 0) {
                editor2 = browsingData.editor;
            }
            if ((n2 & 2) != 0) {
                n = browsingData.requestOffset;
            }
            if ((n2 & 4) != 0) {
                textRange = browsingData.range;
            }
            return browsingData.copy(editor2, n, textRange);
        }

        @NotNull
        public String toString() {
            return "BrowsingData(editor=" + this.editor + ", requestOffset=" + this.requestOffset + ", range=" + this.range + ")";
        }

        public int hashCode() {
            int result2 = this.editor == null ? 0 : this.editor.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.requestOffset);
            result2 = result2 * 31 + this.range.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BrowsingData)) {
                return false;
            }
            BrowsingData browsingData = (BrowsingData)other;
            if (!Intrinsics.areEqual((Object)this.editor, (Object)browsingData.editor)) {
                return false;
            }
            if (this.requestOffset != browsingData.requestOffset) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.range, (Object)browsingData.range);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost$Companion;", "", "()V", "EMPTY_DATA", "Lcom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost$BrowsingData;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "backendActionId", "", "hand", "Ljava/awt/Cursor;", "kotlin.jvm.PlatformType", "getInstance", "Lcom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendCtrlClickHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCtrlClickHost.kt\ncom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,218:1\n31#2,2:219\n*S KotlinDebug\n*F\n+ 1 FrontendCtrlClickHost.kt\ncom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost$Companion\n*L\n50#1:219,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendCtrlClickHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<FrontendCtrlClickHost> serviceClass$iv = FrontendCtrlClickHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendCtrlClickHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost$MyEditorMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "()V", "mouseReleased", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.rd.client"})
    public static final class MyEditorMouseListener
    implements EditorMouseListener {
        public void mouseReleased(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getEditor().getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            Companion.getInstance(project2).dropBrowsingSession();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/hyperlinks/FrontendCtrlClickHost$MyEditorMouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "()V", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.rd.client"})
    public static final class MyEditorMouseMotionListener
    implements EditorMouseMotionListener {
        public void mouseMoved(@NotNull EditorMouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getEditor().getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            Companion.getInstance(project2).handleMouseMode(e);
        }
    }
}

