/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.GotItTooltip;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.swing.timing.Timeout;
import org.jetbrains.annotations.NotNull;
import training.actions.ChooseProgrammingLanguageForLearningAction;
import training.lang.LangManager;
import training.learn.LearnBundle;
import training.learn.lesson.LessonManager;
import training.ui.LearningUiUtil;
import training.ui.ScrollModulesPanel;
import training.ui.views.LearnPanel;
import training.ui.views.ModulesPanel;
import training.util.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\r\u0010\u001a\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001bJ\r\u0010\u001c\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001dJ\r\u0010\u001e\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001fJ\b\u0010 \u001a\u00020\u0015H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ltraining/ui/LearnToolWindow;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "wholeToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "learnPanel", "Ltraining/ui/views/LearnPanel;", "getLearnPanel$intellij_featuresTrainer", "()Ltraining/ui/views/LearnPanel;", "modulesPanel", "Ltraining/ui/ScrollModulesPanel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getParentDisposable$intellij_featuresTrainer", "()Lcom/intellij/openapi/Disposable;", "getProject", "()Lcom/intellij/openapi/project/Project;", "reinitViews", "", "reinitViews$intellij_featuresTrainer", "restartAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "setChooseLanguageButton", "setLearnPanel", "setLearnPanel$intellij_featuresTrainer", "setModulesPanel", "setModulesPanel$intellij_featuresTrainer", "showGotItAboutRestart", "showGotItAboutRestart$intellij_featuresTrainer", "updateUI", "intellij.featuresTrainer"})
public final class LearnToolWindow
extends SimpleToolWindowPanel
implements DataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final ToolWindow wholeToolWindow;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final LearnPanel learnPanel;
    @NotNull
    private final ScrollModulesPanel modulesPanel;

    public LearnToolWindow(@NotNull Project project, @NotNull ToolWindow wholeToolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)wholeToolWindow, (String)"wholeToolWindow");
        super(true, true);
        this.project = project;
        this.wholeToolWindow = wholeToolWindow;
        Disposable disposable = this.wholeToolWindow.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        this.parentDisposable = disposable;
        this.learnPanel = new LearnPanel(this);
        this.modulesPanel = new ScrollModulesPanel(LangManager.Companion.getInstance().getLanguages().isEmpty() ? null : new ModulesPanel(this.project));
        this.setChooseLanguageButton();
        this.reinitViews$intellij_featuresTrainer();
        if (LessonManager.Companion.getInstance().lessonIsRunning()) {
            this.setLearnPanel$intellij_featuresTrainer();
        } else {
            this.setContent((JComponent)((Object)this.modulesPanel));
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Disposable getParentDisposable$intellij_featuresTrainer() {
        return this.parentDisposable;
    }

    @NotNull
    public final LearnPanel getLearnPanel$intellij_featuresTrainer() {
        return this.learnPanel;
    }

    public void updateUI() {
        super.updateUI();
        if (this.getParent() != null) {
            this.reinitViews$intellij_featuresTrainer();
        }
    }

    public final void reinitViews$intellij_featuresTrainer() {
        block0: {
            ModulesPanel modulesPanel = this.modulesPanel.getModulesPanel();
            if (modulesPanel == null) break block0;
            modulesPanel.updateMainPanel();
        }
    }

    public final void setLearnPanel$intellij_featuresTrainer() {
        this.wholeToolWindow.setTitleActions(CollectionsKt.listOf((Object)this.restartAction()));
        this.setContent(this.learnPanel);
    }

    public final void showGotItAboutRestart$intellij_featuresTrainer() {
        GotItTooltip gotIt = new GotItTooltip("reset.lesson.got.it", LearnBundle.INSTANCE.message("completed.lessons.got.it", new Object[0]), this.parentDisposable);
        if (gotIt.canShow()) {
            AnAction needToFindButton = this.restartAction();
            ApplicationManager.getApplication().executeOnPooledThread(() -> LearnToolWindow.showGotItAboutRestart$lambda$0(this, needToFindButton, gotIt));
        }
    }

    private final AnAction restartAction() {
        return UtilsKt.getActionById("RestartLessonAction");
    }

    public final void setModulesPanel$intellij_featuresTrainer() {
        this.setChooseLanguageButton();
        ModulesPanel modulesPanel = this.modulesPanel.getModulesPanel();
        if (modulesPanel != null) {
            modulesPanel.updateMainPanel();
        }
        this.setContent((JComponent)((Object)this.modulesPanel));
    }

    private final void setChooseLanguageButton() {
        if (!((Collection)LangManager.Companion.getInstance().getSupportedLanguagesExtensions()).isEmpty() && LangManager.Companion.getInstance().getSupportedLanguagesExtensions().size() > 1) {
            this.wholeToolWindow.setTitleActions(CollectionsKt.listOf((Object)((Object)new ChooseProgrammingLanguageForLearningAction(this))));
        }
    }

    private static final void showGotItAboutRestart$lambda$0(LearnToolWindow this$0, AnAction $needToFindButton, GotItTooltip $gotIt) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$needToFindButton, (String)"$needToFindButton");
        Intrinsics.checkNotNullParameter((Object)$gotIt, (String)"$gotIt");
        Project project = this$0.project;
        Timeout timeout = Timeout.timeout(500L, TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"timeout(...)");
        ActionButton button2 = (ActionButton)LearningUiUtil.findShowingComponentWithTimeout$default(LearningUiUtil.INSTANCE, project, ActionButton.class, timeout, null, (Function1)new Function1<ActionButton, Boolean>($needToFindButton){
            final /* synthetic */ AnAction $needToFindButton;
            {
                this.$needToFindButton = $needToFindButton;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ActionButton it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getAction(), (Object)this.$needToFindButton);
            }
        }, 8, null);
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>($gotIt, button2){
            final /* synthetic */ GotItTooltip $gotIt;
            final /* synthetic */ ActionButton $button;
            {
                this.$gotIt = $gotIt;
                this.$button = $button;
                super(0);
            }

            public final void invoke() {
                this.$gotIt.show((JComponent)this.$button, GotItTooltip.BOTTOM_MIDDLE);
            }
        }), (int)1, null);
    }
}

