/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.info.Info;

public class SvnHistorySession
extends VcsAbstractHistorySession {
    private final SvnVcs myVcs;
    private final FilePath myCommittedPath;
    private final boolean myHaveMergeSources;
    private final boolean myHasLocalSource;

    public SvnHistorySession(SvnVcs vcs, List<? extends VcsFileRevision> revisions, FilePath committedPath, boolean haveMergeSources, @Nullable VcsRevisionNumber currentRevision, boolean skipRefreshOnStart, boolean source) {
        super(revisions, currentRevision);
        this.myVcs = vcs;
        this.myCommittedPath = committedPath;
        this.myHaveMergeSources = haveMergeSources;
        this.myHasLocalSource = source;
        if (!skipRefreshOnStart) {
            this.shouldBeRefreshed();
        }
    }

    @Nullable
    public VcsRevisionNumber calcCurrentRevisionNumber() {
        if (this.myCommittedPath == null) {
            return null;
        }
        if (this.myCommittedPath.isNonLocal()) {
            return new SvnRevisionNumber(Revision.HEAD);
        }
        return SvnHistorySession.getCurrentCommittedRevision(this.myVcs, new File(this.myCommittedPath.getPath()));
    }

    public static VcsRevisionNumber getCurrentCommittedRevision(SvnVcs vcs, File file) {
        Info info2 = vcs.getInfo(file);
        return info2 != null ? new SvnRevisionNumber(info2.getCommitInfo().getRevision()) : null;
    }

    public FilePath getCommittedPath() {
        return this.myCommittedPath;
    }

    public boolean isHaveMergeSources() {
        return this.myHaveMergeSources;
    }

    public VcsHistorySession copy() {
        return new SvnHistorySession(this.myVcs, this.getRevisionList(), this.myCommittedPath, this.myHaveMergeSources, this.getCurrentRevisionNumber(), true, this.myHasLocalSource);
    }

    public boolean hasLocalSource() {
        return this.myHasLocalSource;
    }
}

