/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/perforce/application/P4IgnoresMappingsHelper;", "", "mappings", "", "Lorg/jetbrains/idea/perforce/application/P4IgnoresMappingsHelper$MappingEntry;", "([Lorg/jetbrains/idea/perforce/application/P4IgnoresMappingsHelper$MappingEntry;)V", "[Lorg/jetbrains/idea/perforce/application/P4IgnoresMappingsHelper$MappingEntry;", "isIgnored", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "MappingEntry", "intellij.vcs.perforce"})
public final class P4IgnoresMappingsHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MappingEntry[] mappings;

    private P4IgnoresMappingsHelper(MappingEntry[] mappings) {
        this.mappings = mappings;
    }

    public final boolean isIgnored(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Path path2 = path;
        for (MappingEntry rule : this.mappings) {
            if (!rule.getPathMatcher().matches(path2)) continue;
            return !rule.isExcluded();
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final P4IgnoresMappingsHelper create(@NotNull Project project, @NotNull P4Connection connection) {
        return Companion.create(project, connection);
    }

    public /* synthetic */ P4IgnoresMappingsHelper(MappingEntry[] mappings, DefaultConstructorMarker $constructor_marker) {
        this(mappings);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/perforce/application/P4IgnoresMappingsHelper$Companion;", "", "()V", "create", "Lorg/jetbrains/idea/perforce/application/P4IgnoresMappingsHelper;", "project", "Lcom/intellij/openapi/project/Project;", "connection", "Lorg/jetbrains/idea/perforce/perforce/connections/P4Connection;", "intellij.vcs.perforce"})
    @SourceDebugExtension(value={"SMAP\nP4IgnoresMappingsHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 P4IgnoresMappingsHelper.kt\norg/jetbrains/idea/perforce/application/P4IgnoresMappingsHelper$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,46:1\n37#2,2:47\n*S KotlinDebug\n*F\n+ 1 P4IgnoresMappingsHelper.kt\norg/jetbrains/idea/perforce/application/P4IgnoresMappingsHelper$Companion\n*L\n27#1:47,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final P4IgnoresMappingsHelper create(@NotNull Project project, @NotNull P4Connection connection) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            PerforceRunner perforceRunner = PerforceRunner.getInstance(project);
            ExecResult result = perforceRunner.ignores(connection);
            ArrayList<MappingEntry> mappingsList = new ArrayList<MappingEntry>();
            String string = result.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            CharSequence charSequence = string;
            Regex regex = new Regex("\n");
            int n = 0;
            for (String line : regex.split(charSequence, n)) {
                if (((CharSequence)line).length() == 0) continue;
                boolean excluded = line.charAt(0) == '!';
                String trimmedLine = StringsKt.removePrefix((String)line, (CharSequence)"!");
                MappingEntry entry = new MappingEntry(StringsKt.replace$default((String)trimmedLine, (String)"...", (String)"**", (boolean)false, (int)4, null), excluded);
                mappingsList.add(entry);
            }
            Collection $this$toTypedArray$iv = mappingsList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new P4IgnoresMappingsHelper(thisCollection$iv.toArray(new MappingEntry[0]), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/perforce/application/P4IgnoresMappingsHelper$MappingEntry;", "", "pattern", "", "isExcluded", "", "(Ljava/lang/String;Z)V", "()Z", "pathMatcher", "Ljava/nio/file/PathMatcher;", "getPathMatcher", "()Ljava/nio/file/PathMatcher;", "getPattern", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "intellij.vcs.perforce"})
    private static final class MappingEntry {
        @NotNull
        private final String pattern;
        private final boolean isExcluded;
        @NotNull
        private final PathMatcher pathMatcher;

        public MappingEntry(@NotNull String pattern, boolean isExcluded) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
            this.isExcluded = isExcluded;
            PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + this.pattern);
            Intrinsics.checkNotNullExpressionValue((Object)pathMatcher, (String)"getPathMatcher(...)");
            this.pathMatcher = pathMatcher;
        }

        @NotNull
        public final String getPattern() {
            return this.pattern;
        }

        public final boolean isExcluded() {
            return this.isExcluded;
        }

        @NotNull
        public final PathMatcher getPathMatcher() {
            return this.pathMatcher;
        }

        @NotNull
        public final String component1() {
            return this.pattern;
        }

        public final boolean component2() {
            return this.isExcluded;
        }

        @NotNull
        public final MappingEntry copy(@NotNull String pattern, boolean isExcluded) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return new MappingEntry(pattern, isExcluded);
        }

        public static /* synthetic */ MappingEntry copy$default(MappingEntry mappingEntry, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = mappingEntry.pattern;
            }
            if ((n & 2) != 0) {
                bl = mappingEntry.isExcluded;
            }
            return mappingEntry.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "MappingEntry(pattern=" + this.pattern + ", isExcluded=" + this.isExcluded + ")";
        }

        public int hashCode() {
            int result = this.pattern.hashCode();
            result = result * 31 + Boolean.hashCode(this.isExcluded);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MappingEntry)) {
                return false;
            }
            MappingEntry mappingEntry = (MappingEntry)other;
            if (!Intrinsics.areEqual((Object)this.pattern, (Object)mappingEntry.pattern)) {
                return false;
            }
            return this.isExcluded == mappingEntry.isExcluded;
        }
    }
}

