/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.dvcs.repo.VcsManagedFilesHolderBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.VcsManagedFilesHolder;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceUnversionedTracker;
import org.jetbrains.idea.perforce.application.PerforceVcs;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/perforce/application/PerforceIgnoredFilesHolder;", "Lcom/intellij/dvcs/repo/VcsManagedFilesHolderBase;", "unversionedTracker", "Lorg/jetbrains/idea/perforce/application/PerforceUnversionedTracker;", "(Lorg/jetbrains/idea/perforce/application/PerforceUnversionedTracker;)V", "containsFile", "", "file", "Lcom/intellij/openapi/vcs/FilePath;", "vcsRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "isInUpdatingMode", "values", "", "Provider", "intellij.vcs.perforce"})
public final class PerforceIgnoredFilesHolder
extends VcsManagedFilesHolderBase {
    @NotNull
    private final PerforceUnversionedTracker unversionedTracker;

    public PerforceIgnoredFilesHolder(@NotNull PerforceUnversionedTracker unversionedTracker) {
        Intrinsics.checkNotNullParameter((Object)unversionedTracker, (String)"unversionedTracker");
        this.unversionedTracker = unversionedTracker;
    }

    public boolean isInUpdatingMode() {
        return this.unversionedTracker.isInUpdateMode();
    }

    public boolean containsFile(@NotNull FilePath file, @NotNull VirtualFile vcsRoot) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
        return this.unversionedTracker.isIgnored(file);
    }

    @NotNull
    public Collection<FilePath> values() {
        Collection<FilePath> collection = this.unversionedTracker.getIgnoredFiles();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getIgnoredFiles(...)");
        return collection;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/perforce/application/PerforceIgnoredFilesHolder$Provider;", "Lcom/intellij/openapi/vcs/changes/VcsManagedFilesHolder$Provider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "vcs", "Lorg/jetbrains/idea/perforce/application/PerforceVcs;", "kotlin.jvm.PlatformType", "createHolder", "Lorg/jetbrains/idea/perforce/application/PerforceIgnoredFilesHolder;", "getVcs", "intellij.vcs.perforce"})
    public static final class Provider
    implements VcsManagedFilesHolder.Provider {
        @NotNull
        private final Project project;
        private final PerforceVcs vcs;

        public Provider(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.vcs = PerforceVcs.getInstance(this.project);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public PerforceVcs getVcs() {
            PerforceVcs perforceVcs = this.vcs;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)perforceVcs), (String)"vcs");
            return perforceVcs;
        }

        @NotNull
        public PerforceIgnoredFilesHolder createHolder() {
            PerforceUnversionedTracker perforceUnversionedTracker = this.vcs.getOnlineChangeProvider().getUnversionedTracker();
            Intrinsics.checkNotNullExpressionValue((Object)perforceUnversionedTracker, (String)"getUnversionedTracker(...)");
            return new PerforceIgnoredFilesHolder(perforceUnversionedTracker);
        }
    }
}

