/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.perforce.jobs.ParserLogger;

public class JobDetailsParser {
    private static final ParserLogger LOG = new ParserLogger("#org.jetbrains.idea.perforce.perforce.jobs.JobDetailsParser", "'p4 job' output parse error.");
    private final List<String> myLines;

    public JobDetailsParser(List<String> lines) {
        this.myLines = lines;
    }

    @NotNull
    public List<Pair<String, String>> parse() throws VcsException {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        for (String line : this.myLines) {
            if (line.startsWith("#")) continue;
            if (line.startsWith("\t")) {
                if (result.isEmpty()) {
                    LOG.generateParseException("Cannot parse line: '" + line + "'");
                }
                int lastIdx = result.size() - 1;
                Pair prevVal = (Pair)result.get(lastIdx);
                result.set(lastIdx, (Pair<String, String>)Pair.create((Object)((String)prevVal.getFirst()), (Object)((String)prevVal.getSecond() + "\n" + line.trim())));
                continue;
            }
            int columnIdx = line.indexOf(":");
            if (columnIdx == -1) {
                if (line.trim().startsWith("#")) continue;
                LOG.generateParseException("Cannot find field name in: '" + line + "'");
            }
            result.add((Pair<String, String>)Pair.create((Object)line.substring(0, columnIdx), (Object)line.substring(columnIdx + 1).trim()));
        }
        ArrayList<Pair<String, String>> arrayList = result;
        if (arrayList == null) {
            JobDetailsParser.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/jobs/JobDetailsParser", "parse"));
    }
}

