/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.execution.serviceView.ServiceTreeNode;
import com.intellij.platform.execution.serviceView.ServiceViewManagerImpl;
import com.intellij.platform.execution.serviceView.ServicesTree;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/execution/serviceView/ConfigureServicesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "excludedServicesTree", "Lcom/intellij/platform/execution/serviceView/ServicesTree;", "includedServicesTree", "initiallyFocusedTree", "statusLabel", "Lcom/intellij/ui/components/JBLabel;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "getPreferredFocusedComponent", "move", "from", "to", "moveToExcluded", "moveToIncluded", "Companion", "intellij.platform.execution.serviceView"})
public final class ConfigureServicesDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ServicesTree includedServicesTree;
    @NotNull
    private final ServicesTree excludedServicesTree;
    @NotNull
    private final JBLabel statusLabel;
    @NotNull
    private final ServicesTree initiallyFocusedTree;

    public ConfigureServicesDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        String string = ExecutionBundle.message((String)"service.view.configure.run.configuration.types", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.includedServicesTree = new ServicesTree(this.project, string);
        String string2 = ExecutionBundle.message((String)"service.view.configure.run.tool.windows", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.excludedServicesTree = new ServicesTree(this.project, string2);
        this.statusLabel = new JBLabel();
        this.setTitle(ExecutionBundle.message((String)"service.view.configure.dialog.title", (Object[])new Object[0]));
        Pair<List<ServiceViewContributor<?>>, List<ServiceViewContributor<?>>> services = Companion.collectServices$intellij_platform_execution_serviceView(this.project);
        Pair types = ConfigureServicesDialog.Companion.collectTypes(this.project);
        this.includedServicesTree.initTree((Collection)services.getFirst(), (Collection)types.getFirst(), true);
        this.excludedServicesTree.initTree((Collection)services.getSecond(), (Collection)types.getSecond(), false);
        this.initiallyFocusedTree = this.includedServicesTree;
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel buttonsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        JButton moveToExcludedButton = new JButton(ExecutionBundle.message((String)"service.view.configure.exclude.button.text", (Object[])new Object[0]));
        JButton moveToIncludedButton = new JButton(ExecutionBundle.message((String)"service.view.configure.include.button.text", (Object[])new Object[0]));
        moveToExcludedButton.addActionListener(arg_0 -> ConfigureServicesDialog.createCenterPanel$lambda$0(this, arg_0));
        moveToIncludedButton.addActionListener(arg_0 -> ConfigureServicesDialog.createCenterPanel$lambda$1(this, arg_0));
        buttonsPanel.add(moveToExcludedButton);
        buttonsPanel.add(moveToIncludedButton);
        this.includedServicesTree.installDoubleClickListener((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ConfigureServicesDialog.access$moveToExcluded((ConfigureServicesDialog)((Object)this.receiver));
            }
        }));
        this.excludedServicesTree.installDoubleClickListener((Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ConfigureServicesDialog.access$moveToIncluded((ConfigureServicesDialog)((Object)this.receiver));
            }
        }));
        JPanel mainPanel = new JPanel(new BorderLayout());
        GridBag gridBag = new GridBag().setDefaultWeightX(0, 0.5).setDefaultWeightX(1, 0.0).setDefaultWeightX(2, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"setDefaultWeightX(...)");
        GridBag gridBag2 = gridBag;
        JPanel treesPanel = new JPanel(new GridBagLayout());
        treesPanel.add((Component)new JBLabel(ExecutionBundle.message((String)"service.view.configure.included.label.text", (Object[])new Object[0])), gridBag2.nextLine().next().anchor(17));
        treesPanel.add((Component)new JBLabel(ExecutionBundle.message((String)"service.view.configure.excluded.label.text", (Object[])new Object[0])), gridBag2.next().next().anchor(17));
        JBScrollPane includedPane = new JBScrollPane((Component)this.includedServicesTree.getTree());
        treesPanel.add((Component)includedPane, gridBag2.nextLine().next().weighty(1.0).fillCell());
        treesPanel.add((Component)buttonsPanel, gridBag2.next().anchor(11));
        JBScrollPane excludedPane = new JBScrollPane((Component)this.excludedServicesTree.getTree());
        excludedPane.setPreferredSize(includedPane.getPreferredSize());
        treesPanel.add((Component)excludedPane, gridBag2.next().weighty(1.0).fillCell());
        mainPanel.add((Component)treesPanel, "Center");
        this.statusLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)ExecutionBundle.message((String)"service.view.configure.dialog.description", (Object[])new Object[0])));
        this.statusLabel.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        mainPanel.add((Component)this.statusLabel, "South");
        return mainPanel;
    }

    private final void moveToExcluded() {
        this.move(this.includedServicesTree, this.excludedServicesTree);
    }

    private final void moveToIncluded() {
        this.move(this.excludedServicesTree, this.includedServicesTree);
    }

    private final void move(ServicesTree from, ServicesTree to) {
        List<ServiceTreeNode> nodes = from.getSelectedNodes();
        if (nodes.isEmpty()) {
            return;
        }
        int oldSelectedRow = from.getTree().getSelectionModel().getLeadSelectionRow();
        from.removeNodes((Collection<? extends ServiceTreeNode>)nodes);
        to.addNodes((Collection<? extends ServiceTreeNode>)nodes);
        to.selectNodes((Collection<? extends ServiceTreeNode>)nodes);
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)from.getTree(), true).doWhenDone(() -> ConfigureServicesDialog.move$lambda$2(from, oldSelectedRow));
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.initiallyFocusedTree.getTree();
    }

    protected void doOKAction() {
        ServiceViewManager serviceViewManager = ServiceViewManager.getInstance((Project)this.project);
        Intrinsics.checkNotNull((Object)serviceViewManager, (String)"null cannot be cast to non-null type com.intellij.platform.execution.serviceView.ServiceViewManagerImpl");
        ((ServiceViewManagerImpl)serviceViewManager).setExcludedContributors(this.excludedServicesTree.getServices());
        RunDashboardManager.getInstance((Project)this.project).setTypes(this.includedServicesTree.getTypes());
        super.doOKAction();
    }

    private static final void createCenterPanel$lambda$0(ConfigureServicesDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.moveToExcluded();
    }

    private static final void createCenterPanel$lambda$1(ConfigureServicesDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.moveToIncluded();
    }

    private static final void move$lambda$2(ServicesTree $from, int $oldSelectedRow) {
        Intrinsics.checkNotNullParameter((Object)$from, (String)"$from");
        $from.getTree().getSelectionModel().setSelectionPath($from.getTree().getPathForRow(RangesKt.coerceAtMost((int)$oldSelectedRow, (int)($from.getTree().getRowCount() - 1))));
    }

    public static final /* synthetic */ void access$moveToExcluded(ConfigureServicesDialog $this) {
        $this.moveToExcluded();
    }

    public static final /* synthetic */ void access$moveToIncluded(ConfigureServicesDialog $this) {
        $this.moveToIncluded();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0003\u001a\"\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ(\u0010\n\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/execution/serviceView/ConfigureServicesDialog$Companion;", "", "()V", "collectServices", "Lkotlin/Pair;", "", "Lcom/intellij/execution/services/ServiceViewContributor;", "project", "Lcom/intellij/openapi/project/Project;", "collectServices$intellij_platform_execution_serviceView", "collectTypes", "Lcom/intellij/execution/configurations/ConfigurationType;", "intellij.platform.execution.serviceView"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<List<ServiceViewContributor<?>>, List<ServiceViewContributor<?>>> collectServices$intellij_platform_execution_serviceView(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ArrayList<ServiceViewContributor> included = new ArrayList<ServiceViewContributor>();
            ArrayList<ServiceViewContributor> excluded = new ArrayList<ServiceViewContributor>();
            ServiceViewManager serviceViewManager = ServiceViewManager.getInstance((Project)project);
            for (ServiceViewContributor contributor : ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList()) {
                String toolWindowId;
                ServiceViewDescriptor serviceViewDescriptor = contributor.getViewDescriptor(project);
                ServiceViewToolWindowDescriptor serviceViewToolWindowDescriptor = serviceViewDescriptor instanceof ServiceViewToolWindowDescriptor ? (ServiceViewToolWindowDescriptor)serviceViewDescriptor : null;
                if (serviceViewToolWindowDescriptor != null ? !serviceViewToolWindowDescriptor.isExclusionAllowed() : false) continue;
                String string = serviceViewManager.getToolWindowId(contributor.getClass());
                if (string == null) {
                    string = "Services";
                }
                if (Intrinsics.areEqual((Object)(toolWindowId = string), (Object)"Services")) {
                    included.add(contributor);
                    continue;
                }
                excluded.add(contributor);
            }
            return new Pair(included, excluded);
        }

        private final Pair<List<ConfigurationType>, List<ConfigurationType>> collectTypes(Project project) {
            ArrayList<ConfigurationType> includedTypes = new ArrayList<ConfigurationType>();
            ArrayList<ConfigurationType> excludedTypes = new ArrayList<ConfigurationType>();
            Set set = RunDashboardManager.getInstance((Project)project).getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTypes(...)");
            Set types = set;
            for (ConfigurationType type : ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList()) {
                if (types.contains(type.getId())) {
                    includedTypes.add(type);
                    continue;
                }
                excludedTypes.add(type);
            }
            return new Pair(includedTypes, excludedTypes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

