/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.annotate.VcsLineAnnotationData;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.util.HashMap;
import java.util.Map;

public class VcsAnnotation {
    private final FilePath myFilePath;
    private final VcsLineAnnotationData myBasicAnnotation;
    private final Map<Object, VcsLineAnnotationData> myAdditionalAnnotations;
    private final Map<VcsRevisionNumber, VcsFileRevision> myCachedOtherRevisions;
    private final VcsRevisionNumber myLastRevision;

    public VcsAnnotation(FilePath filePath, VcsLineAnnotationData basicAnnotation, VcsRevisionNumber lastRevision) {
        this.myBasicAnnotation = basicAnnotation;
        this.myLastRevision = lastRevision;
        this.myAdditionalAnnotations = new HashMap<Object, VcsLineAnnotationData>();
        this.myCachedOtherRevisions = new HashMap<VcsRevisionNumber, VcsFileRevision>();
        this.myFilePath = filePath;
    }

    public void addAnnotation(Object o, VcsLineAnnotationData vcsLineAnnotationData) {
        this.myAdditionalAnnotations.put(o, vcsLineAnnotationData);
    }

    public void addCachedRevision(VcsRevisionNumber number, VcsFileRevision revision) {
        this.myCachedOtherRevisions.put(number, revision);
    }

    public void addCachedOtherRevisions(Map<VcsRevisionNumber, VcsFileRevision> revisions) {
        this.myCachedOtherRevisions.putAll(revisions);
    }

    public FilePath getFilePath() {
        return this.myFilePath;
    }

    public VcsLineAnnotationData getBasicAnnotation() {
        return this.myBasicAnnotation;
    }

    public Map<Object, VcsLineAnnotationData> getAdditionalAnnotations() {
        return this.myAdditionalAnnotations;
    }

    public Map<VcsRevisionNumber, VcsFileRevision> getCachedOtherRevisions() {
        return this.myCachedOtherRevisions;
    }

    public VcsRevisionNumber getFirstRevision() {
        return this.myLastRevision;
    }
}

