/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie.dictionary;

import ai.grazie.nlp.similarity.Levenshtein;
import ai.grazie.spell.lists.WordList;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\tH\u0016J \u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00040\rj\b\u0012\u0004\u0012\u00020\u0004`\u000e2\u0006\u0010\n\u001a\u00020\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/spellchecker/grazie/dictionary/SimpleWordList;", "Lai/grazie/spell/lists/WordList;", "container", "", "", "(Ljava/util/Set;)V", "invariants", "buildInvariants", "contains", "", "word", "caseSensitive", "suggest", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "Companion", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nSimpleWordList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleWordList.kt\ncom/intellij/spellchecker/grazie/dictionary/SimpleWordList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n857#2,2:34\n*S KotlinDebug\n*F\n+ 1 SimpleWordList.kt\ncom/intellij/spellchecker/grazie/dictionary/SimpleWordList\n*L\n29#1:34,2\n*E\n"})
public final class SimpleWordList
implements WordList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> container;
    @NotNull
    private final Set<String> invariants;
    public static final int MAX_LEVENSHTEIN_DISTANCE = 3;

    public SimpleWordList(@NotNull Set<String> container) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        this.container = container;
        this.invariants = this.buildInvariants(this.container);
    }

    private final Set<String> buildInvariants(Set<String> container) {
        Set set = CollectionFactory.createSmallMemoryFootprintSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createSmallMemoryFootprintSet(...)");
        Set result2 = set;
        for (String entry2 : container) {
            ProgressManager.checkCanceled();
            String string2 = entry2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            result2.add(string2);
        }
        return result2;
    }

    public boolean contains(@NotNull String word, boolean caseSensitive) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (caseSensitive) {
            bl = this.container.contains(word);
        } else {
            String string2 = word.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            bl = this.invariants.contains(string2);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word) {
        void var3_3;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Iterable iterable = this.container;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!(Levenshtein.INSTANCE.distance(it, word, 4) <= 3)) continue;
            destination$iv.add(element$iv);
        }
        return (LinkedHashSet)var3_3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/spellchecker/grazie/dictionary/SimpleWordList$Companion;", "", "()V", "MAX_LEVENSHTEIN_DISTANCE", "", "intellij.spellchecker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

