/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.IncludedXmlTag;
import com.intellij.xml.util.XmlIncludeHandler;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class InclusionProvider
implements CachedValueProvider<PsiElement[]> {
    private static final Logger LOG = Logger.getInstance(InclusionProvider.class);
    private final XmlTag myXincludeTag;

    InclusionProvider(XmlTag xincludeTag) {
        this.myXincludeTag = xincludeTag;
    }

    public static PsiElement @NotNull [] getIncludedTags(XmlTag xincludeTag) {
        if (!XmlTagImpl.shouldProcessIncludesNow()) {
            LOG.error("XML include processing is disabled during indexing, please fix callers who insists on enabling it");
            IdempotenceChecker.logTrace((String)"!shouldProcessIncludesNow");
            if (PsiElement.EMPTY_ARRAY == null) {
                InclusionProvider.$$$reportNull$$$0(0);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = (PsiElement[])CachedValuesManager.getCachedValue((PsiElement)xincludeTag, (CachedValueProvider)new InclusionProvider(xincludeTag));
        if (psiElementArray == null) {
            InclusionProvider.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    public CachedValueProvider.Result<PsiElement[]> compute() {
        PsiElement[] result2 = (PsiElement[])RecursionManager.doPreventingRecursion((Object)this.myXincludeTag, (boolean)true, () -> InclusionProvider.computeInclusion(this.myXincludeTag));
        if (result2 == null) {
            IdempotenceChecker.logTrace((String)"InclusionProvider recursion prevented");
        }
        return CachedValueProvider.Result.create((Object)(result2 == null ? PsiElement.EMPTY_ARRAY : result2), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    }

    private static XmlTag[] extractXpointer(@NotNull XmlTag rootTag, @Nullable String xpointer) {
        String pointer;
        Matcher matcher;
        if (rootTag == null) {
            InclusionProvider.$$$reportNull$$$0(2);
        }
        if (xpointer != null && (matcher = JDOMUtil.XPOINTER_PATTERN.matcher(xpointer)).matches() && (matcher = JDOMUtil.CHILDREN_PATTERN.matcher(pointer = matcher.group(1))).matches() && matcher.group(1).equals(rootTag.getName())) {
            Object[] tags = rootTag.getSubTags();
            String subTagName = matcher.group(2);
            if (subTagName == null) {
                return tags;
            }
            XmlTag subTag = (XmlTag)ContainerUtil.find((Object[])tags, t -> subTagName.substring(1).equals(t.getName()));
            return subTag == null ? XmlTag.EMPTY : subTag.getSubTags();
        }
        return new XmlTag[]{rootTag};
    }

    private static PsiElement @Nullable [] computeInclusion(XmlTag xincludeTag) {
        XmlTag rootTag;
        XmlFile included = XmlIncludeHandler.resolveXIncludeFile(xincludeTag);
        if (IdempotenceChecker.isLoggingEnabled()) {
            IdempotenceChecker.logTrace((String)("InclusionProvider resolved file=" + included));
        }
        XmlDocument document2 = included != null ? included.getDocument() : null;
        XmlTag xmlTag = rootTag = document2 != null ? document2.getRootTag() : null;
        if (rootTag != null) {
            String xpointer = xincludeTag.getAttributeValue("xpointer", "http://www.w3.org/2001/XInclude");
            XmlTag[] includeTag = InclusionProvider.extractXpointer(rootTag, xpointer);
            if (IdempotenceChecker.isLoggingEnabled()) {
                IdempotenceChecker.logTrace((String)("InclusionProvider found " + includeTag.length + " tags by " + xpointer));
            }
            PsiElement[] result2 = new PsiElement[includeTag.length];
            for (int i = 0; i < includeTag.length; ++i) {
                result2[i] = new IncludedXmlTag(includeTag[i], (PsiElement)xincludeTag.getParentTag());
            }
            return result2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/util/InclusionProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/util/InclusionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractXpointer";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2 -> new IllegalArgumentException(string2);
        };
    }
}

