/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.X25519PublicBCPGKey;
import org.bouncycastle.bcpg.X448PublicBCPGKey;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.encoders.Hex;

public class RFC6637Utils {
    private static final byte[] ANONYMOUS_SENDER = Hex.decode((String)"416E6F6E796D6F75732053656E64657220202020");

    private RFC6637Utils() {
    }

    public static String getXDHAlgorithm(PublicKeyPacket publicKeyPacket) {
        if (publicKeyPacket.getKey() instanceof X25519PublicBCPGKey) {
            return "X25519withSHA256CKDF";
        }
        if (publicKeyPacket.getKey() instanceof X448PublicBCPGKey) {
            return "X448withSHA512CKDF";
        }
        ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
        switch (eCDHPublicBCPGKey.getHashAlgorithm()) {
            case 8: {
                return "X25519withSHA256CKDF";
            }
            case 9: {
                return "X25519withSHA384CKDF";
            }
            case 10: {
                return "X25519withSHA512CKDF";
            }
        }
        throw new IllegalArgumentException("Unknown hash algorithm specified: " + eCDHPublicBCPGKey.getHashAlgorithm());
    }

    public static String getAgreementAlgorithm(PublicKeyPacket publicKeyPacket) {
        ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
        switch (eCDHPublicBCPGKey.getHashAlgorithm()) {
            case 8: {
                return "ECCDHwithSHA256CKDF";
            }
            case 9: {
                return "ECCDHwithSHA384CKDF";
            }
            case 10: {
                return "ECCDHwithSHA512CKDF";
            }
        }
        throw new IllegalArgumentException("Unknown hash algorithm specified: " + eCDHPublicBCPGKey.getHashAlgorithm());
    }

    public static ASN1ObjectIdentifier getKeyEncryptionOID(int n) throws PGPException {
        switch (n) {
            case 7: {
                return NISTObjectIdentifiers.id_aes128_wrap;
            }
            case 8: {
                return NISTObjectIdentifiers.id_aes192_wrap;
            }
            case 9: {
                return NISTObjectIdentifiers.id_aes256_wrap;
            }
            case 11: {
                return NTTObjectIdentifiers.id_camellia128_wrap;
            }
            case 12: {
                return NTTObjectIdentifiers.id_camellia192_wrap;
            }
            case 13: {
                return NTTObjectIdentifiers.id_camellia256_wrap;
            }
        }
        throw new PGPException("unknown symmetric algorithm ID: " + n);
    }

    public static byte[] createUserKeyingMaterial(PublicKeyPacket publicKeyPacket, KeyFingerPrintCalculator keyFingerPrintCalculator) throws IOException, PGPException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
        byte[] byArray = eCDHPublicBCPGKey.getCurveOID().getEncoded();
        byteArrayOutputStream.write(byArray, 1, byArray.length - 1);
        byteArrayOutputStream.write(publicKeyPacket.getAlgorithm());
        byteArrayOutputStream.write(3);
        byteArrayOutputStream.write(1);
        byteArrayOutputStream.write(eCDHPublicBCPGKey.getHashAlgorithm());
        byteArrayOutputStream.write(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
        byteArrayOutputStream.write(ANONYMOUS_SENDER);
        byteArrayOutputStream.write(keyFingerPrintCalculator.calculateFingerprint(publicKeyPacket));
        return byteArrayOutputStream.toByteArray();
    }
}

