/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class SetupProjectSdkCommand
extends AbstractCommand {
    public static final String PREFIX = "%setupSDK";
    private final String mySdkName;
    private final String mySdkType;
    private final String mySdkHome;

    private static String nextArg(@NotNull Iterator<String> args, @NotNull String text2) {
        if (args == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(1);
        }
        if (!args.hasNext()) {
            throw new RuntimeException("Too few arguments in " + text2);
        }
        return args.next();
    }

    public SetupProjectSdkCommand(String text2, int line) {
        super(text2, line);
        Iterator<String> args = StringUtil.splitHonorQuotes((String)text2, (char)' ').stream().map(StringUtil::unquoteString).iterator();
        SetupProjectSdkCommand.nextArg(args, text2);
        this.mySdkName = SetupProjectSdkCommand.nextArg(args, text2);
        this.mySdkType = SetupProjectSdkCommand.nextArg(args, text2);
        this.mySdkHome = SetupProjectSdkCommand.nextArg(args, text2);
    }

    private void runUnderPromiseInEDT(@NotNull Consumer<String> logMessage, @NotNull Project project) {
        if (logMessage == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(2);
        }
        if (project == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(3);
        }
        logMessage.accept("Settings up SDK: name: " + this.mySdkName + ", type: " + this.mySdkType + ", home: " + this.mySdkHome);
        Sdk sdk = this.setupOrDetectSdk(logMessage);
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        Sdk projectSdk = rootManager.getProjectSdk();
        if (!Objects.equals(projectSdk, sdk)) {
            logMessage.accept("Project uses different SDK: " + projectSdk + " (sdkName is " + rootManager.getProjectSdkName() + ", type " + rootManager.getProjectSdkTypeName() + "). Updating...");
            rootManager.setProjectSdk(sdk);
        }
        logMessage.accept("Project SDK is set to use the new SDK");
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (Objects.equals(moduleSdk, sdk)) continue;
            logMessage.accept("Module " + module.getName() + " uses different SDK: " + moduleSdk + " IGNORING!");
        }
    }

    @NotNull
    private Sdk setupOrDetectSdk(@NotNull Consumer<String> logMessage) {
        boolean isValidSdkHome;
        SdkType sdkType;
        Sdk oldSdk;
        if (logMessage == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(4);
        }
        if ((oldSdk = ProjectJdkTable.getInstance().findJdk(this.mySdkName)) != null) {
            if (Objects.equals(oldSdk.getSdkType().getName(), this.mySdkName) && FileUtil.pathsEqual((String)oldSdk.getHomePath(), (String)this.mySdkHome)) {
                logMessage.accept("Existing SDK is already configured the expected way");
                Sdk sdk = oldSdk;
                if (sdk == null) {
                    SetupProjectSdkCommand.$$$reportNull$$$0(5);
                }
                return sdk;
            }
            logMessage.accept("Existing different SDK will be removed: " + oldSdk);
            ProjectJdkTable.getInstance().removeJdk(oldSdk);
        }
        if ((sdkType = SdkType.findByName((String)this.mySdkType)) == null) {
            throw new IllegalArgumentException("Failed to find SdkType: " + this.mySdkType);
        }
        try {
            isValidSdkHome = sdkType.isValidSdkHome(this.mySdkHome);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Sdk home " + this.mySdkHome + " for " + sdkType + " is not valid. " + t.getMessage(), t);
        }
        if (!isValidSdkHome) {
            throw new IllegalArgumentException("Sdk home " + this.mySdkHome + " for " + sdkType + " is not valid");
        }
        Sdk newSdk = ProjectJdkTable.getInstance().createSdk(this.mySdkName, (SdkTypeId)sdkType);
        SdkModificator mod = newSdk.getSdkModificator();
        try {
            mod.setVersionString(sdkType.getVersionString(this.mySdkHome));
            mod.setHomePath(this.mySdkHome);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to configure Sdk instance home for " + this.mySdkHome + " for " + sdkType + " is not valid. " + t.getMessage(), t);
        }
        finally {
            mod.commitChanges();
        }
        try {
            sdkType.setupSdkPaths(newSdk);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to setup Sdk home for " + this.mySdkHome + " for " + sdkType + " is not valid. " + t.getMessage(), t);
        }
        this.registerNewSdk(newSdk);
        logMessage.accept("Registered new SDK to ProjectJdkTable: " + newSdk);
        Sdk sdk = newSdk;
        if (sdk == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(6);
        }
        return sdk;
    }

    protected void registerNewSdk(@NotNull Sdk newSdk) {
        if (newSdk == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(7);
        }
        ProjectJdkTable.getInstance().addJdk(newSdk);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(8);
        }
        AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().invokeLater(() -> Promises.compute((AsyncPromise)promise, () -> {
            this.computePromise(s -> context.message(s, this.getLine()), context.getProject());
            return null;
        }));
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(9);
        }
        return asyncPromise;
    }

    public void computePromise(@NotNull Consumer<String> logMessage, @NotNull Project project) {
        if (logMessage == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(10);
        }
        if (project == null) {
            SetupProjectSdkCommand.$$$reportNull$$$0(11);
        }
        WriteAction.run(() -> this.runUnderPromiseInEDT(logMessage, project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logMessage";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/SetupProjectSdkCommand";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSdk";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/SetupProjectSdkCommand";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setupOrDetectSdk";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nextArg";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runUnderPromiseInEDT";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupOrDetectSdk";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerNewSdk";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computePromise";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 9 -> new IllegalStateException(string);
        };
    }
}

