/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.io.File;
import javax.swing.JFileChooser;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.format.Formatting;

final class JFileChooserSelectFileTask {
    @RunsInEDT
    static void setSelectedFile(@Nonnull JFileChooser fileChooser, @Nonnull File file) {
        GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(fileChooser);
            JFileChooserSelectFileTask.checkSelectionMode(fileChooser, file);
            fileChooser.setSelectedFile(file);
        });
    }

    @RunsInEDT
    static void setSelectedFiles(@Nonnull JFileChooser fileChooser, @Nonnull File[] files) {
        GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(fileChooser);
            if (files.length > 1 && !fileChooser.isMultiSelectionEnabled()) {
                throw new IllegalStateException(Strings.concat("Expecting file chooser ", Formatting.format(fileChooser), " to handle multiple selection"));
            }
            for (File file : files) {
                JFileChooserSelectFileTask.checkSelectionMode(fileChooser, file);
            }
            fileChooser.setSelectedFiles(files);
        });
    }

    @RunsInCurrentThread
    private static void checkSelectionMode(JFileChooser fileChooser, File file) {
        int mode = fileChooser.getFileSelectionMode();
        if (mode == 0 && !file.isFile()) {
            throw JFileChooserSelectFileTask.cannotSelectFile(file, "the file chooser can only open files");
        }
        if (mode == 1 && !file.isDirectory()) {
            throw JFileChooserSelectFileTask.cannotSelectFile(file, "the file chooser can only open directories");
        }
    }

    private static IllegalArgumentException cannotSelectFile(File file, String reason) {
        String msg = String.format("Unabled to select file %s: %s", new StandardRepresentation().toStringOf((Object)file), reason);
        return new IllegalArgumentException(msg);
    }

    private JFileChooserSelectFileTask() {
    }
}

