/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.util.Map;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.exception.ActionFailedException;
import org.assertj.swing.util.Maps;

final class JOptionPaneMessageTypes {
    private static final Map<Integer, String> messageMap = Maps.newHashMap();

    @Nonnull
    static String messageTypeAsText(int messageType) {
        if (messageMap.containsKey(messageType)) {
            return Preconditions.checkNotNullOrEmpty(messageMap.get(messageType)).toString();
        }
        throw ActionFailedException.actionFailure(Strings.concat("The message type <", messageType, "> is not valid"));
    }

    private JOptionPaneMessageTypes() {
    }

    static {
        messageMap.put(0, "Error Message");
        messageMap.put(1, "Information Message");
        messageMap.put(2, "Warning Message");
        messageMap.put(3, "Question Message");
        messageMap.put(-1, "Plain Message");
    }
}

