/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Insets;
import java.awt.Point;
import java.util.Map;
import javax.swing.JSlider;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.util.Maps;

public final class JSliderLocation {
    private static final Map<Integer, JSliderLocationStrategy> LOCATIONS = Maps.newHashMap();

    @Nonnull
    @RunsInCurrentThread
    public Point pointAt(@Nonnull JSlider slider, int value) {
        JSliderLocationStrategy strategy = LOCATIONS.get(slider.getOrientation());
        return strategy.locationForValue(slider, value);
    }

    static {
        LOCATIONS.put(0, new JSliderHorizontalLocation());
        LOCATIONS.put(1, new JSliderVerticalLocation());
    }

    private static abstract class JSliderLocationStrategy {
        private JSliderLocationStrategy() {
        }

        @Nonnull
        @RunsInCurrentThread
        final Point locationForValue(JSlider slider, int value) {
            Point center = new Point(slider.getWidth() / 2, slider.getHeight() / 2);
            int max = this.max(slider, Preconditions.checkNotNull(slider.getInsets()));
            int coordinate = (int)(this.percent(slider, value) * (float)max);
            if (!slider.getInverted()) {
                coordinate = max - coordinate;
            }
            return this.update(center, coordinate);
        }

        @RunsInCurrentThread
        abstract int max(@Nonnull JSlider var1, @Nonnull Insets var2);

        @Nonnull
        @RunsInCurrentThread
        abstract Point update(@Nonnull Point var1, int var2);

        @RunsInCurrentThread
        private float percent(@Nonnull JSlider slider, int value) {
            int minimum = slider.getMinimum();
            int range = slider.getMaximum() - minimum;
            return (float)(value - minimum) / (float)range;
        }
    }

    private static class JSliderVerticalLocation
    extends JSliderLocationStrategy {
        private JSliderVerticalLocation() {
        }

        @Override
        @RunsInCurrentThread
        int max(@Nonnull JSlider slider, @Nonnull Insets insets) {
            return slider.getHeight() - insets.top - insets.bottom - 1;
        }

        @Override
        @Nonnull
        @RunsInCurrentThread
        Point update(@Nonnull Point center, int coordinate) {
            return new Point(center.x, coordinate);
        }
    }

    private static class JSliderHorizontalLocation
    extends JSliderLocationStrategy {
        private JSliderHorizontalLocation() {
        }

        @Override
        @RunsInCurrentThread
        int max(@Nonnull JSlider slider, @Nonnull Insets insets) {
            return slider.getWidth() - insets.left - insets.right - 1;
        }

        @Override
        @Nonnull
        @RunsInCurrentThread
        Point update(@Nonnull Point center, int coordinate) {
            return new Point(coordinate, center.y);
        }
    }
}

