/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.i18n.AbstractI18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.Language;
import com.intellij.lang.properties.psi.I18nizedTextGenerator;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.util.UastExpressionUtils;

public class I18nizeConcatenationQuickFix
extends AbstractI18nizeQuickFix<UPolyadicExpression> {
    @NonNls
    public static final String PARAMETERS_OPTION_KEY = "PARAMETERS";

    public I18nizeConcatenationQuickFix(NlsInfo.Localized info) {
        super(info);
    }

    @Override
    public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
        UPolyadicExpression concatenation = this.getEnclosingLiteral(psiFile, editor);
        if (concatenation != null) {
            return;
        }
        String message = JavaI18nBundle.message("quickfix.i18n.concatentation.error", new Object[0]);
        throw new IncorrectOperationException(message);
    }

    @Override
    public UPolyadicExpression getEnclosingLiteral(PsiFile file, Editor editor) {
        PsiElement elementAt = file.findElementAt(editor.getCaretModel().getOffset());
        return I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(elementAt);
    }

    @Override
    public JavaI18nizeQuickFixDialog<UPolyadicExpression> createDialog(Project project, Editor editor, PsiFile psiFile) {
        UPolyadicExpression concatenation = this.getEnclosingLiteral(psiFile, editor);
        return concatenation == null ? null : this.createDialog(project, psiFile, concatenation);
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaI18nBundle.message("quickfix.i18n.concatentation", new Object[0]);
        if (string == null) {
            I18nizeConcatenationQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void doReplacement(@NotNull PsiFile psiFile, @NotNull Editor editor, @Nullable UPolyadicExpression literalExpression, String i18nizedText) throws IncorrectOperationException {
        if (psiFile == null) {
            I18nizeConcatenationQuickFix.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            I18nizeConcatenationQuickFix.$$$reportNull$$$0(2);
        }
        @Nullable UPolyadicExpression concatenation = I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation((UExpression)literalExpression);
        assert (concatenation != null);
        UastCodeGenerationPlugin generationPlugin = UastCodeGenerationPlugin.byLanguage((Language)psiFile.getLanguage());
        I18nizeConcatenationQuickFix.doDocumentReplacement(psiFile, (UElement)concatenation, i18nizedText, editor.getDocument(), generationPlugin);
    }

    @Override
    protected JavaI18nizeQuickFixDialog<UPolyadicExpression> createDialog(Project project, PsiFile context, final @NotNull UPolyadicExpression concatenation) {
        if (concatenation == null) {
            I18nizeConcatenationQuickFix.$$$reportNull$$$0(3);
        }
        final ArrayList args = new ArrayList();
        String formatString = JavaI18nUtil.buildUnescapedFormatString(Objects.requireNonNull(UStringConcatenationsFacade.createFromTopConcatenation((UExpression)concatenation)), args, project);
        return new JavaI18nizeQuickFixDialog<UPolyadicExpression>(project, context, concatenation, formatString, this.getCustomization(formatString), true, true){

            @Override
            @Nullable
            protected String getTemplateName() {
                return this.myResourceBundleManager.getConcatenationTemplateName();
            }

            @Override
            protected String generateText(I18nizedTextGenerator textGenerator, @NotNull String propertyKey, PropertiesFile propertiesFile, PsiElement context) {
                if (propertyKey == null) {
                    1.$$$reportNull$$$0(0);
                }
                return textGenerator.getI18nizedConcatenationText(propertyKey, JavaI18nUtil.composeParametersText(args), propertiesFile, concatenation.getSourcePsi());
            }

            @Override
            public UExpression[] getParameters() {
                return args.toArray(new UExpression[0]);
            }

            @Override
            protected void addAdditionalAttributes(Map<String, String> attributes) {
                attributes.put(I18nizeConcatenationQuickFix.PARAMETERS_OPTION_KEY, JavaI18nUtil.composeParametersText(args));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyKey", "com/intellij/codeInspection/i18n/I18nizeConcatenationQuickFix$1", "generateText"));
            }
        };
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        UPolyadicExpression concatenation;
        if (project == null) {
            I18nizeConcatenationQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            I18nizeConcatenationQuickFix.$$$reportNull$$$0(5);
        }
        if ((concatenation = I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(descriptor.getPsiElement())) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                I18nizeConcatenationQuickFix.$$$reportNull$$$0(6);
            }
            return intentionPreviewInfo;
        }
        ArrayList args = new ArrayList();
        @NlsSafe String string = JavaI18nUtil.buildUnescapedFormatString(Objects.requireNonNull(UStringConcatenationsFacade.createFromTopConcatenation((UExpression)concatenation)), args, project);
        return new IntentionPreviewInfo.Html(new HtmlBuilder().append(JavaI18nBundle.message("i18n.quickfix.preview.description", new Object[0])).br().append((HtmlChunk)HtmlChunk.text((String)string).code()).toFragment());
    }

    @Nullable
    public static UPolyadicExpression getEnclosingLiteralConcatenation(PsiElement psiElement) {
        return I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation((UExpression)UastContextKt.getUastParentOfType((PsiElement)psiElement, UPolyadicExpression.class));
    }

    @Nullable
    public static UPolyadicExpression getEnclosingLiteralConcatenation(@Nullable UExpression literalExpression) {
        if (literalExpression == null) {
            return null;
        }
        UExpression topExpression = (UExpression)UastUtils.getParentOfType((UElement)literalExpression, UPolyadicExpression.class, (boolean)false);
        UStringConcatenationsFacade concatenation = null;
        while (topExpression != null) {
            UElement parent;
            UStringConcatenationsFacade nextConcatenation = UStringConcatenationsFacade.createFromTopConcatenation((UExpression)topExpression);
            if (nextConcatenation != null) {
                concatenation = nextConcatenation;
            }
            if (!((parent = topExpression.getUastParent()) instanceof UParenthesizedExpression) && !(parent instanceof UIfExpression) && (!(parent instanceof UPolyadicExpression) || UastExpressionUtils.isAssignment((UElement)parent))) break;
            topExpression = (UExpression)parent;
        }
        if (concatenation != null) {
            PartiallyKnownString pks = concatenation.asPartiallyKnownString();
            if (pks.getSegments().size() == 1) {
                return null;
            }
            return (UPolyadicExpression)concatenation.getRootUExpression();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/I18nizeConcatenationQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "concatenation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/I18nizeConcatenationQuickFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doReplacement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

