/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogUserResolver;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0017\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t0\u0011H\u0004J.\u0010\u0018\u001a(\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t\u0018\u00010\u0011H\u0004J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001c\u001a\u00020\nH\u0016R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR8\u0010\u000f\u001a,\u0012(\u0012&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t0\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/data/VcsLogUserResolverBase;", "Lcom/intellij/vcs/log/data/VcsLogUserResolver;", "()V", "allUsers", "", "Lcom/intellij/vcs/log/VcsUser;", "getAllUsers", "()Ljava/util/Set;", "allUsersByEmails", "Lcom/intellij/util/containers/MultiMap;", "", "getAllUsersByEmails", "()Lcom/intellij/util/containers/MultiMap;", "allUsersByNames", "getAllUsersByNames", "cachedUsers", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "Lkotlin/Pair;", "currentUsers", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCurrentUsers", "()Ljava/util/Map;", "buildCache", "clearCache", "resolveCurrentUser", "root", "resolveUserName", "name", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogUserResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogUserResolver.kt\ncom/intellij/vcs/log/data/VcsLogUserResolverBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1549#2:67\n1620#2,3:68\n766#2:71\n857#2,2:72\n*S KotlinDebug\n*F\n+ 1 VcsLogUserResolver.kt\ncom/intellij/vcs/log/data/VcsLogUserResolverBase\n*L\n56#1:67\n56#1:68,3\n57#1:71\n57#1:72,2\n*E\n"})
public abstract class VcsLogUserResolverBase
implements VcsLogUserResolver {
    @NotNull
    private final SynchronizedClearableLazy<Pair<MultiMap<String, VcsUser>, MultiMap<String, VcsUser>>> cachedUsers = new SynchronizedClearableLazy((Function0)new Function0<Pair<? extends MultiMap<String, VcsUser>, ? extends MultiMap<String, VcsUser>>>(this){
        final /* synthetic */ VcsLogUserResolverBase this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Pair<MultiMap<String, VcsUser>, MultiMap<String, VcsUser>> invoke() {
            MultiMap multiMap = MultiMap.create();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
            MultiMap usersByNames = multiMap;
            MultiMap multiMap2 = MultiMap.create();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap2, (String)"create(...)");
            MultiMap usersByEmails = multiMap2;
            for (VcsUser user : this.this$0.getAllUsers()) {
                String email;
                String name;
                Intrinsics.checkNotNullExpressionValue((Object)user.getName(), (String)"getName(...)");
                if (((CharSequence)name).length() > 0) {
                    usersByNames.putValue((Object)VcsUserUtil.getNameInStandardForm((String)name), (Object)user);
                }
                Intrinsics.checkNotNullExpressionValue((Object)user.getEmail(), (String)"getEmail(...)");
                String nameFromEmail = VcsUserUtil.getNameFromEmail((String)email);
                if (nameFromEmail == null) continue;
                usersByEmails.putValue((Object)VcsUserUtil.getNameInStandardForm((String)nameFromEmail), (Object)user);
            }
            return new Pair((Object)usersByNames, (Object)usersByEmails);
        }
    });

    @NotNull
    public abstract Map<VirtualFile, VcsUser> getCurrentUsers();

    @NotNull
    public abstract Set<VcsUser> getAllUsers();

    private final MultiMap<String, VcsUser> getAllUsersByNames() {
        return (MultiMap)((Pair)this.cachedUsers.getValue()).getFirst();
    }

    private final MultiMap<String, VcsUser> getAllUsersByEmails() {
        return (MultiMap)((Pair)this.cachedUsers.getValue()).getSecond();
    }

    @NotNull
    protected final Pair<MultiMap<String, VcsUser>, MultiMap<String, VcsUser>> buildCache() {
        return (Pair)this.cachedUsers.getValue();
    }

    @Nullable
    protected final Pair<MultiMap<String, VcsUser>, MultiMap<String, VcsUser>> clearCache() {
        return (Pair)this.cachedUsers.drop();
    }

    @Override
    @NotNull
    public Set<VcsUser> resolveUserName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = VcsUserUtil.getNameInStandardForm((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameInStandardForm(...)");
        String standardName = string;
        Collection collection = this.getAllUsersByNames().get((Object)standardName);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Iterable iterable = collection;
        Collection collection2 = this.getAllUsersByEmails().get((Object)standardName);
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
        return CollectionsKt.union((Iterable)iterable, (Iterable)collection2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<VcsUser> resolveCurrentUser(@NotNull VirtualFile root) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        VcsUser vcsUser = this.getCurrentUsers().get(root);
        if (vcsUser == null) {
            return SetsKt.emptySet();
        }
        String string = vcsUser.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Set<VcsUser> usersByName = this.resolveUserName(string);
        String string2 = VcsUserUtil.getNameFromEmail((String)vcsUser.getEmail());
        if (string2 == null) {
            return usersByName;
        }
        String emailNamePart = string2;
        Iterable $this$map$iv = usersByName;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void user;
            VcsUser vcsUser2 = (VcsUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(VcsUserUtil.emailToLowerCase((String)user.getEmail()));
        }
        Set emails = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$filter$iv = this.resolveUserName(emailNamePart);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsUser candidateUser = (VcsUser)element$iv$iv;
            boolean bl = false;
            if (!emails.contains(VcsUserUtil.emailToLowerCase((String)candidateUser.getEmail()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List usersByEmail = (List)destination$iv$iv2;
        return SetsKt.plus(usersByName, (Iterable)usersByEmail);
    }
}

