/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.api.elements;

import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GraphEdge
implements GraphElement {
    @Nullable
    private final Integer myUpNodeIndex;
    @Nullable
    private final Integer myDownNodeIndex;
    @Nullable
    private final Integer myTargetId;
    @NotNull
    private final GraphEdgeType myType;

    public static GraphEdge createNormalEdge(int nodeIndex1, int nodeIndex2, @NotNull GraphEdgeType type) {
        if (type == null) {
            GraphEdge.$$$reportNull$$$0(0);
        }
        assert (type.isNormalEdge()) : "Unexpected edge type: " + type;
        return new GraphEdge(Math.min(nodeIndex1, nodeIndex2), Math.max(nodeIndex1, nodeIndex2), null, type);
    }

    public static GraphEdge createEdgeWithTargetId(int nodeIndex, @Nullable Integer targetId, @NotNull GraphEdgeType type) {
        if (type == null) {
            GraphEdge.$$$reportNull$$$0(1);
        }
        return switch (type) {
            case GraphEdgeType.DOTTED_ARROW_UP -> new GraphEdge(null, nodeIndex, targetId, type);
            case GraphEdgeType.NOT_LOAD_COMMIT, GraphEdgeType.DOTTED_ARROW_DOWN -> new GraphEdge(nodeIndex, null, targetId, type);
            default -> throw new AssertionError((Object)("Unexpected edge type: " + type));
        };
    }

    public GraphEdge(@Nullable Integer upNodeIndex, @Nullable Integer downNodeIndex, @Nullable Integer targetId, @NotNull GraphEdgeType type) {
        if (type == null) {
            GraphEdge.$$$reportNull$$$0(2);
        }
        this.myUpNodeIndex = upNodeIndex;
        this.myDownNodeIndex = downNodeIndex;
        this.myTargetId = targetId;
        this.myType = type;
    }

    @Nullable
    public Integer getUpNodeIndex() {
        return this.myUpNodeIndex;
    }

    @Nullable
    public Integer getDownNodeIndex() {
        return this.myDownNodeIndex;
    }

    @Nullable
    public Integer getTargetId() {
        return this.myTargetId;
    }

    @NotNull
    public GraphEdgeType getType() {
        GraphEdgeType graphEdgeType = this.myType;
        if (graphEdgeType == null) {
            GraphEdge.$$$reportNull$$$0(3);
        }
        return graphEdgeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphEdge graphEdge = (GraphEdge)o;
        if (this.myType != graphEdge.myType) {
            return false;
        }
        if (!Objects.equals(this.myUpNodeIndex, graphEdge.myUpNodeIndex)) {
            return false;
        }
        if (!Objects.equals(this.myDownNodeIndex, graphEdge.myDownNodeIndex)) {
            return false;
        }
        return Objects.equals(this.myTargetId, graphEdge.myTargetId);
    }

    public int hashCode() {
        int result2 = this.myUpNodeIndex != null ? this.myUpNodeIndex.hashCode() : 0;
        result2 = 31 * result2 + (this.myDownNodeIndex != null ? this.myDownNodeIndex.hashCode() : 0);
        result2 = 31 * result2 + (this.myTargetId != null ? this.myTargetId.hashCode() : 0);
        result2 = 31 * result2 + this.myType.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/api/elements/GraphEdge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/api/elements/GraphEdge";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNormalEdge";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createEdgeWithTargetId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

