/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SingleAlarm;
import com.intellij.util.xmlb.annotations.Attribute;
import com.jetbrains.rd.platform.diagnostics.LogTraceCategoriesListener;
import com.jetbrains.rd.platform.diagnostics.LogTraceScenarioBase;
import com.jetbrains.rd.util.PlatformDependentKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001e\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0007J\u0014\u0010\u0016\u001a\u00020\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00170\u000fJ\u0010\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0012H\u0002J\u0016\u0010\u001c\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u000fH\u0002R.\u0010\u0005\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006j\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "categoriesOldLevels", "Ljava/util/HashMap;", "Ljava/util/logging/Logger;", "Ljava/util/logging/Level;", "Lkotlin/collections/HashMap;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "syncAlarm", "Lcom/intellij/util/SingleAlarm;", "enabledScenarios", "", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenarioBase;", "registerAndSaveScenario", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "traceScenario", "save", "", "synchronizeToLogger", "immediately", "", "synchronizeToLoggerImmediately", "updateTraceCategories", "traceCategories", "Companion", "HolderEpBean", "LogTraceScenariosInitializer", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nLogTraceScenarioRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogTraceScenarioRegistry.kt\ncom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,233:1\n1603#2,9:234\n1855#2:243\n1856#2:245\n1612#2:246\n1360#2:247\n1446#2,5:248\n1#3:244\n13#4:253\n*S KotlinDebug\n*F\n+ 1 LogTraceScenarioRegistry.kt\ncom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry\n*L\n93#1:234,9\n93#1:243\n93#1:245\n93#1:246\n117#1:247\n117#1:248,5\n93#1:244\n35#1:253\n*E\n"})
public final class LogTraceScenariosRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final SingleAlarm syncAlarm;
    @NotNull
    private final HashMap<java.util.logging.Logger, Level> categoriesOldLevels;
    @NotNull
    private static final ExtensionPointName<HolderEpBean> HOLDER_EP_NAME = ExtensionPointName.Companion.create("com.intellij.rd.platform.traceScenarioHolder");
    @NotNull
    private static final ExtensionPointName<LogTraceCategoriesListener> TRACE_CATEGORIES_LISTENER_EP_NAME = new ExtensionPointName("com.intellij.rd.platform.logTraceCategoriesListener");
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Map<String, LogTraceScenarioBase> allValues;
    @NotNull
    private static final String TRACE_SCENARIOS_KEY = "rider.trace.scenarios";
    @NotNull
    private static final String TRACE_SCENARIOS_REGISTRY_KEY = "rd.forced.trace.scenarios";
    @NotNull
    private static final String delimiter = ",";

    public LogTraceScenariosRegistry(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.scope = scope;
        this.syncAlarm = new SingleAlarm(() -> LogTraceScenariosRegistry.syncAlarm$lambda$0(this), 100);
        this.categoriesOldLevels = new HashMap();
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @TestOnly
    public final void registerAndSaveScenario(@NotNull Lifetime lifetime, @NotNull LogTraceScenarioBase traceScenario) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)traceScenario, (String)"traceScenario");
        lifetime.bracketOrThrowEx((Function0)new Function0<List<? extends LogTraceScenarioBase>>(traceScenario, this){
            final /* synthetic */ LogTraceScenarioBase $traceScenario;
            final /* synthetic */ LogTraceScenariosRegistry this$0;
            {
                this.$traceScenario = $traceScenario;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<LogTraceScenarioBase> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                LogTraceScenarioBase prevValue = LogTraceScenariosRegistry.Companion.getAllValues().putIfAbsent(this.$traceScenario.getName(), this.$traceScenario);
                boolean bl = prevValue == null;
                Object object = this.$traceScenario;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$1$22 = false;
                    String $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$1$22 = (LogTraceScenarioBase)object + " already set: " + prevValue;
                    throw new AssertionError((Object)$i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$1$22);
                }
                List<LogTraceScenarioBase> current = this.this$0.enabledScenarios();
                object = CollectionsKt.plus((Collection)current, (Object)this.$traceScenario);
                LogTraceScenariosRegistry logTraceScenariosRegistry = this.this$0;
                boolean $i$f$map = false;
                void var5_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LogTraceScenarioBase logTraceScenarioBase = (LogTraceScenarioBase)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getName());
                }
                logTraceScenariosRegistry.save((List)destination$iv$iv);
                boolean bl3 = this.this$0.enabledScenarios().contains(this.$traceScenario);
                LogTraceScenarioBase logTraceScenarioBase = this.$traceScenario;
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl4 = false;
                    String string = "enabledScenarios do not contain " + logTraceScenarioBase + " after manual installation";
                    throw new AssertionError((Object)string);
                }
                return current;
            }
        }, (Function1)new Function1<List<? extends LogTraceScenarioBase>, Unit>(traceScenario, this){
            final /* synthetic */ LogTraceScenarioBase $traceScenario;
            final /* synthetic */ LogTraceScenariosRegistry this$0;
            {
                this.$traceScenario = $traceScenario;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull List<? extends LogTraceScenarioBase> it) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                boolean success = LogTraceScenariosRegistry.Companion.getAllValues().remove(this.$traceScenario.getName(), this.$traceScenario);
                LogTraceScenarioBase logTraceScenarioBase = this.$traceScenario;
                if (_Assertions.ENABLED && !success) {
                    boolean $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$522 = false;
                    String $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$522 = "Failed to remove trace scenario: " + logTraceScenarioBase + " from the map";
                    throw new AssertionError((Object)$i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$522);
                }
                List<LogTraceScenarioBase> enabledScenarios = this.this$0.enabledScenarios();
                boolean $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$522 = !enabledScenarios.contains(this.$traceScenario);
                LogTraceScenarioBase logTraceScenarioBase2 = this.$traceScenario;
                if (_Assertions.ENABLED && !$i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$522) {
                    boolean $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$42 = false;
                    String $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$42 = "enabledScenarios still contain " + logTraceScenarioBase2 + " after removing";
                    throw new AssertionError((Object)$i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$42);
                }
                Iterable $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$522 = enabledScenarios;
                LogTraceScenariosRegistry logTraceScenariosRegistry = this.this$0;
                boolean $i$f$map = false;
                void $i$a$-assert-LogTraceScenariosRegistry$registerAndSaveScenario$2$42 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    LogTraceScenarioBase logTraceScenarioBase3 = (LogTraceScenarioBase)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it2.getName());
                }
                logTraceScenariosRegistry.save((List)destination$iv$iv);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LogTraceScenarioBase> enabledScenarios() {
        void $this$mapNotNullTo$iv$iv;
        String systemPropertyScenario = System.getProperty(TRACE_SCENARIOS_REGISTRY_KEY, "") + delimiter;
        String string = PropertiesComponent.getInstance().getValue(TRACE_SCENARIOS_KEY, "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String savedScenarios = string;
        String all = systemPropertyScenario + savedScenarios;
        String[] stringArray = new String[]{delimiter};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)all, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LogTraceScenarioBase it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String name = (String)element$iv$iv;
            boolean bl2 = false;
            if (allValues.get(name) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    public final void save(@NotNull List<String> enabledScenarios) {
        Intrinsics.checkNotNullParameter(enabledScenarios, (String)"enabledScenarios");
        String newEnabledScenarios = CollectionsKt.joinToString$default((Iterable)enabledScenarios, (CharSequence)delimiter, null, null, (int)0, null, null, (int)62, null);
        logger.info("save trace enabled scenarios: " + newEnabledScenarios);
        PropertiesComponent.getInstance().setValue(TRACE_SCENARIOS_KEY, newEnabledScenarios);
        this.synchronizeToLogger(true);
    }

    public final void synchronizeToLogger(boolean immediately) {
        if (immediately) {
            this.syncAlarm.cancelAllRequests();
            this.synchronizeToLoggerImmediately();
        } else {
            SingleAlarm.request$default((SingleAlarm)this.syncAlarm, (boolean)false, (int)0, (int)3, null);
        }
    }

    public static /* synthetic */ void synchronizeToLogger$default(LogTraceScenariosRegistry logTraceScenariosRegistry, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        logTraceScenariosRegistry.synchronizeToLogger(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void synchronizeToLoggerImmediately() {
        java.util.logging.Logger logger;
        void $this$flatMapTo$iv$iv;
        List<LogTraceScenarioBase> enabledScenarios = this.enabledScenarios();
        Iterable $this$flatMap$iv = enabledScenarios;
        boolean $i$f$flatMap2 = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LogTraceScenarioBase it = (LogTraceScenarioBase)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getCategories();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List traceCategories = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        this.updateTraceCategories(traceCategories);
        for (Map.Entry<java.util.logging.Logger, Level> $i$f$flatMap2 : this.categoriesOldLevels.entrySet()) {
            Intrinsics.checkNotNull($i$f$flatMap2);
            logger = $i$f$flatMap2.getKey();
            Level level = $i$f$flatMap2.getValue();
            logger.setLevel(level);
        }
        this.categoriesOldLevels.clear();
        for (String category : traceCategories) {
            logger = java.util.logging.Logger.getLogger(category);
            Map map = this.categoriesOldLevels;
            Intrinsics.checkNotNull((Object)logger);
            map.put(logger, logger.getLevel());
            logger.setLevel(Level.FINER);
        }
    }

    private final void updateTraceCategories(List<String> traceCategories) {
        for (LogTraceCategoriesListener listener2 : (LogTraceCategoriesListener[])TRACE_CATEGORIES_LISTENER_EP_NAME.getExtensions()) {
            listener2.traceCategoriesUpdated(traceCategories);
        }
    }

    private static final void syncAlarm$lambda$0(LogTraceScenariosRegistry this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.synchronizeToLogger(true);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LogTraceScenariosRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LogTraceScenariosRegistry.logger = logger;
        allValues = PlatformDependentKt.concurrentMapOf();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$Companion;", "", "()V", "HOLDER_EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$HolderEpBean;", "TRACE_CATEGORIES_LISTENER_EP_NAME", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceCategoriesListener;", "getTRACE_CATEGORIES_LISTENER_EP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "TRACE_SCENARIOS_KEY", "", "TRACE_SCENARIOS_REGISTRY_KEY", "allValues", "", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenarioBase;", "getAllValues", "()Ljava/util/Map;", "delimiter", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry;", "loadTraceScenarioHolders", "", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nLogTraceScenarioRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogTraceScenarioRegistry.kt\ncom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n1549#2:234\n1620#2,3:235\n*S KotlinDebug\n*F\n+ 1 LogTraceScenarioRegistry.kt\ncom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$Companion\n*L\n48#1:234\n48#1:235,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<LogTraceCategoriesListener> getTRACE_CATEGORIES_LISTENER_EP_NAME() {
            return TRACE_CATEGORIES_LISTENER_EP_NAME;
        }

        @NotNull
        public final LogTraceScenariosRegistry getInstance() {
            Object object = ApplicationKt.getApplication().getService(LogTraceScenariosRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LogTraceScenariosRegistry)object;
        }

        /*
         * WARNING - void declaration
         */
        public final void loadTraceScenarioHolders() {
            for (LazyExtension item : HOLDER_EP_NAME.filterableLazySequence()) {
                try {
                    void $this$mapTo$iv$iv;
                    HolderEpBean holder;
                    if ((HolderEpBean)item.getInstance() == null) continue;
                    Class<?> clazz = Class.forName(holder.getImplementation(), true, item.getPluginDescriptor().getPluginClassLoader());
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
                    KClass holderClass = JvmClassMappingKt.getKotlinClass(clazz);
                    holderClass.getObjectInstance();
                    Iterable $this$map$iv = holderClass.getNestedClasses();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KClass kClass = (KClass)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getObjectInstance());
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                }
                catch (Throwable t) {
                    logger.error("Failed to load trace category " + item.getImplementationClassName(), t);
                }
            }
        }

        @NotNull
        public final Map<String, LogTraceScenarioBase> getAllValues() {
            return allValues;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$HolderEpBean;", "", "()V", "implementation", "", "getImplementation", "()Ljava/lang/String;", "setImplementation", "(Ljava/lang/String;)V", "intellij.rd.platform"})
    public static final class HolderEpBean {
        @Attribute
        @RequiredElement
        @NotNull
        private String implementation = "";

        @NotNull
        public final String getImplementation() {
            return this.implementation;
        }

        public final void setImplementation(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.implementation = string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/LogTraceScenariosRegistry$LogTraceScenariosInitializer;", "Lcom/intellij/ide/AppLifecycleListener;", "()V", "appFrameCreated", "", "commandLineArgs", "", "", "intellij.rd.platform"})
    public static final class LogTraceScenariosInitializer
    implements AppLifecycleListener {
        public void appFrameCreated(@NotNull List<String> commandLineArgs) {
            Intrinsics.checkNotNullParameter(commandLineArgs, (String)"commandLineArgs");
            CoroutineScope scope = Companion.getInstance().getScope();
            BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            LogTraceScenariosRegistry.Companion.loadTraceScenarioHolders();
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                                int label;

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            LogTraceScenariosRegistry.Companion.getInstance().synchronizeToLogger(true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }
}

