/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.ReflectionState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u0001*\u0004\u0018\u00010\u0002H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0002H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0002H\u0000\u001a\u0013\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u00a2\u0006\u0002\u0010\n\u001a\u000e\u0010\u000b\u001a\u0004\u0018\u00010\b*\u00020\u0002H\u0000\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a0\u0010\u000f\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0000\u001a\u0016\u0010\u0016\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u0014\u0010\u0019\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0000\u00a8\u0006\u001a"}, d2={"isNull", "", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "isUnit", "asInt", "", "asBoolean", "asString", "", "asBooleanOrNull", "(Lorg/jetbrains/kotlin/ir/interpreter/state/State;)Ljava/lang/Boolean;", "asStringOrNull", "isSubtypeOf", "other", "Lorg/jetbrains/kotlin/ir/types/IrType;", "checkNullability", "irType", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "exceptionToThrow", "Lkotlin/Function0;", "", "mustBeHandledAsReflection", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "hasTheSameFieldsWith", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 State.kt\norg/jetbrains/kotlin/ir/interpreter/state/StateKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n808#2,11:109\n626#2,12:120\n1863#2,2:132\n*S KotlinDebug\n*F\n+ 1 State.kt\norg/jetbrains/kotlin/ir/interpreter/state/StateKt\n*L\n70#1:109,11\n70#1:120,12\n100#1:132,2\n*E\n"})
public final class StateKt {
    public static final boolean isNull(@NotNull State $this$isNull) {
        Intrinsics.checkNotNullParameter((Object)$this$isNull, (String)"<this>");
        return $this$isNull instanceof Primitive && ((Primitive)$this$isNull).getValue() == null;
    }

    public static final boolean isUnit(@Nullable State $this$isUnit) {
        return $this$isUnit instanceof Common && Intrinsics.areEqual((Object)((Common)$this$isUnit).irClassFqName(), (Object)"kotlin.Unit");
    }

    public static final int asInt(@NotNull State $this$asInt) {
        Intrinsics.checkNotNullParameter((Object)$this$asInt, (String)"<this>");
        Object t = ((Primitive)$this$asInt).getValue();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Int");
        return (Integer)t;
    }

    public static final boolean asBoolean(@NotNull State $this$asBoolean) {
        Intrinsics.checkNotNullParameter((Object)$this$asBoolean, (String)"<this>");
        Object t = ((Primitive)$this$asBoolean).getValue();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)t;
    }

    @NotNull
    public static final String asString(@NotNull State $this$asString) {
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"<this>");
        return String.valueOf(((Primitive)$this$asString).getValue());
    }

    @Nullable
    public static final Boolean asBooleanOrNull(@NotNull State $this$asBooleanOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$asBooleanOrNull, (String)"<this>");
        Primitive primitive = $this$asBooleanOrNull instanceof Primitive ? (Primitive)$this$asBooleanOrNull : null;
        Object t = primitive != null ? primitive.getValue() : null;
        return t instanceof Boolean ? (Boolean)t : null;
    }

    @Nullable
    public static final String asStringOrNull(@NotNull State $this$asStringOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$asStringOrNull, (String)"<this>");
        Object t = ((Primitive)$this$asStringOrNull).getValue();
        return t instanceof String ? (String)t : null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSubtypeOf(@NotNull State $this$isSubtypeOf, @NotNull IrType other) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (StateKt.isNull($this$isSubtypeOf) && org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(other)) {
            return true;
        }
        if ($this$isSubtypeOf instanceof Primitive && ((Primitive)$this$isSubtypeOf).getValue() == null) {
            return org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(other);
        }
        if ($this$isSubtypeOf instanceof ExceptionState) {
            ExceptionState exceptionState = (ExceptionState)$this$isSubtypeOf;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(other);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            return exceptionState.isSubtypeOf((IrClass)irClassSymbol.getOwner());
        }
        if ($this$isSubtypeOf instanceof Primitive && (IrTypePredicatesKt.isArray(((Primitive)$this$isSubtypeOf).getType()) || IrTypePredicatesKt.isNullableArray(((Primitive)$this$isSubtypeOf).getType()))) {
            if (IrTypePredicatesKt.isArray(other)) return StateKt.isSubtypeOf$arraySubtypeCheck(((Primitive)$this$isSubtypeOf).getType(), other);
            if (IrTypePredicatesKt.isNullableArray(other)) {
                return StateKt.isSubtypeOf$arraySubtypeCheck(((Primitive)$this$isSubtypeOf).getType(), other);
            }
        }
        boolean bl = (object = IrTypesKt.getClassOrNull(other)) != null && (object = (IrClass)object.getOwner()) != null ? ((IrClass)object).isFun() : false;
        if (bl) {
            if (!($this$isSubtypeOf instanceof KFunctionState)) return false;
            IrType irType = ((KFunctionState)$this$isSubtypeOf).getFunInterface();
            if (irType == null) return false;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(other);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            if (!org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isSubtypeOfClass(irType, irClassSymbol)) return false;
            return true;
        }
        IrSimpleType thisType = IrUtilsKt.getDefaultType($this$isSubtypeOf.getIrClass());
        if (IrTypeUtilsKt.isFunction(other) && IrTypeUtilsKt.isKFunction(thisType)) {
            void $this$single$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = $this$isSubtypeOf.getIrClass().getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.INVOKE)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrSimpleFunction invokeFun = single$iv;
            IrClass irClass = IrUtilsKt.getParentAsClass(((IrSimpleFunctionSymbol)CollectionsKt.single(invokeFun.getOverriddenSymbols())).getOwner());
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(other);
            Intrinsics.checkNotNull((Object)irClassSymbol);
            return IrUtilsKt.isSubclassOf(irClass, (IrClass)irClassSymbol.getOwner());
        }
        IrType irType = thisType;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(other);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        return org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isSubtypeOfClass(irType, irClassSymbol);
    }

    @Nullable
    public static final State checkNullability(@NotNull State $this$checkNullability, @Nullable IrType irType, @NotNull IrInterpreterEnvironment environment, @NotNull Function0<? extends Throwable> exceptionToThrow) {
        Intrinsics.checkNotNullParameter((Object)$this$checkNullability, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(exceptionToThrow, (String)"exceptionToThrow");
        if (!(irType instanceof IrSimpleType)) {
            return $this$checkNullability;
        }
        if (StateKt.isNull($this$checkNullability) && !org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(irType)) {
            ExceptionUtilsKt.handleUserException((Throwable)exceptionToThrow.invoke(), environment);
            return null;
        }
        return $this$checkNullability;
    }

    public static /* synthetic */ State checkNullability$default(State state, IrType irType, IrInterpreterEnvironment irInterpreterEnvironment, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = StateKt::checkNullability$lambda$1;
        }
        return StateKt.checkNullability(state, irType, irInterpreterEnvironment, (Function0<? extends Throwable>)function0);
    }

    public static final boolean mustBeHandledAsReflection(@Nullable State $this$mustBeHandledAsReflection, @NotNull IrCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        IrSimpleFunction owner = (IrSimpleFunction)call.getSymbol().getOwner();
        if (owner.getBody() != null || Intrinsics.areEqual((Object)owner.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER())) {
            return false;
        }
        return $this$mustBeHandledAsReflection instanceof ReflectionState && (!($this$mustBeHandledAsReflection instanceof KFunctionState) || !KFunctionState.Companion.isCallToInvokeOrMethodFromFunInterface(call));
    }

    public static final boolean hasTheSameFieldsWith(@NotNull State $this$hasTheSameFieldsWith, @NotNull State other) {
        Intrinsics.checkNotNullParameter((Object)$this$hasTheSameFieldsWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ($this$hasTheSameFieldsWith.getFields().size() != other.getFields().size()) {
            return false;
        }
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)$this$hasTheSameFieldsWith.getFields().values(), (Iterable)other.getFields().values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            State firstState = (State)pair.component1();
            State secondState = (State)pair.component2();
            if (!(firstState instanceof Primitive && secondState instanceof Primitive ? !Intrinsics.areEqual(((Primitive)firstState).getValue(), ((Primitive)secondState).getValue()) : firstState != secondState)) continue;
            return false;
        }
        return true;
    }

    private static final boolean isSubtypeOf$arraySubtypeCheck(IrType $this$isSubtypeOf_u24arraySubtypeCheck, IrType other) {
        boolean bl;
        if (!(other instanceof IrSimpleType) || !($this$isSubtypeOf_u24arraySubtypeCheck instanceof IrSimpleType)) {
            return false;
        }
        IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.single(((IrSimpleType)$this$isSubtypeOf_u24arraySubtypeCheck).getArguments()));
        if (irType == null) {
            return false;
        }
        IrType thisArgument = irType;
        IrType irType2 = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.single(((IrSimpleType)other).getArguments()));
        if (irType2 == null) {
            return CollectionsKt.single(((IrSimpleType)other).getArguments()) instanceof IrStarProjection;
        }
        IrType otherArgument = irType2;
        if (IrTypePredicatesKt.isArray(thisArgument) && IrTypePredicatesKt.isArray(otherArgument)) {
            return StateKt.isSubtypeOf$arraySubtypeCheck(thisArgument, otherArgument);
        }
        if (IrTypesKt.getClassOrNull(otherArgument) == null) {
            return true;
        }
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(thisArgument);
        if (irClassSymbol != null) {
            IrClassifierSymbol irClassifierSymbol = irClassSymbol;
            IrClassSymbol irClassSymbol2 = IrTypesKt.getClassOrNull(otherArgument);
            Intrinsics.checkNotNull((Object)irClassSymbol2);
            bl = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isSubtypeOfClass(irClassifierSymbol, irClassSymbol2);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final NullPointerException checkNullability$lambda$1() {
        return new NullPointerException();
    }
}

