/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.util;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.text.StringKt;
import git4idea.remote.GitRemoteUrlCoordinates;
import git4idea.remote.hosting.GitHostingUrlUtil;
import java.net.URI;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.util.GitLabProjectPath$;

@Serializable
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \"2\u00020\u0001:\u0002!\"B7\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\r\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u0012\r\u0010\u0007\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u001f\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\u000e\u0010\u0010\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\r\b\u0002\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\r\b\u0002\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0012\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u0013H\u0007J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0018\u001a\u00020\u0005H\u0017J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u00c1\u0001\u00a2\u0006\u0002\b R\u0016\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;", "", "seen1", "", "owner", "", "Lcom/intellij/openapi/util/NlsSafe;", "name", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getOwner", "component1", "component2", "copy", "equals", "", "other", "fullPath", "withOwner", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_vcs_gitlab", "$serializer", "Companion", "intellij.vcs.gitlab"})
public final class GitLabProjectPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String owner;
    @NotNull
    private final String name;

    public GitLabProjectPath(@NotNull String owner, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.owner = owner;
        this.name = name;
    }

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NlsSafe
    @NotNull
    public final String fullPath(boolean withOwner) {
        return withOwner ? this.owner + "/" + this.name : this.name;
    }

    public static /* synthetic */ String fullPath$default(GitLabProjectPath gitLabProjectPath, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return gitLabProjectPath.fullPath(bl);
    }

    @NlsSafe
    @NotNull
    public String toString() {
        return this.owner + "/" + this.name;
    }

    @NotNull
    public final String component1() {
        return this.owner;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final GitLabProjectPath copy(@NotNull String owner, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new GitLabProjectPath(owner, name);
    }

    public static /* synthetic */ GitLabProjectPath copy$default(GitLabProjectPath gitLabProjectPath, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = gitLabProjectPath.owner;
        }
        if ((n & 2) != 0) {
            string2 = gitLabProjectPath.name;
        }
        return gitLabProjectPath.copy(string, string2);
    }

    public int hashCode() {
        int result2 = this.owner.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitLabProjectPath)) {
            return false;
        }
        GitLabProjectPath gitLabProjectPath = (GitLabProjectPath)other;
        if (!Intrinsics.areEqual((Object)this.owner, (Object)gitLabProjectPath.owner)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)gitLabProjectPath.name);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$intellij_vcs_gitlab(GitLabProjectPath self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeStringElement(serialDesc, 0, self.owner);
        output.encodeStringElement(serialDesc, 1, self.name);
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ GitLabProjectPath(int seen1, String owner, String name, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.owner = owner;
        this.name = name;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u00c6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath$Companion;", "", "()V", "create", "Lorg/jetbrains/plugins/gitlab/util/GitLabProjectPath;", "server", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "remote", "Lgit4idea/remote/GitRemoteUrlCoordinates;", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final GitLabProjectPath create(@NotNull GitLabServerPath server, @NotNull GitRemoteUrlCoordinates remote) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
            String serverPath = server.toURI().getPath();
            URI uRI = GitHostingUrlUtil.getUriFromRemoteUrl((String)remote.getUrl());
            String string = uRI != null ? uRI.getPath() : null;
            if (string == null) {
                return null;
            }
            String remotePath = string;
            Intrinsics.checkNotNull((Object)serverPath);
            if (!StringsKt.startsWith$default((String)remotePath, (String)serverPath, (boolean)false, (int)2, null)) {
                return null;
            }
            String repositoryPath = StringsKt.removePrefix((String)StringsKt.removePrefix((String)remotePath, (CharSequence)serverPath), (CharSequence)"/");
            int lastSlashIdx = StringsKt.lastIndexOf$default((CharSequence)repositoryPath, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (lastSlashIdx < 0) {
                return null;
            }
            String string2 = StringKt.nullize$default((String)StringsKt.substringAfterLast((String)repositoryPath, (char)'/', (String)""), (boolean)false, (int)1, null);
            if (string2 == null) {
                return null;
            }
            String name = string2;
            String string3 = StringKt.nullize$default((String)StringsKt.substringBeforeLast((String)repositoryPath, (char)'/', (String)""), (boolean)false, (int)1, null);
            if (string3 == null) {
                return null;
            }
            String owner = string3;
            return new GitLabProjectPath(owner, name);
        }

        @NotNull
        public final KSerializer<GitLabProjectPath> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

