/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import com.intellij.gradle.toolingExtension.impl.util.GradleTaskUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.ManifestInternal;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.War;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.web.WebConfiguration;
import org.jetbrains.plugins.gradle.tooling.AbstractModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.builder.CopySpecWalker;
import org.jetbrains.plugins.gradle.tooling.builder.WarModelBuilderImplKt;
import org.jetbrains.plugins.gradle.tooling.internal.web.WarModelImpl;
import org.jetbrains.plugins.gradle.tooling.internal.web.WebConfigurationImpl;
import org.jetbrains.plugins.gradle.tooling.internal.web.WebResourceImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/WarModelBuilderImpl;", "Lorg/jetbrains/plugins/gradle/tooling/AbstractModelBuilderService;", "()V", "buildAll", "", "modelName", "", "project", "Lorg/gradle/api/Project;", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "canBuild", "", "reportErrorMessage", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Companion", "intellij.gradle.toolingExtension.impl"})
public final class WarModelBuilderImpl
extends AbstractModelBuilderService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)WebConfiguration.class.getName(), (Object)modelName);
    }

    @Nullable
    public Object buildAll(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ((WarPlugin)project.getPlugins().findPlugin(WarPlugin.class) == null) {
            return null;
        }
        List warModels = new ArrayList();
        for (Task task : project.getTasks()) {
            if (!(task instanceof War)) continue;
            File webAppDir = null;
            String webAppDirName = null;
            if (WarModelBuilderImplKt.access$is82OrBetter$p()) {
                Object object = ((War)task).getWebAppDirectory().getAsFile().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                webAppDir = (File)object;
                String string = webAppDir.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                webAppDirName = string;
            } else {
                File file;
                String string = webAppDirName = !project.hasProperty("webAppDirName") ? "src/main/webapp" : String.valueOf(project.property("webAppDirName"));
                if (!project.hasProperty("webAppDir")) {
                    file = new File(project.getProjectDir(), webAppDirName);
                } else {
                    Object object = project.property("webAppDir");
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.io.File");
                    file = (File)object;
                }
                webAppDir = file;
            }
            String string = GradleTaskUtil.getTaskArchiveFileName((AbstractArchiveTask)task);
            Intrinsics.checkNotNull((Object)string);
            WarModelImpl warModel = new WarModelImpl(string, webAppDirName, webAppDir);
            List webResources = new ArrayList();
            War warTask = (War)task;
            warModel.setWebXml(warTask.getWebXml());
            try {
                CopySpecWalker.walk((CopySpec)warTask.getRootSpec(), new CopySpecWalker.Visitor(webResources, warTask){
                    final /* synthetic */ List<WebConfiguration.WebResource> $webResources;
                    final /* synthetic */ War $warTask;
                    {
                        this.$webResources = $webResources;
                        this.$warTask = $warTask;
                    }

                    public void visitSourcePath(@Nullable String relativePath, @NotNull String path) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        File file = new File(path);
                        org.jetbrains.plugins.gradle.tooling.builder.WarModelBuilderImpl$Companion.access$addPath(WarModelBuilderImpl.Companion, this.$webResources, relativePath, "", file.isAbsolute() ? file : new File(this.$warTask.getProject().getProjectDir(), path));
                    }

                    public void visitDir(@Nullable String relativePath, @NotNull FileVisitDetails dirDetails) {
                        Intrinsics.checkNotNullParameter((Object)dirDetails, (String)"dirDetails");
                        String string = dirDetails.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        File file = dirDetails.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                        org.jetbrains.plugins.gradle.tooling.builder.WarModelBuilderImpl$Companion.access$addPath(WarModelBuilderImpl.Companion, this.$webResources, relativePath, string, file);
                    }

                    public void visitFile(@Nullable String relativePath, @NotNull FileVisitDetails fileDetails) {
                        block3: {
                            block2: {
                                Intrinsics.checkNotNullParameter((Object)fileDetails, (String)"fileDetails");
                                if (this.$warTask.getWebXml() == null) break block2;
                                File file = this.$warTask.getWebXml();
                                if (fileDetails.getFile().getCanonicalPath().equals(file != null ? file.getCanonicalPath() : null)) break block3;
                            }
                            String string = fileDetails.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                            File file = fileDetails.getFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
                            org.jetbrains.plugins.gradle.tooling.builder.WarModelBuilderImpl$Companion.access$addPath(WarModelBuilderImpl.Companion, this.$webResources, relativePath, string, file);
                        }
                    }
                });
                FileCollection fileCollection = warTask.getClasspath();
                warModel.setClasspath(new LinkedHashSet(fileCollection != null ? fileCollection.getFiles() : null));
            }
            catch (Exception e) {
                this.reportErrorMessage(modelName, project, context, e);
            }
            warModel.setWebResources(webResources);
            warModel.setArchivePath(GradleTaskUtil.getTaskArchiveFile((AbstractArchiveTask)warTask));
            Manifest manifest = warTask.getManifest();
            if (manifest instanceof ManifestInternal) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ((ManifestInternal)manifest).writeTo((OutputStream)baos);
                warModel.setManifestContent(baos.toString(((ManifestInternal)manifest).getContentCharset()));
            }
            warModels.add(warModel);
        }
        return new WebConfigurationImpl(warModels);
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup("gradle.warConfigurationModel.group").withKind(Message.Kind.WARNING).withTitle("JEE project import failure").withText("Web Facets/Artifacts will not be configured properly").withException(exception).reportMessage(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/gradle/tooling/builder/WarModelBuilderImpl$Companion;", "", "()V", "addPath", "", "webResources", "", "Lorg/jetbrains/plugins/gradle/model/web/WebConfiguration$WebResource;", "warRelativePath", "", "fileRelativePath", "file", "Ljava/io/File;", "intellij.gradle.toolingExtension.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void addPath(List<WebConfiguration.WebResource> webResources, String warRelativePath, String fileRelativePath, File file) {
            String string = warRelativePath;
            if (string == null) {
                string = "";
            }
            String warRelativePathOrEmpty = string;
            WebResourceImpl webResource = new WebResourceImpl(warRelativePathOrEmpty, fileRelativePath, file);
            webResources.add(webResource);
        }

        public static final /* synthetic */ void access$addPath(Companion $this, List webResources, String warRelativePath, String fileRelativePath, File file) {
            $this.addPath(webResources, warRelativePath, fileRelativePath, file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

