/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.newmatch;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CascadedStyle {
    private final Map<CSSName, PropertyDeclaration> cascadedProperties;
    private String fingerprint;
    public static final CascadedStyle emptyCascadedStyle = new CascadedStyle();

    CascadedStyle(Iterator<PropertyDeclaration> iter) {
        this();
        this.addProperties(iter);
    }

    public static CascadedStyle createLayoutStyle(PropertyDeclaration[] decls) {
        return new CascadedStyle(Arrays.asList(decls).iterator());
    }

    public static CascadedStyle createLayoutStyle(List<PropertyDeclaration> decls) {
        return new CascadedStyle(decls.iterator());
    }

    public static CascadedStyle createLayoutStyle(CascadedStyle startingPoint, PropertyDeclaration[] decls) {
        return new CascadedStyle(startingPoint, Arrays.asList(decls).iterator());
    }

    public static PropertyDeclaration createLayoutPropertyDeclaration(CSSName cssName, IdentValue display) {
        PropertyValue val = new PropertyValue(display);
        return new PropertyDeclaration(cssName, val, true, 1);
    }

    private CascadedStyle(CascadedStyle startingPoint, Iterator<PropertyDeclaration> props) {
        this.cascadedProperties = new TreeMap<CSSName, PropertyDeclaration>(startingPoint.cascadedProperties);
        this.addProperties(props);
    }

    private CascadedStyle() {
        this.cascadedProperties = new TreeMap<CSSName, PropertyDeclaration>();
    }

    public static CascadedStyle createAnonymousStyle(IdentValue display) {
        PropertyValue val = new PropertyValue(display);
        List<PropertyDeclaration> props = Collections.singletonList(new PropertyDeclaration(CSSName.DISPLAY, val, true, 1));
        return new CascadedStyle(props.iterator());
    }

    private void addProperties(Iterator<PropertyDeclaration> iter) {
        List[] buckets = new List[6];
        while (iter.hasNext()) {
            PropertyDeclaration prop = iter.next();
            ArrayList<PropertyDeclaration> bucket = buckets[prop.getImportanceAndOrigin()];
            if (bucket == null) {
                buckets[prop.getImportanceAndOrigin()] = bucket = new ArrayList<PropertyDeclaration>();
            }
            bucket.add(prop);
        }
        for (List bucket : buckets) {
            if (bucket == null) continue;
            for (PropertyDeclaration prop : bucket) {
                this.cascadedProperties.put(prop.getCSSName(), prop);
            }
        }
    }

    public boolean hasProperty(CSSName cssName) {
        return this.cascadedProperties.containsKey(cssName);
    }

    public PropertyDeclaration propertyByName(CSSName cssName) {
        return this.cascadedProperties.get(cssName);
    }

    public IdentValue getIdent(CSSName cssName) {
        PropertyDeclaration pd = this.propertyByName(cssName);
        return pd == null ? null : pd.asIdentValue();
    }

    public Collection<PropertyDeclaration> getCascadedPropertyDeclarations() {
        return this.cascadedProperties.values();
    }

    public int countAssigned() {
        return this.cascadedProperties.size();
    }

    public String getFingerprint() {
        if (this.fingerprint == null) {
            StringBuilder sb = new StringBuilder();
            for (PropertyDeclaration o : this.cascadedProperties.values()) {
                sb.append(o.getFingerprint());
            }
            this.fingerprint = sb.toString();
        }
        return this.fingerprint;
    }
}

