/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.footnotes.internal;

import com.vladsch.flexmark.ext.footnotes.Footnote;
import com.vladsch.flexmark.ext.footnotes.FootnoteBlock;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeRepository;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FootnoteRepository
extends NodeRepository<FootnoteBlock> {
    private ArrayList<FootnoteBlock> referencedFootnoteBlocks = new ArrayList();

    public static void resolveFootnotes(Document document2) {
        FootnoteRepository footnoteRepository = FootnoteExtension.FOOTNOTES.get(document2);
        boolean[] hadNewFootnotes = new boolean[]{false};
        NodeVisitor visitor = new NodeVisitor(new VisitHandler<Footnote>(Footnote.class, node -> {
            FootnoteBlock footonoteBlock;
            if (!node.isDefined() && (footonoteBlock = node.getFootnoteBlock(footnoteRepository)) != null) {
                footnoteRepository.addFootnoteReference(footonoteBlock, (Footnote)node);
                node.setFootnoteBlock(footonoteBlock);
                hadNewFootnotes[0] = true;
            }
        }));
        visitor.visit(document2);
        if (hadNewFootnotes[0]) {
            footnoteRepository.resolveFootnoteOrdinals();
        }
    }

    public void addFootnoteReference(FootnoteBlock footnoteBlock, Footnote footnote) {
        if (!footnoteBlock.isReferenced()) {
            this.referencedFootnoteBlocks.add(footnoteBlock);
        }
        footnoteBlock.setFirstReferenceOffset(footnote.getStartOffset());
        int referenceOrdinal = footnoteBlock.getFootnoteReferences();
        footnoteBlock.setFootnoteReferences(referenceOrdinal + 1);
        footnote.setReferenceOrdinal(referenceOrdinal);
    }

    public void resolveFootnoteOrdinals() {
        Collections.sort(this.referencedFootnoteBlocks, (f1, f2) -> f1.getFirstReferenceOffset() - f2.getFirstReferenceOffset());
        int ordinal = 0;
        for (FootnoteBlock footnoteBlock : this.referencedFootnoteBlocks) {
            footnoteBlock.setFootnoteOrdinal(++ordinal);
        }
    }

    public List<FootnoteBlock> getReferencedFootnoteBlocks() {
        return this.referencedFootnoteBlocks;
    }

    public FootnoteRepository(DataHolder options) {
        super(FootnoteExtension.FOOTNOTES_KEEP.get(options));
    }

    @Override
    @NotNull
    public DataKey<FootnoteRepository> getDataKey() {
        return FootnoteExtension.FOOTNOTES;
    }

    @Override
    @NotNull
    public DataKey<KeepType> getKeepDataKey() {
        return FootnoteExtension.FOOTNOTES_KEEP;
    }

    @Override
    @NotNull
    public Set<FootnoteBlock> getReferencedElements(Node parent) {
        HashSet<FootnoteBlock> references = new HashSet<FootnoteBlock>();
        this.visitNodes(parent, value2 -> {
            FootnoteBlock reference;
            if (value2 instanceof Footnote && (reference = ((Footnote)value2).getReferenceNode(this)) != null) {
                references.add(reference);
            }
        }, Footnote.class);
        return references;
    }
}

